/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.user;

import java.util.List;
import java.util.Map;
import org.dspace.services.model.Evidence;
import org.dspace.services.model.User;
import org.dspace.services.model.UserSearch;
import org.dspace.services.user.MemoryUserAuthnProvider;
import org.dspace.services.user.MemoryUserAuthzProvider;
import org.dspace.services.user.MemoryUserLookupProvider;
import org.dspace.services.user.MockUserLookupProvider;
import org.dspace.services.user.ProvidedUserService;
import org.dspace.services.user.UserManagingService;
import org.dspace.test.AbstractUserServiceTest;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProvidedUserServiceTest
extends AbstractUserServiceTest {
    private static MockUserLookupProvider lookupProvider;

    @BeforeClass
    public static void beforeTests() {
        String pName1 = "dspace.activator.class.user_lookup_mem";
        System.setProperty(pName1, MemoryUserLookupProvider.class.getName());
        String pName2 = "dspace.activator.class.user_authn_mem";
        System.setProperty(pName2, MemoryUserAuthnProvider.class.getName());
        String pName3 = "dspace.activator.class.user_authz_mem";
        System.setProperty(pName3, MemoryUserAuthzProvider.class.getName());
        ProvidedUserServiceTest._beforeUserTests();
        System.clearProperty(pName1);
        System.clearProperty(pName2);
        System.clearProperty(pName3);
        userService = (UserManagingService)ProvidedUserServiceTest.getService(ProvidedUserService.class);
        ProvidedUserServiceTest.getRequestService().startRequest();
        ProvidedUserServiceTest._preloadData(userService);
        ProvidedUserServiceTest.getRequestService().endRequest(null);
        lookupProvider = new MockUserLookupProvider();
        ProvidedUserServiceTest.getServiceManager().registerService(MockUserLookupProvider.class.getName(), (Object)lookupProvider);
    }

    @Before
    public void before() {
        this._beforeUserTest();
        Assert.assertNotNull((Object)sessionService);
        Assert.assertNotNull((Object)userService);
        Assert.assertNotNull((Object)lookupProvider);
    }

    @After
    public void after() {
        this._afterUserTest();
    }

    @AfterClass
    public static void afterTests() {
        ProvidedUserServiceTest._afterUserTests();
    }

    @Test
    public void providerBobTest() {
        String userEid = ProvidedUserServiceTest.lookupProvider.bob.getEid();
        Assert.assertNotNull((Object)userEid);
        String userId = userService.getUserIdFromEid(userEid, Evidence.UserEidType.USERNAME);
        Assert.assertNotNull((Object)userId);
        User u = userService.getUserById(userId);
        Assert.assertEquals((Object)ProvidedUserServiceTest.lookupProvider.bob, (Object)u);
    }

    @Test
    public void providerSallyTest() {
        String userEid = ProvidedUserServiceTest.lookupProvider.sally.getEid();
        Assert.assertNotNull((Object)userEid);
        String userId = userService.getUserIdFromEid(userEid, Evidence.UserEidType.USERNAME);
        Assert.assertNotNull((Object)userId);
        User u = userService.getUserById(userId);
        Assert.assertEquals((Object)ProvidedUserServiceTest.lookupProvider.sally, (Object)u);
    }

    @Test
    public void testGetMoreUsersByIds() {
        String bobUserId = userService.getUserIdFromEid(ProvidedUserServiceTest.lookupProvider.bob.getEid(), Evidence.UserEidType.USERNAME);
        Assert.assertNotNull((Object)bobUserId);
        String sallyUserId = userService.getUserIdFromEid(ProvidedUserServiceTest.lookupProvider.sally.getEid(), Evidence.UserEidType.USERNAME);
        Assert.assertNotNull((Object)sallyUserId);
        Map users = userService.getUsersByIds(new String[]{bobUserId});
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)ProvidedUserServiceTest.lookupProvider.bob, users.get(bobUserId));
        users = userService.getUsersByIds(new String[]{bobUserId, sallyUserId});
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)2L, (long)users.size());
        Assert.assertEquals((Object)ProvidedUserServiceTest.lookupProvider.bob, users.get(bobUserId));
        Assert.assertEquals((Object)ProvidedUserServiceTest.lookupProvider.sally, users.get(sallyUserId));
    }

    @Test
    public void testGetMoreUsersBySearch() {
        UserSearch search = new UserSearch();
        search.addUserSearch(UserSearch.SearchFields.USERNAME, "bob", 0);
        List users = userService.getUsersBySearch(search);
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)ProvidedUserServiceTest.lookupProvider.bob, users.get(0));
        search.reset();
        search.addUserSearch(UserSearch.SearchFields.USERNAME, "provided", 0);
        users = userService.getUsersBySearch(search);
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)2L, (long)users.size());
        Assert.assertEquals((Object)ProvidedUserServiceTest.lookupProvider.bob, users.get(0));
        Assert.assertEquals((Object)ProvidedUserServiceTest.lookupProvider.sally, users.get(1));
    }
}

