/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dspace.services.MappingService;
import org.dspace.services.model.IdEidMap;
import org.dspace.test.DSpaceAbstractTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractMappingServiceTest
extends DSpaceAbstractTest {
    private static MappingService mappingService;
    private static IdEidMap mapping1;
    private static IdEidMap mapping2;
    private static IdEidMap mapping3;
    private static IdEidMap mapping4;
    long totalCount = 0L;

    public static void _beforeMappingTests() {
        AbstractMappingServiceTest._initializeKernel();
        AbstractMappingServiceTest._initializeRequestService();
        mappingService = AbstractMappingServiceTest.getService(MappingService.class);
        AbstractMappingServiceTest.getRequestService().startRequest();
        AbstractMappingServiceTest.saveMapping(mapping1, mappingService);
        AbstractMappingServiceTest.saveMapping(mapping2, mappingService);
        AbstractMappingServiceTest.saveMapping(mapping3, mappingService);
        AbstractMappingServiceTest.saveMapping(mapping4, mappingService);
        AbstractMappingServiceTest.getRequestService().endRequest(null);
    }

    public static void _afterMappingTests() {
        mappingService = null;
        AbstractMappingServiceTest._destroyRequestService();
        AbstractMappingServiceTest._destroyKernel();
    }

    public void _beforeMappingTest() {
        this._startRequest();
    }

    public void _afterMappingTest() {
        this._endRequest();
    }

    protected static void saveMapping(IdEidMap mapping, MappingService mappingService) {
        IdEidMap iem = mappingService.saveMapping(mapping.getMappedType(), mapping.getMappedId(), mapping.getMappedEid());
        Assert.assertNotNull((Object)iem);
        mapping.setId(iem.getId());
    }

    @Before
    public void assureInitialState() {
        ArrayList l = new ArrayList();
        l.addAll(mappingService.getByType("user"));
        l.addAll(mappingService.getByType("test"));
        Assert.assertTrue((l.size() >= 4 ? 1 : 0) != 0);
    }

    @Test
    public void testFindMappings() {
        Map m = mappingService.findMappings("test", new String[]{mapping3.getMappedId(), mapping4.getMappedId()}, true);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)2L, (long)m.size());
        Assert.assertEquals((Object)mapping3, m.get(mapping3.getMappedId()));
        Assert.assertEquals((Object)mapping4, m.get(mapping4.getMappedId()));
        m = mappingService.findMappings("test", new String[]{mapping3.getMappedEid(), mapping4.getMappedEid()}, false);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)2L, (long)m.size());
        Assert.assertEquals((Object)mapping3, m.get(mapping3.getMappedEid()));
        Assert.assertEquals((Object)mapping4, m.get(mapping4.getMappedEid()));
        m = mappingService.findMappings("test", new String[]{"XXXX", "YYYYY"}, true);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((long)0L, (long)m.size());
    }

    @Test
    public void testGetByType() {
        List l = mappingService.getByType("test");
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)2L, (long)l.size());
        l = mappingService.getByType("XXXXXXXX");
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)0L, (long)l.size());
    }

    @Test
    public void testGetEidFromId() {
        String eid = mappingService.getEidFromId("test", mapping3.getMappedId());
        Assert.assertNotNull((Object)eid);
        Assert.assertEquals((Object)eid, (Object)mapping3.getMappedEid());
    }

    @Test
    public void testGetIdFromEid() {
        String id = mappingService.getIdFromEid("test", mapping3.getMappedEid());
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((Object)id, (Object)mapping3.getMappedId());
    }

    @Test
    public void testGetMapping() {
        IdEidMap mapping = mappingService.getMapping(mapping2.getMappedType(), mapping2.getMappedId(), mapping2.getMappedEid());
        Assert.assertNotNull((Object)mapping);
        Assert.assertEquals((Object)mapping2, (Object)mapping);
        mapping = mappingService.getMapping("XXXXXXX", mapping2.getMappedId(), mapping2.getMappedEid());
        Assert.assertNull((Object)mapping);
    }

    @Test
    public void testSaveMapping() {
        Assert.assertNotNull((Object)mappingService.getMapping(mapping2.getMappedType(), mapping2.getMappedId(), mapping2.getMappedEid()));
        IdEidMap iem = mappingService.saveMapping(mapping2.getMappedType(), mapping2.getMappedId(), mapping2.getMappedEid());
        Assert.assertNull((Object)iem);
        Assert.assertNull((Object)mappingService.getMapping("user", "65987", "minerva"));
        iem = mappingService.saveMapping("user", "65987", "minerva");
        Assert.assertNotNull((Object)iem);
        IdEidMap iem2 = mappingService.getMapping("user", "65987", "minerva");
        Assert.assertNotNull((Object)iem2);
        Assert.assertEquals((Object)iem, (Object)iem2);
    }

    @Test
    public void testDeleteById() {
        IdEidMap iem = mappingService.deleteById(mapping1.getId().intValue());
        Assert.assertNotNull((Object)iem);
        IdEidMap iem2 = mappingService.getMapping(mapping1.getMappedType(), mapping1.getMappedId(), mapping1.getMappedEid());
        Assert.assertNull((Object)iem2);
        Assert.assertNull((Object)mappingService.deleteById(9999));
    }

    static {
        mapping1 = new IdEidMap("user", "123456", "aaronz");
        mapping2 = new IdEidMap("user", "7890", "beckyz");
        mapping3 = new IdEidMap("test", "aaaaaaa", "groupA");
        mapping4 = new IdEidMap("test", "bbbbbbb", "groupB");
    }
}

