/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.test;

import java.util.List;
import org.dspace.services.mixins.StorageWriteable;
import org.dspace.services.model.StorageEntity;
import org.dspace.services.model.StorageProperty;
import org.dspace.test.DSpaceAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractStorageServiceTest
extends DSpaceAbstractTest {
    public StorageWriteable storageService;
    public static StorageEntity se1;
    public static StorageEntity se2;
    public static StorageEntity se3;

    public static void _preloadData(StorageWriteable storageService) {
        se1 = new StorageEntity("apple", "/trees/fruit", new StorageProperty[]{new StorageProperty("test", "TESTING"), new StorageProperty("num", 10L)});
        storageService.createEntity(se1);
        se2 = new StorageEntity("plum", "/trees/fruit");
        storageService.createEntity(se2);
        se3 = new StorageEntity("banana", "/trees/fruit");
        storageService.createEntity(se3);
    }

    public static void _beforeStorageTests() {
        AbstractStorageServiceTest._initializeKernel();
        AbstractStorageServiceTest._initializeRequestService();
    }

    public void _beforeStorageTest() {
        this._startRequest();
    }

    public void _afterStorageTest() {
        this._endRequest();
    }

    public static void _afterStorageTests() {
        se1 = null;
        se2 = null;
        se3 = null;
        AbstractStorageServiceTest._destroyRequestService();
        AbstractStorageServiceTest._destroyKernel();
    }

    @Test
    public void testExists() {
        boolean exists = this.storageService.exists("/fake/thing");
        Assert.assertFalse((boolean)exists);
        exists = this.storageService.exists("/trees/pine");
        Assert.assertFalse((boolean)exists);
        exists = this.storageService.exists("/trees");
        Assert.assertTrue((boolean)exists);
        exists = this.storageService.exists("/trees/fruit");
        Assert.assertTrue((boolean)exists);
        exists = this.storageService.exists(se1.getReference());
        Assert.assertTrue((boolean)exists);
        exists = this.storageService.exists(se1.getReference());
        Assert.assertTrue((boolean)exists);
        exists = this.storageService.exists(se2.getReference());
        Assert.assertTrue((boolean)exists);
        exists = this.storageService.exists(se3.getReference());
        Assert.assertTrue((boolean)exists);
    }

    @Test
    public void testExistsById() {
        boolean exists = this.storageService.existsById(se1.getId() + se2.getId() + se3.getId());
        Assert.assertFalse((boolean)exists);
        exists = this.storageService.existsById(se1.getId() + "");
        Assert.assertTrue((boolean)exists);
        exists = this.storageService.existsById(se1.getId());
        Assert.assertTrue((boolean)exists);
        exists = this.storageService.existsById(se1.getId());
        Assert.assertTrue((boolean)exists);
        exists = this.storageService.existsById(se2.getId());
        Assert.assertTrue((boolean)exists);
        exists = this.storageService.existsById(se3.getId());
        Assert.assertTrue((boolean)exists);
    }

    @Test
    public void testGetEntity() {
        StorageEntity se = null;
        se = this.storageService.getEntity("/fake/thing");
        Assert.assertNull((Object)se);
        se = this.storageService.getEntity(se1.getReference());
        Assert.assertNotNull((Object)se);
        Assert.assertEquals((Object)se1, (Object)se);
        Assert.assertEquals((Object)se1.getReference(), (Object)se.getReference());
        Assert.assertEquals((Object)se1.getPath(), (Object)se.getPath());
        Assert.assertEquals((Object)se1.getName(), (Object)se.getName());
        Assert.assertEquals((long)0L, (long)se.getChildrenNames().size());
        se = this.storageService.getEntity(se2.getReference());
        Assert.assertNotNull((Object)se);
        Assert.assertEquals((Object)se2, (Object)se);
        Assert.assertEquals((long)0L, (long)se.getChildrenNames().size());
        se = this.storageService.getEntity("/");
        Assert.assertNotNull((Object)se);
        Assert.assertEquals((Object)"/", (Object)se.getReference());
        Assert.assertEquals((long)1L, (long)se.getChildrenNames().size());
        se = this.storageService.getEntity("/trees");
        Assert.assertNotNull((Object)se);
        Assert.assertEquals((Object)"/trees", (Object)se.getReference());
        Assert.assertEquals((Object)"/", (Object)se.getPath());
        Assert.assertEquals((Object)"trees", (Object)se.getName());
        Assert.assertEquals((long)1L, (long)se.getChildrenNames().size());
        se = this.storageService.getEntity("/trees/fruit");
        Assert.assertNotNull((Object)se);
        Assert.assertEquals((Object)"/trees/fruit", (Object)se.getReference());
        Assert.assertEquals((Object)"/trees", (Object)se.getPath());
        Assert.assertEquals((Object)"fruit", (Object)se.getName());
        Assert.assertEquals((long)3L, (long)se.getChildrenNames().size());
    }

    @Test
    public void testGetEntityById() {
        StorageEntity se = null;
        se = this.storageService.getEntityById(se1.getId() + se2.getId() + se3.getId());
        Assert.assertNull((Object)se);
        se = this.storageService.getEntityById(se1.getId());
        Assert.assertNotNull((Object)se);
        Assert.assertEquals((Object)se1, (Object)se);
        Assert.assertEquals((Object)se1.getId(), (Object)se.getId());
        Assert.assertEquals((Object)se1.getReference(), (Object)se.getReference());
        Assert.assertEquals((Object)se1.getPath(), (Object)se.getPath());
        Assert.assertEquals((Object)se1.getName(), (Object)se.getName());
        Assert.assertEquals((long)0L, (long)se.getChildrenNames().size());
        se = this.storageService.getEntityById(se2.getId());
        Assert.assertNotNull((Object)se);
        Assert.assertEquals((Object)se2, (Object)se);
        Assert.assertEquals((long)0L, (long)se.getChildrenNames().size());
    }

    @Test
    public void testGetEntities() {
        List l = null;
        l = this.storageService.getEntities("");
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)1L, (long)l.size());
        l = this.storageService.getEntities("/trees");
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)1L, (long)l.size());
        l = this.storageService.getEntities("/trees/fruit");
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)3L, (long)l.size());
        Assert.assertTrue((boolean)l.contains(se1));
        Assert.assertTrue((boolean)l.contains(se2));
        Assert.assertTrue((boolean)l.contains(se3));
        l = this.storageService.getEntities("/trees/xxxxxx");
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)0L, (long)l.size());
    }

    @Test
    public void testCreateEntity() {
        List l = null;
        l = this.storageService.getEntities("/trees");
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)1L, (long)l.size());
        StorageEntity se = new StorageEntity("palm", "/trees");
        this.storageService.createEntity(se);
        l = this.storageService.getEntities("/trees");
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)2L, (long)l.size());
        Assert.assertNotNull((Object)se.getId());
    }

    @Test
    public void testDeleteEntity() {
        List l = null;
        l = this.storageService.getEntities("/trees/fruit");
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)3L, (long)l.size());
        this.storageService.deleteEntity(se1.getReference());
        Assert.assertNull((Object)this.storageService.getEntity(se1.getReference()));
        l = this.storageService.getEntities("/trees/fruit");
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)2L, (long)l.size());
        this.storageService.deleteEntity("/trees/fruit");
        Assert.assertNull((Object)this.storageService.getEntity("/trees/fruit"));
        l = this.storageService.getEntities("/trees/fruit");
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)0L, (long)l.size());
    }

    @Test
    public void testUpdateEntity() {
        Assert.assertEquals((long)2L, (long)se1.getProperties().size());
        this.storageService.updateEntity(se1);
        StorageProperty sp = new StorageProperty("new", "NEW");
        se1.getProperties().add(sp);
        this.storageService.updateEntity(se1);
        Assert.assertEquals((long)3L, (long)se1.getProperties().size());
        StorageEntity seOne = this.storageService.getEntity(se1.getReference());
        Assert.assertEquals((long)3L, (long)seOne.getProperties().size());
        se1.getProperties().remove(sp);
        Assert.assertEquals((long)2L, (long)se1.getProperties().size());
        this.storageService.updateEntity(se1);
        seOne = this.storageService.getEntity(se1.getReference());
        Assert.assertEquals((long)2L, (long)seOne.getProperties().size());
    }
}

