/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.test;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dspace.providers.exception.AuthenticationException;
import org.dspace.services.SessionService;
import org.dspace.services.model.Evidence;
import org.dspace.services.model.EvidencePassword;
import org.dspace.services.model.Session;
import org.dspace.services.model.User;
import org.dspace.services.model.UserSearch;
import org.dspace.services.user.UserManagingService;
import org.dspace.test.DSpaceAbstractTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractUserServiceTest
extends DSpaceAbstractTest {
    public static final String TEST_PERM = "test.permission";
    public static final String TEST_REF = "/test/reference";
    public static User aaronz;
    public static User becky;
    public static User kitty;
    public static UserManagingService userService;
    public static SessionService sessionService;

    public static void _beforeUserTests() {
        AbstractUserServiceTest._initializeKernel();
        AbstractUserServiceTest._initializeRequestService();
        sessionService = AbstractUserServiceTest.getService(SessionService.class);
    }

    public static void _afterUserTests() {
        sessionService = null;
        userService = null;
        AbstractUserServiceTest._destroyRequestService();
        AbstractUserServiceTest._destroyKernel();
    }

    public void _beforeUserTest() {
        this._startRequest();
    }

    public void _afterUserTest() {
        this._endRequest();
    }

    public static void _preloadData(UserManagingService managingService) {
        aaronz = new User("aaronz", "azeckoski@gmail.com", "admin", "Aaron Zeckoski", "Zeckoski, Aaron", "azpassword");
        becky = new User("beckyz", "rzeckoski@gmail.com", "admin", "Rebecca Zeckoski", "Zeckoski, Rebecca", "beckypass");
        kitty = new User("kitty", null, "admin");
        aaronz = managingService.saveUser(aaronz);
        becky = managingService.saveUser(becky);
        kitty = managingService.saveUser(kitty);
        managingService.saveAuthz(aaronz.getId(), TEST_PERM, TEST_REF);
    }

    @Test
    public void testGetCurrentUserId() {
        String current = userService.getCurrentUserId();
        Assert.assertNull((Object)current);
        Session session = sessionService.startSession("az1");
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"az1", (Object)session.getId());
        Assert.assertEquals(null, (Object)session.getUserId());
        current = userService.getCurrentUserId();
        Assert.assertNull((Object)current);
        sessionService.bindSession(session.getId(), aaronz.getId(), aaronz.getEid());
        current = userService.getCurrentUserId();
        Assert.assertNotNull((Object)current);
        Assert.assertEquals((Object)aaronz.getId(), (Object)current);
    }

    @Test
    public void testGetUserById() {
        User user = null;
        user = userService.getUserById(aaronz.getId());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)aaronz, (Object)user);
        user = userService.getUserById("-1000");
        Assert.assertNull((Object)user);
        try {
            userService.getUserById(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testGetUserIdFromEid() {
        String id = null;
        id = userService.getUserIdFromEid(aaronz.getEid(), Evidence.UserEidType.ENTERPRISE_ID);
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((Object)aaronz.getId(), (Object)id);
        id = userService.getUserIdFromEid(aaronz.getEid(), Evidence.UserEidType.USERNAME);
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((Object)aaronz.getId(), (Object)id);
        id = userService.getUserIdFromEid(aaronz.getId(), Evidence.UserEidType.INTERNAL_ID);
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((Object)aaronz.getId(), (Object)id);
        id = userService.getUserIdFromEid("XXXX", Evidence.UserEidType.INTERNAL_ID);
        Assert.assertNull((Object)id);
        try {
            userService.getUserIdFromEid(null, null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testGetUserEIDfromID() {
        String eid = null;
        eid = userService.getUserEIDfromID(aaronz.getId());
        Assert.assertNotNull((Object)eid);
        Assert.assertEquals((Object)eid, (Object)aaronz.getEid());
        eid = userService.getUserEIDfromID(becky.getId());
        Assert.assertNotNull((Object)eid);
        Assert.assertEquals((Object)eid, (Object)becky.getEid());
        eid = userService.getUserEIDfromID("-1000");
        Assert.assertNull((Object)eid);
        try {
            userService.getUserEIDfromID(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testGetUserLocale() {
        Locale locale = null;
        locale = userService.getUserLocale(aaronz.getId());
        Assert.assertNotNull((Object)locale);
        try {
            userService.getUserLocale("XXXXXXXXX");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            userService.getUserLocale(null);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testGetUsersByIds() {
        Map users = userService.getUsersByIds(new String[0]);
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)0L, (long)users.size());
        users = userService.getUsersByIds(null);
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)0L, (long)users.size());
        users = userService.getUsersByIds(new String[]{aaronz.getId()});
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)aaronz, users.get(aaronz.getId()));
        users = userService.getUsersByIds(new String[]{aaronz.getId(), becky.getId(), "XXXX"});
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)2L, (long)users.size());
        Assert.assertEquals((Object)aaronz, users.get(aaronz.getId()));
        Assert.assertEquals((Object)becky, users.get(becky.getId()));
    }

    @Test
    public void testGetUsersBySearch() {
        UserSearch search = new UserSearch();
        List users = userService.getUsersBySearch(search);
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)0L, (long)users.size());
        search.addUserSearch(UserSearch.SearchFields.USERNAME, "aaronz", 0);
        users = userService.getUsersBySearch(search);
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)aaronz, users.get(0));
        search.reset();
        search.addUserSearch(UserSearch.SearchFields.FULLNAME, "%Zeckoski", 3);
        users = userService.getUsersBySearch(search);
        Assert.assertNotNull((Object)users);
        Assert.assertEquals((long)2L, (long)users.size());
        Assert.assertEquals((Object)aaronz, users.get(0));
        Assert.assertEquals((Object)becky, users.get(1));
    }

    @Test
    public void testAuthenticate() {
        String userId;
        try {
            userId = userService.authenticate((Evidence)new EvidencePassword(aaronz.getEid(), aaronz.getPassword()));
        }
        catch (AuthenticationException e) {
            userId = null;
            Assert.fail((String)"did not authenticate aaronz");
        }
        Assert.assertNotNull(userId);
        Assert.assertEquals((Object)aaronz.getId(), (Object)userId);
        try {
            userId = userService.authenticate((Evidence)new EvidencePassword(aaronz.getEid(), ""));
            Assert.fail((String)"should not authenticate aaronz");
        }
        catch (AuthenticationException e) {
            userId = null;
        }
        Assert.assertNull((Object)userId);
    }

    @Test
    public void testIsUserAdmin() {
        boolean admin = userService.isUserAdmin(aaronz.getId());
        Assert.assertFalse((boolean)admin);
        String adminId = userService.getUserIdFromEid("admin", Evidence.UserEidType.USERNAME);
        admin = userService.isUserAdmin(adminId);
        Assert.assertTrue((boolean)admin);
    }

    @Test
    public void testIsUserAllowedOnRef() {
        boolean allowed = userService.isUserAllowedOnRef(aaronz.getId(), TEST_PERM, TEST_REF);
        Assert.assertTrue((boolean)allowed);
        allowed = userService.isUserAllowedOnRef(aaronz.getId(), "XXXXXX", TEST_REF);
        Assert.assertFalse((boolean)allowed);
        allowed = userService.isUserAllowedOnRef(aaronz.getId(), TEST_PERM, "XXXXX");
        Assert.assertFalse((boolean)allowed);
        allowed = userService.isUserAllowedOnRef(becky.getId(), TEST_PERM, TEST_REF);
        Assert.assertFalse((boolean)allowed);
        try {
            userService.isUserAllowedOnRef(becky.getId(), null, TEST_REF);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            userService.isUserAllowedOnRef(becky.getId(), "", TEST_REF);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            userService.isUserAllowedOnRef(null, "", TEST_REF);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testGetPermsForUserAndRef() {
        List perms = userService.getPermsForUserAndRef(aaronz.getId(), TEST_REF);
        Assert.assertNotNull((Object)perms);
        Assert.assertEquals((long)1L, (long)perms.size());
        Assert.assertEquals((Object)TEST_PERM, perms.get(0));
        perms = userService.getPermsForUserAndRef(becky.getId(), TEST_REF);
        Assert.assertNotNull((Object)perms);
        Assert.assertEquals((long)0L, (long)perms.size());
        perms = userService.getPermsForUserAndRef(aaronz.getId(), "XXXXXXXXXX");
        Assert.assertNotNull((Object)perms);
        Assert.assertEquals((long)0L, (long)perms.size());
        try {
            userService.getPermsForUserAndRef(null, TEST_REF);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testGetRefsForUserPerm() {
        List refs = userService.getRefsForUserPerm(aaronz.getId(), TEST_PERM);
        Assert.assertNotNull((Object)refs);
        Assert.assertEquals((long)1L, (long)refs.size());
        Assert.assertEquals((Object)TEST_REF, refs.get(0));
        refs = userService.getRefsForUserPerm(becky.getId(), TEST_PERM);
        Assert.assertNotNull((Object)refs);
        Assert.assertEquals((long)0L, (long)refs.size());
        refs = userService.getRefsForUserPerm(aaronz.getId(), "XXXXXXXXXX");
        Assert.assertNotNull((Object)refs);
        Assert.assertEquals((long)0L, (long)refs.size());
        try {
            userService.getRefsForUserPerm(null, TEST_PERM);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testGetUsersForPermsRefs() {
        List userIds = userService.getUsersForPermsRefs(new String[]{TEST_REF}, TEST_PERM);
        Assert.assertNotNull((Object)userIds);
        Assert.assertEquals((long)1L, (long)userIds.size());
        Assert.assertEquals((Object)aaronz.getId(), userIds.get(0));
        userIds = userService.getUsersForPermsRefs(new String[]{TEST_REF, "XXXXXX"}, TEST_PERM);
        Assert.assertNotNull((Object)userIds);
        Assert.assertEquals((long)0L, (long)userIds.size());
        userIds = userService.getUsersForPermsRefs(new String[]{"XXXXXX"}, TEST_PERM);
        Assert.assertNotNull((Object)userIds);
        Assert.assertEquals((long)0L, (long)userIds.size());
        userIds = userService.getUsersForPermsRefs(new String[]{TEST_REF}, "XXXXXXXXXX");
        Assert.assertNotNull((Object)userIds);
        Assert.assertEquals((long)0L, (long)userIds.size());
        try {
            userService.getUsersForPermsRefs(null, TEST_PERM);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }
}

