/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseInfo;
import org.dspace.browse.BrowseItem;
import org.dspace.browse.CrossLinks;
import org.dspace.content.Bitstream;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.Thumbnail;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.sort.SortOption;
import org.dspace.storage.bitstore.BitstreamStorageManager;

public class BrowseListTag
extends TagSupport {
    private static Logger log = Logger.getLogger(BrowseListTag.class);
    private BrowseItem[] items;
    private int highlightRow = -1;
    private String emphColumn;
    private boolean showThumbs;
    private int thumbItemListMaxWidth;
    private int thumbItemListMaxHeight;
    private boolean linkToBitstream = false;
    private boolean linkToEdit = false;
    private boolean disableCrossLinks = false;
    private static String listFields = "dc.date.issued(date), dc.title, dc.contributor.*";
    private static String dateField = "dc.date.issued";
    private static String titleField = "dc.title";
    private static String authorField = "dc.contributor.*";
    private static int authorLimit = -1;
    private BrowseInfo browseInfo;

    public BrowseListTag() {
        this.getThumbSettings();
    }

    public int doStartTag() throws JspException {
        String authorLine;
        String titleLine;
        String dateLine;
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest hrq = (HttpServletRequest)this.pageContext.getRequest();
        String browseListLine = null;
        if (this.browseInfo != null) {
            SortOption so = this.browseInfo.getSortOption();
            BrowseIndex bix = this.browseInfo.getBrowseIndex();
            if (bix != null) {
                if (so != null && browseListLine == null) {
                    browseListLine = ConfigurationManager.getProperty((String)("webui.itemlist.browse." + bix.getName() + ".sort." + so.getName() + ".columns"));
                }
                if (so == null) {
                    so = bix.getSortOption();
                }
            }
            if (so != null && browseListLine == null) {
                browseListLine = ConfigurationManager.getProperty((String)("webui.itemlist.sort." + so.getName() + ".columns"));
            }
            if (bix != null && browseListLine == null) {
                browseListLine = ConfigurationManager.getProperty((String)("webui.itemlist.browse." + bix.getName() + ".columns"));
            }
            if (so != null && browseListLine == null) {
                browseListLine = ConfigurationManager.getProperty((String)("webui.itemlist." + so.getName() + ".columns"));
            }
            if (bix != null && browseListLine == null) {
                browseListLine = ConfigurationManager.getProperty((String)("webui.itemlist." + bix.getName() + ".columns"));
            }
        }
        if (browseListLine == null) {
            browseListLine = ConfigurationManager.getProperty((String)"webui.itemlist.columns");
        }
        if (browseListLine != null) {
            listFields = browseListLine;
        }
        if ((dateLine = ConfigurationManager.getProperty((String)"webui.browse.index.date")) != null) {
            dateField = dateLine;
        }
        if ((titleLine = ConfigurationManager.getProperty((String)"webui.browse.index.title")) != null) {
            titleField = titleLine;
        }
        if ((authorLine = ConfigurationManager.getProperty((String)"webui.browse.author-field")) != null) {
            authorField = authorLine;
        }
        StringTokenizer st = new StringTokenizer(listFields, ",");
        int columns = st.countTokens();
        if (this.linkToEdit) {
            ++columns;
        }
        String[] frags = new String[columns * this.items.length];
        try {
            CrossLinks cl = new CrossLinks();
            out.println("<table align=\"center\" class=\"miscTable\" summary=\"This table browses all dspace content\">");
            out.println("<tr>");
            int colCount = 1;
            boolean isDate = false;
            boolean emph = false;
            boolean isAuthor = false;
            while (st.hasMoreTokens()) {
                String cOddOrEven;
                String field = st.nextToken().toLowerCase().trim();
                String string = cOddOrEven = colCount % 2 == 0 ? "Odd" : "Even";
                if (field.indexOf("(date)") > 0) {
                    field = field.replaceAll("\\(date\\)", "");
                    isDate = true;
                }
                if (field.equals(authorField)) {
                    isAuthor = true;
                }
                String browseType = "";
                boolean viewFull = false;
                if (cl.hasLink(field)) {
                    browseType = cl.getLinkType(field);
                    viewFull = BrowseIndex.getBrowseIndex((String)browseType).isItemIndex();
                }
                StringTokenizer eq = new StringTokenizer(field, ".");
                String[] tokens = new String[]{"", "", ""};
                int k = 0;
                while (eq.hasMoreTokens()) {
                    tokens[k] = eq.nextToken().toLowerCase().trim();
                    ++k;
                }
                String schema = tokens[0];
                String element = tokens[1];
                String qualifier = tokens[2];
                if (field.equals(this.emphColumn)) {
                    emph = true;
                }
                String id = "t" + Integer.toString(colCount);
                String css = "oddRow" + cOddOrEven + "Col";
                String message = "itemlist." + field;
                out.print("<th id=\"" + id + "\" class=\"" + css + "\">" + (emph ? "<strong>" : "") + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)message) + (emph ? "</strong>" : "") + "</th>");
                for (int i = 0; i < this.items.length; ++i) {
                    DCValue[] metadataArray = qualifier.equals("*") ? this.items[i].getMetadata(schema, element, "*", "*") : (qualifier.equals("") ? this.items[i].getMetadata(schema, element, null, "*") : this.items[i].getMetadata(schema, element, qualifier, "*"));
                    if (metadataArray == null) {
                        metadataArray = new DCValue[]{};
                    }
                    String metadata = "-";
                    if (metadataArray.length > 0) {
                        if (isDate) {
                            String thumbs = "";
                            if (this.showThumbs) {
                                thumbs = this.getThumbMarkup(hrq, this.items[i]);
                            }
                            DCDate dd = new DCDate(metadataArray[0].value);
                            metadata = UIUtil.displayDate(dd, false, false, hrq) + thumbs;
                        } else if (field.equals(titleField) && this.items[i].isWithdrawn()) {
                            metadata = Utils.addEntities((String)metadataArray[0].value);
                        } else if (field.equals(titleField)) {
                            metadata = "<a href=\"" + hrq.getContextPath() + "/handle/" + this.items[i].getHandle() + "\">" + Utils.addEntities((String)metadataArray[0].value) + "</a>";
                        } else {
                            boolean truncated = false;
                            int loopLimit = metadataArray.length;
                            if (isAuthor) {
                                int fieldMax = authorLimit == -1 ? metadataArray.length : authorLimit;
                                loopLimit = fieldMax > metadataArray.length ? metadataArray.length : fieldMax;
                                truncated = fieldMax < metadataArray.length;
                                log.debug((Object)("Limiting output of field " + field + " to " + Integer.toString(loopLimit) + " from an original " + Integer.toString(metadataArray.length)));
                            }
                            StringBuffer sb = new StringBuffer();
                            for (int j = 0; j < loopLimit; ++j) {
                                String startLink = "";
                                String endLink = "";
                                if (!"".equals(browseType) && !this.disableCrossLinks) {
                                    String argument = "value";
                                    if (viewFull) {
                                        argument = "vfocus";
                                    }
                                    startLink = "<a href=\"" + hrq.getContextPath() + "/browse?type=" + browseType + "&amp;" + argument + "=" + Utils.addEntities((String)metadataArray[j].value);
                                    startLink = metadataArray[j].language != null ? startLink + "&amp;" + argument + "_lang=" + Utils.addEntities((String)metadataArray[j].language) + "\">" : startLink + "\">";
                                    endLink = "</a>";
                                }
                                sb.append(startLink);
                                sb.append(Utils.addEntities((String)metadataArray[j].value));
                                sb.append(endLink);
                                if (j >= loopLimit - 1) continue;
                                sb.append("; ");
                            }
                            if (truncated) {
                                String etal = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"itemlist.et-al");
                                sb.append(", " + etal);
                            }
                            metadata = "<em>" + sb.toString() + "</em>";
                        }
                    }
                    String rOddOrEven = i == this.highlightRow ? "highlight" : (i % 2 == 1 ? "odd" : "even");
                    String extras = "";
                    if (isDate) {
                        extras = "nowrap=\"nowrap\" align=\"right\"";
                    }
                    int idx = (i + 1) * columns - columns + colCount - 1;
                    frags[idx] = "<td headers=\"" + id + "\" class=\"" + rOddOrEven + "Row" + cOddOrEven + "Col\" " + extras + ">" + (emph ? "<strong>" : "") + metadata + (emph ? "</strong>" : "") + "</td>";
                }
                ++colCount;
                isDate = false;
                emph = false;
                isAuthor = false;
            }
            if (this.linkToEdit) {
                String cOddOrEven = columns % 2 == 0 ? "Odd" : "Even";
                String id = "t" + Integer.toString(colCount);
                String css = "oddRow" + cOddOrEven + "Col";
                out.print("<th id=\"" + id + "\" class=\"" + css + "\">" + (emph ? "<strong>" : "") + "&nbsp;" + (emph ? "</strong>" : "") + "</th>");
                for (int i = 0; i < this.items.length; ++i) {
                    String rOddOrEven = i == this.highlightRow ? "highlight" : (i % 2 == 1 ? "odd" : "even");
                    int idx = (i + 1) * columns - 1;
                    frags[idx] = "<td headers=\"" + id + "\" class=\"" + rOddOrEven + "Row" + cOddOrEven + "Col\" nowrap>" + "<form method=get action=\"" + hrq.getContextPath() + "/tools/edit-item\">" + "<input type=\"hidden\" name=\"handle\" value=\"" + this.items[i].getHandle() + "\" />" + "<input type=\"submit\" value=\"Edit Item\" /></form>" + "</td>";
                }
            }
            out.println("</tr>");
            for (int i = 0; i < frags.length; ++i) {
                if ((i + 1) % columns == 1) {
                    out.println("<tr>");
                }
                out.println(frags[i]);
                if ((i + 1) % columns != 0) continue;
                out.println("</tr>");
            }
            out.println("</table>");
        }
        catch (IOException ie) {
            throw new JspException((Throwable)ie);
        }
        catch (SQLException e) {
            throw new JspException((Throwable)e);
        }
        catch (BrowseException e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    public BrowseInfo getBrowseInfo() {
        return this.browseInfo;
    }

    public void setBrowseInfo(BrowseInfo browseInfo) {
        this.browseInfo = browseInfo;
        this.setItems(browseInfo.getBrowseItemResults());
        authorLimit = browseInfo.getEtAl();
    }

    public boolean getLinkToEdit() {
        return this.linkToEdit;
    }

    public void setLinkToEdit(boolean edit) {
        this.linkToEdit = edit;
    }

    public boolean getDisableCrossLinks() {
        return this.disableCrossLinks;
    }

    public void setDisableCrossLinks(boolean links) {
        this.disableCrossLinks = links;
    }

    public BrowseItem[] getItems() {
        return this.items;
    }

    public void setItems(BrowseItem[] itemsIn) {
        this.items = itemsIn;
    }

    public String getHighlightrow() {
        return String.valueOf(this.highlightRow);
    }

    public void setHighlightrow(String highlightRowIn) {
        if (highlightRowIn == null || highlightRowIn.equals("")) {
            this.highlightRow = -1;
        } else {
            try {
                this.highlightRow = Integer.parseInt(highlightRowIn);
            }
            catch (NumberFormatException nfe) {
                this.highlightRow = -1;
            }
        }
    }

    public String getEmphcolumn() {
        return this.emphColumn;
    }

    public void setEmphcolumn(String emphColumnIn) {
        this.emphColumn = emphColumnIn;
    }

    public void release() {
        this.highlightRow = -1;
        this.emphColumn = null;
        this.items = null;
    }

    private void getThumbSettings() {
        String linkBehaviour;
        this.showThumbs = ConfigurationManager.getBooleanProperty((String)"webui.browse.thumbnail.show");
        if (this.showThumbs) {
            this.thumbItemListMaxHeight = ConfigurationManager.getIntProperty((String)"webui.browse.thumbnail.maxheight");
            if (this.thumbItemListMaxHeight == 0) {
                this.thumbItemListMaxHeight = ConfigurationManager.getIntProperty((String)"thumbnail.maxheight");
            }
            this.thumbItemListMaxWidth = ConfigurationManager.getIntProperty((String)"webui.browse.thumbnail.maxwidth");
            if (this.thumbItemListMaxWidth == 0) {
                this.thumbItemListMaxWidth = ConfigurationManager.getIntProperty((String)"thumbnail.maxwidth");
            }
        }
        if ((linkBehaviour = ConfigurationManager.getProperty((String)"webui.browse.thumbnail.linkbehaviour")) != null && linkBehaviour.equals("bitstream")) {
            this.linkToBitstream = true;
        }
    }

    private String getScalingAttr(HttpServletRequest hrq, Bitstream bitstream) throws JspException {
        float scale_factor;
        BufferedImage buf;
        try {
            Context c = UIUtil.obtainContext(hrq);
            InputStream is = BitstreamStorageManager.retrieve((Context)c, (int)bitstream.getID());
            buf = ImageIO.read(is);
            is.close();
        }
        catch (SQLException sqle) {
            throw new JspException(sqle.getMessage());
        }
        catch (IOException ioe) {
            throw new JspException(ioe.getMessage());
        }
        float xsize = buf.getWidth(null);
        float ysize = buf.getHeight(null);
        if (xsize > (float)this.thumbItemListMaxWidth) {
            scale_factor = (float)this.thumbItemListMaxWidth / xsize;
            xsize *= scale_factor;
            ysize *= scale_factor;
        }
        if (ysize > (float)this.thumbItemListMaxHeight) {
            scale_factor = (float)this.thumbItemListMaxHeight / ysize;
            xsize *= scale_factor;
            ysize *= scale_factor;
        }
        StringBuffer sb = new StringBuffer("width=\"").append(xsize).append("\" height=\"").append(ysize).append("\"");
        return sb.toString();
    }

    private String getThumbMarkup(HttpServletRequest hrq, BrowseItem item) throws JspException {
        try {
            Context c = UIUtil.obtainContext(hrq);
            Thumbnail thumbnail = ItemService.getThumbnail((Context)c, (int)item.getID(), (boolean)this.linkToBitstream);
            if (thumbnail == null) {
                return "";
            }
            StringBuffer thumbFrag = new StringBuffer();
            if (this.linkToBitstream) {
                Bitstream original = thumbnail.getOriginal();
                String link = hrq.getContextPath() + "/bitstream/" + item.getHandle() + "/" + original.getSequenceID() + "/" + UIUtil.encodeBitstreamName((String)original.getName(), (String)"UTF-8");
                thumbFrag.append("<a target=\"_blank\" href=\"" + link + "\" />");
            } else {
                String link = hrq.getContextPath() + "/handle/" + item.getHandle();
                thumbFrag.append("<a href=\"" + link + "\" />");
            }
            Bitstream thumb = thumbnail.getThumb();
            String img = hrq.getContextPath() + "/retrieve/" + thumb.getID() + "/" + UIUtil.encodeBitstreamName((String)thumb.getName(), (String)"UTF-8");
            String alt = thumb.getName();
            String scAttr = this.getScalingAttr(hrq, thumb);
            thumbFrag.append("<img src=\"").append(img).append("\" alt=\"").append(alt + "\" ").append(scAttr).append("/></a>");
            return thumbFrag.toString();
        }
        catch (SQLException sqle) {
            throw new JspException(sqle.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new JspException("Server does not support DSpace's default encoding. ", (Throwable)e);
        }
    }
}

