/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.XMLUtil;
import org.dspace.core.ConfigurationManager;
import org.w3c.dom.Document;

public class ControlledVocabularyTag
extends TagSupport {
    private static final String CONTROLLEDVOCABULARY_JSPTAG = "/controlledvocabulary/controlledvocabularyTag.jsp";
    private static Logger log = Logger.getLogger(ControlledVocabularyTag.class);
    private String filter;
    private boolean allowMultipleSelection;
    private String vocabulary;
    public Hashtable controlledVocabularies;

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String vocabulariesPath = ConfigurationManager.getProperty((String)"dspace.dir") + "/config/controlled-vocabularies/";
        String addonBaseDirectory = this.pageContext.getServletContext().getRealPath("") + "/controlledvocabulary/";
        String vocabularyPrunningXSLT = addonBaseDirectory + "vocabularyprune.xsl";
        String controlledVocabulary2HtmlXSLT = addonBaseDirectory + "vocabulary2html.xsl";
        this.controlledVocabularies = (Hashtable)this.pageContext.getServletContext().getAttribute("controlledvocabulary.controlledVocabularies");
        if (this.controlledVocabularies == null) {
            this.controlledVocabularies = ControlledVocabularyTag.loadControlledVocabularies(vocabulariesPath);
            this.pageContext.getServletContext().setAttribute("controlledvocabulary.controlledVocabularies", (Object)this.controlledVocabularies);
        }
        try {
            Hashtable prunnedVocabularies = this.needsFiltering() ? this.filterVocabularies(this.controlledVocabularies, vocabularyPrunningXSLT) : this.controlledVocabularies;
            String html = "";
            html = this.vocabulary != null && !this.vocabulary.equals("") ? this.renderVocabularyAsHTML((Document)prunnedVocabularies.get(this.vocabulary + ".xml"), controlledVocabulary2HtmlXSLT, this.isAllowMultipleSelection(), request.getContextPath()) : this.renderVocabulariesAsHTML(prunnedVocabularies, controlledVocabulary2HtmlXSLT, this.isAllowMultipleSelection(), request.getContextPath());
            request.getSession().setAttribute("controlledvocabulary.vocabularyHTML", (Object)html);
            this.pageContext.include(CONTROLLEDVOCABULARY_JSPTAG);
        }
        catch (Exception e) {
            log.warn((Object)"Exception", (Throwable)e);
        }
        return 0;
    }

    public int doEndTag() {
        return 6;
    }

    private boolean needsFiltering() {
        return this.getFilter() != null && this.getFilter().length() > 0;
    }

    private String renderVocabulariesAsHTML(Hashtable vocabularies, String xslt, boolean allowMultipleSelection, String contextPath) {
        String result = "";
        for (Document controlledVocabularyXML : vocabularies.values()) {
            result = result + this.renderVocabularyAsHTML(controlledVocabularyXML, xslt, allowMultipleSelection, contextPath);
        }
        return result;
    }

    private Hashtable filterVocabularies(Hashtable vocabularies, String vocabularyPrunningXSLT) {
        Hashtable<String, Document> prunnedVocabularies = new Hashtable<String, Document>();
        Enumeration enumeration = vocabularies.keys();
        while (enumeration.hasMoreElements()) {
            String controlledVocabularyKey = (String)enumeration.nextElement();
            Document controlledVocabulary = (Document)vocabularies.get(controlledVocabularyKey);
            prunnedVocabularies.put(controlledVocabularyKey, this.filterVocabulary(controlledVocabulary, vocabularyPrunningXSLT, this.getFilter()));
        }
        return prunnedVocabularies;
    }

    public String renderVocabularyAsHTML(Document vocabulary, String controlledVocabulary2HtmlXSLT, boolean allowMultipleSelection, String contextPath) {
        if (vocabulary == null) {
            return "";
        }
        String result = "";
        try {
            Hashtable<String, String> parameters = new Hashtable<String, String>();
            parameters.put("allowMultipleSelection", allowMultipleSelection ? "yes" : "no");
            parameters.put("contextPath", contextPath);
            result = XMLUtil.transformDocumentAsString(vocabulary, parameters, controlledVocabulary2HtmlXSLT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Document filterVocabulary(Document vocabulary, String vocabularyPrunningXSLT, String filter) {
        if (vocabulary == null) {
            return null;
        }
        try {
            Hashtable<String, String> parameters = new Hashtable<String, String>();
            parameters.put("filter", filter);
            Document prunnedVocabulary = XMLUtil.transformDocument(vocabulary, parameters, vocabularyPrunningXSLT);
            return prunnedVocabulary;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Hashtable loadControlledVocabularies(String directory) {
        Hashtable<String, Document> controlledVocabularies = new Hashtable<String, Document>();
        File dir = new File(directory);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
        String[] children = dir.list(filter);
        if (children != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                String filename = children[i];
                try {
                    Document controlledVocabulary = XMLUtil.loadXML(directory + filename);
                    controlledVocabularies.put(filename, controlledVocabulary);
                    log.warn((Object)("Loaded vocabulary: " + filename));
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to load vocabulary from " + filename), (Throwable)e);
                }
            }
        } else {
            log.warn((Object)"Could not find any vocabularies...");
        }
        return controlledVocabularies;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean isAllowMultipleSelection() {
        return this.allowMultipleSelection;
    }

    public void setAllowMultipleSelection(boolean allowMultipleSelection) {
        this.allowMultipleSelection = allowMultipleSelection;
    }

    public String getVocabulary() {
        return this.vocabulary;
    }

    public void setVocabulary(String vocabulary) {
        this.vocabulary = vocabulary;
    }
}

