/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.dspace.content.DCPersonName;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;

public class SFXLinkTag
extends TagSupport {
    private Item item;

    public int doStartTag() throws JspException {
        try {
            DCValue[] dates;
            DCValue[] issn;
            DCValue[] isbn;
            DCValue[] authors;
            String sfxServer = ConfigurationManager.getProperty((String)"sfx.server.url");
            if (sfxServer == null) {
                return 0;
            }
            String sfxQuery = "";
            DCValue[] titles = this.item.getDC("title", null, "*");
            if (titles.length > 0) {
                sfxQuery = sfxQuery + "&title=" + URLEncoder.encode(titles[0].value, "UTF-8");
            }
            if ((authors = this.item.getDC("contributor", "author", "*")).length > 0) {
                DCPersonName dpn = new DCPersonName(authors[0].value);
                sfxQuery = sfxQuery + "&aulast=" + URLEncoder.encode(dpn.getLastName(), "UTF-8");
                sfxQuery = sfxQuery + "&aufirst=" + URLEncoder.encode(dpn.getFirstNames(), "UTF-8");
            }
            if ((isbn = this.item.getDC("identifier", "isbn", "*")).length > 0) {
                sfxQuery = sfxQuery + "&isbn=" + URLEncoder.encode(isbn[0].value, "UTF-8");
            }
            if ((issn = this.item.getDC("identifier", "issn", "*")).length > 0) {
                sfxQuery = sfxQuery + "&issn=" + URLEncoder.encode(issn[0].value, "UTF-8");
            }
            if ((dates = this.item.getDC("date", "issued", "*")).length > 0) {
                String fullDate = dates[0].value;
                if (fullDate.length() > 10) {
                    fullDate = fullDate.substring(0, 10);
                }
                sfxQuery = sfxQuery + "&date=" + URLEncoder.encode(fullDate, "UTF-8");
            }
            if (sfxQuery.startsWith("&")) {
                sfxQuery = sfxQuery.substring(1);
            }
            this.pageContext.getOut().print(sfxServer + sfxQuery);
        }
        catch (IOException ie) {
            throw new JspException((Throwable)ie);
        }
        return 0;
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item itemIn) {
        this.item = itemIn;
    }
}

