/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;

public class EditProfileServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(EditProfileServlet.class);

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        log.info((Object)LogManager.getHeader((Context)context, (String)"view_profile", (String)""));
        request.setAttribute("eperson", (Object)context.getCurrentUser());
        JSPManager.showJSP(request, response, "/register/edit-profile.jsp");
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        boolean ok;
        EPerson eperson = context.getCurrentUser();
        boolean settingPassword = false;
        if (!eperson.getRequireCertificate() && request.getParameter("password") != null && !request.getParameter("password").equals("")) {
            settingPassword = true;
        }
        if (!(ok = EditProfileServlet.updateUserProfile(eperson, request))) {
            request.setAttribute("missing.fields", (Object)new Boolean(true));
        }
        Object passwordProblem = null;
        if (ok && settingPassword && !(ok = EditProfileServlet.confirmAndSetPassword(eperson, request))) {
            request.setAttribute("password.problem", (Object)new Boolean(true));
        }
        if (ok) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"edit_profile", (String)("password_changed=" + settingPassword)));
            eperson.update();
            request.setAttribute("password.updated", (Object)new Boolean(settingPassword));
            JSPManager.showJSP(request, response, "/register/profile-updated.jsp");
            context.complete();
        } else {
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_profile", (String)"problem=true"));
            request.setAttribute("eperson", (Object)eperson);
            JSPManager.showJSP(request, response, "/register/edit-profile.jsp");
        }
    }

    public static boolean updateUserProfile(EPerson eperson, HttpServletRequest request) {
        String lastName = request.getParameter("last_name");
        String firstName = request.getParameter("first_name");
        String phone = request.getParameter("phone");
        String language = request.getParameter("language");
        eperson.setFirstName(firstName);
        eperson.setLastName(lastName);
        eperson.setMetadata("phone", phone);
        eperson.setLanguage(language);
        return lastName != null && !lastName.equals("") && firstName != null && !firstName.equals("");
    }

    public static boolean confirmAndSetPassword(EPerson eperson, HttpServletRequest request) {
        String password = request.getParameter("password");
        String passwordConfirm = request.getParameter("password_confirm");
        if (password == null || password.length() < 6) {
            return false;
        }
        if (!password.equals(passwordConfirm)) {
            return false;
        }
        eperson.setPassword(password);
        return true;
    }
}

