/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.Authenticate;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.PluginManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.Subscribe;
import org.dspace.handle.HandleManager;
import org.dspace.plugin.CollectionHomeProcessor;
import org.dspace.plugin.CommunityHomeProcessor;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class HandleServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(DSpaceServlet.class);
    private DisseminationCrosswalk xHTMLHeadCrosswalk = (DisseminationCrosswalk)PluginManager.getNamedPlugin(DisseminationCrosswalk.class, (String)"XHTML_HEAD_ITEM");

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String handle = null;
        String extraPathInfo = null;
        DSpaceObject dso = null;
        String path = request.getPathInfo();
        if (path != null) {
            path = path.substring(1);
            try {
                int firstSlash = path.indexOf(47);
                int secondSlash = path.indexOf(47, firstSlash + 1);
                if (secondSlash != -1) {
                    handle = path.substring(0, secondSlash);
                    extraPathInfo = path.substring(secondSlash);
                } else {
                    handle = path;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (handle != null) {
            dso = HandleManager.resolveToObject((Context)context, handle);
        }
        if (dso == null) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_id", (String)("path=" + path)));
            JSPManager.showInvalidIDError(request, response, path, -1);
            return;
        }
        if (dso.getType() == 2) {
            Item item = (Item)dso;
            response.setDateHeader("Last-Modified", item.getLastModified().getTime());
            long modSince = request.getDateHeader("If-Modified-Since");
            if (modSince != -1L && item.getLastModified().getTime() < modSince) {
                response.setStatus(304);
            } else {
                this.displayItem(context, request, response, item, handle);
            }
        } else if (dso.getType() == 3) {
            Collection c = (Collection)dso;
            request.setAttribute("dspace.collection", (Object)c);
            Community[] parents = c.getCommunities();
            request.setAttribute("dspace.community", (Object)parents[0]);
            request.setAttribute("dspace.communities", (Object)this.getParents(parents[0], true));
            if (extraPathInfo == null || extraPathInfo.equals("/")) {
                this.collectionHome(context, request, response, parents[0], c);
            } else {
                request.getRequestDispatcher(extraPathInfo).forward((ServletRequest)request, (ServletResponse)response);
            }
        } else if (dso.getType() == 4) {
            Community c = (Community)dso;
            request.setAttribute("dspace.community", (Object)c);
            request.setAttribute("dspace.communities", (Object)this.getParents(c, false));
            if (extraPathInfo == null || extraPathInfo.equals("/")) {
                this.communityHome(context, request, response, c);
            } else {
                request.getRequestDispatcher(extraPathInfo).forward((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            log.info((Object)LogManager.getHeader((Context)context, (String)"Handle not an item, collection or community", (String)("handle=" + handle)));
            JSPManager.showInvalidIDError(request, response, path, -1);
            return;
        }
    }

    private void displayItem(Context context, HttpServletRequest request, HttpServletResponse response, Item item, String handle) throws ServletException, IOException, SQLException, AuthorizeException {
        if (item.isWithdrawn()) {
            JSPManager.showJSP(request, response, "/tombstone.jsp");
            return;
        }
        AuthorizeManager.authorizeAction((Context)context, (DSpaceObject)item, (int)0);
        log.info((Object)LogManager.getHeader((Context)context, (String)"view_item", (String)("handle=" + handle)));
        if (item.canEdit()) {
            request.setAttribute("admin_button", (Object)new Boolean(true));
        }
        Collection[] collections = item.getCollections();
        request.setAttribute("dspace.collection", (Object)item.getOwningCollection());
        Community[] comms = item.getOwningCollection().getCommunities();
        request.setAttribute("dspace.community", (Object)comms[0]);
        request.setAttribute("dspace.communities", (Object)this.getParents(comms[0], true));
        boolean displayAll = false;
        String modeParam = request.getParameter("mode");
        if (modeParam != null && modeParam.equalsIgnoreCase("full")) {
            displayAll = true;
        }
        String headMetadata = "";
        try {
            List l = this.xHTMLHeadCrosswalk.disseminateList((DSpaceObject)item);
            StringWriter sw = new StringWriter();
            XMLOutputter xmlo = new XMLOutputter();
            for (int i = 0; i < l.size(); ++i) {
                Element e = (Element)l.get(i);
                e.setNamespace(null);
                xmlo.output(e, (Writer)sw);
            }
            headMetadata = sw.toString();
        }
        catch (CrosswalkException ce) {
            throw new ServletException((Throwable)ce);
        }
        boolean suggestEnable = false;
        if (ConfigurationManager.getBooleanProperty((String)"webui.suggest.enable")) {
            suggestEnable = true;
            if (ConfigurationManager.getBooleanProperty((String)"webui.suggest.loggedinusers.only")) {
                suggestEnable = context.getCurrentUser() != null;
            }
        }
        request.setAttribute("suggest.enable", (Object)new Boolean(suggestEnable));
        request.setAttribute("display.all", (Object)new Boolean(displayAll));
        request.setAttribute("item", (Object)item);
        request.setAttribute("collections", (Object)collections);
        request.setAttribute("dspace.layout.head", (Object)headMetadata);
        JSPManager.showJSP(request, response, "/display-item.jsp");
    }

    private void communityHome(Context context, HttpServletRequest request, HttpServletResponse response, Community community) throws ServletException, IOException, SQLException {
        if (!this.handleButton(request, response, community.getHandle())) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_community", (String)("community_id=" + community.getID())));
            Collection[] collections = community.getCollections();
            Community[] subcommunities = community.getSubcommunities();
            this.preProcessCommunityHome(context, request, response, community);
            if (community.canEditBoolean()) {
                request.setAttribute("editor_button", (Object)new Boolean(true));
            }
            if (AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)community, (int)3)) {
                request.setAttribute("add_button", (Object)new Boolean(true));
            }
            if (AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)community, (int)4)) {
                request.setAttribute("remove_button", (Object)new Boolean(true));
            }
            request.setAttribute("community", (Object)community);
            request.setAttribute("collections", (Object)collections);
            request.setAttribute("subcommunities", (Object)subcommunities);
            JSPManager.showJSP(request, response, "/community-home.jsp");
        }
    }

    private void preProcessCommunityHome(Context context, HttpServletRequest request, HttpServletResponse response, Community community) throws ServletException, IOException, SQLException {
        try {
            CommunityHomeProcessor[] chp = (CommunityHomeProcessor[])PluginManager.getPluginSequence(CommunityHomeProcessor.class);
            for (int i = 0; i < chp.length; ++i) {
                chp[i].process(context, request, response, community);
            }
        }
        catch (Exception e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private void collectionHome(Context context, HttpServletRequest request, HttpServletResponse response, Community community, Collection collection) throws ServletException, IOException, SQLException, AuthorizeException {
        if (!this.handleButton(request, response, collection.getHandle())) {
            boolean updated = false;
            if (request.getParameter("submit_subscribe") != null) {
                if (context.getCurrentUser() == null && !Authenticate.startAuthentication(context, request, response)) {
                    return;
                }
                Subscribe.subscribe((Context)context, (EPerson)context.getCurrentUser(), (Collection)collection);
                updated = true;
            } else if (request.getParameter("submit_unsubscribe") != null) {
                Subscribe.unsubscribe((Context)context, (EPerson)context.getCurrentUser(), (Collection)collection);
                updated = true;
            }
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_collection", (String)("collection_id=" + collection.getID())));
            this.preProcessCollectionHome(context, request, response, collection);
            EPerson e = context.getCurrentUser();
            boolean subscribed = false;
            if (e != null) {
                subscribed = Subscribe.isSubscribed((Context)context, (EPerson)e, (Collection)collection);
                if (collection.canEditBoolean()) {
                    request.setAttribute("editor_button", (Object)new Boolean(true));
                }
                if (AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)collection, (int)11)) {
                    request.setAttribute("admin_button", (Object)new Boolean(true));
                    Group group = collection.getSubmitters();
                    if (group != null) {
                        request.setAttribute("submitters", (Object)group);
                    }
                }
                if (AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)collection, (int)3)) {
                    request.setAttribute("can_submit_button", (Object)new Boolean(true));
                } else {
                    request.setAttribute("can_submit_button", (Object)new Boolean(false));
                }
            }
            request.setAttribute("collection", (Object)collection);
            request.setAttribute("community", (Object)community);
            request.setAttribute("logged.in", (Object)new Boolean(e != null));
            request.setAttribute("subscribed", (Object)new Boolean(subscribed));
            JSPManager.showJSP(request, response, "/collection-home.jsp");
            if (updated) {
                context.complete();
            }
        }
    }

    private void preProcessCollectionHome(Context context, HttpServletRequest request, HttpServletResponse response, Collection collection) throws ServletException, IOException, SQLException {
        try {
            CollectionHomeProcessor[] chp = (CollectionHomeProcessor[])PluginManager.getPluginSequence(CollectionHomeProcessor.class);
            for (int i = 0; i < chp.length; ++i) {
                chp[i].process(context, request, response, collection);
            }
        }
        catch (Exception e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private boolean handleButton(HttpServletRequest request, HttpServletResponse response, String handle) throws IOException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"");
        String location = request.getParameter("location");
        String prefix = "/";
        String url = null;
        if (location == null) {
            return false;
        }
        if (!location.equals("/")) {
            prefix = "/handle/" + location + "/";
        }
        if (button.equals("submit_search") || request.getParameter("query") != null) {
            url = request.getContextPath() + prefix + "simple-search?query=" + URLEncoder.encode(request.getParameter("query"), "UTF-8");
        }
        if (url != null) {
            response.sendRedirect(response.encodeRedirectURL(url));
            return true;
        }
        return false;
    }

    private String[] getItemTitles(List items) {
        String[] titles = new String[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            Item item = (Item)items.get(i);
            DCValue[] titlesForThis = item.getDC("title", null, "*");
            titles[i] = titlesForThis.length == 0 ? null : titlesForThis[0].value;
        }
        return titles;
    }

    private String[] getItemURLs(Context context, List items) throws SQLException {
        String[] urls = new String[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            Item item = (Item)items.get(i);
            urls[i] = "/handle/" + item.getHandle();
        }
        return urls;
    }

    private Community[] getParents(Community c, boolean include) throws SQLException {
        Community[] parents = c.getAllParents();
        int revLength = include ? parents.length + 1 : parents.length;
        Community[] reversedParents = new Community[revLength];
        int index = parents.length - 1;
        for (int i = 0; i < parents.length; ++i) {
            reversedParents[i] = parents[index - i];
        }
        if (include) {
            reversedParents[revLength - 1] = c;
        }
        return reversedParents;
    }
}

