/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReader;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.SupervisedItem;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.handle.HandleManager;
import org.dspace.submit.AbstractProcessingStep;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowManager;

public class MyDSpaceServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(MyDSpaceServlet.class);
    public static final int MAIN_PAGE = 0;
    public static final int REMOVE_ITEM_PAGE = 1;
    public static final int PREVIEW_TASK_PAGE = 2;
    public static final int PERFORM_TASK_PAGE = 3;
    public static final int REJECT_REASON_PAGE = 4;

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.showMainPage(context, request, response);
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int step = UIUtil.getIntParameter((HttpServletRequest)request, (String)"step");
        switch (step) {
            case 0: {
                this.processMainPage(context, request, response);
                break;
            }
            case 1: {
                this.processRemoveItem(context, request, response);
                break;
            }
            case 2: {
                this.processPreviewTask(context, request, response);
                break;
            }
            case 3: {
                this.processPerformTask(context, request, response);
                break;
            }
            case 4: {
                this.processRejectReason(context, request, response);
                break;
            }
            default: {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
                JSPManager.showIntegrityError(request, response);
            }
        }
    }

    protected void processMainPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        WorkflowItem workflowItem;
        WorkspaceItem workspaceItem;
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_own");
        try {
            int wsID = Integer.parseInt(request.getParameter("workspace_id"));
            workspaceItem = WorkspaceItem.find((Context)context, (int)wsID);
        }
        catch (NumberFormatException nfe) {
            workspaceItem = null;
        }
        try {
            int wfID = Integer.parseInt(request.getParameter("workflow_id"));
            workflowItem = WorkflowItem.find((Context)context, (int)wfID);
        }
        catch (NumberFormatException nfe) {
            workflowItem = null;
        }
        boolean ok = false;
        if (buttonPressed.equals("submit_new")) {
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/submit"));
            ok = true;
        } else if (buttonPressed.equals("submit_own")) {
            this.showPreviousSubmissions(context, request, response);
            ok = true;
        } else if (buttonPressed.equals("submit_resume")) {
            String wsID = request.getParameter("workspace_id");
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/submit?resume=" + wsID));
            ok = true;
        } else if (buttonPressed.equals("submit_delete")) {
            if (workspaceItem != null) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"confirm_removal", (String)("workspace_item_id=" + workspaceItem.getID())));
                request.setAttribute("workspace.item", (Object)workspaceItem);
                JSPManager.showJSP(request, response, "/mydspace/remove-item.jsp");
            } else {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
                JSPManager.showIntegrityError(request, response);
            }
            ok = true;
        } else if (buttonPressed.equals("submit_claim")) {
            if (workflowItem != null) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"view_workflow", (String)("workflow_id=" + workflowItem.getID())));
                request.setAttribute("workflow.item", (Object)workflowItem);
                JSPManager.showJSP(request, response, "/mydspace/preview-task.jsp");
                ok = true;
            }
        } else if (buttonPressed.equals("submit_perform")) {
            if (workflowItem != null) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"view_workflow", (String)("workflow_id=" + workflowItem.getID())));
                request.setAttribute("workflow.item", (Object)workflowItem);
                JSPManager.showJSP(request, response, "/mydspace/perform-task.jsp");
                ok = true;
            }
        } else if (buttonPressed.equals("submit_return") && workflowItem != null) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"unclaim_workflow", (String)("workflow_id=" + workflowItem.getID())));
            WorkflowManager.unclaim((Context)context, (WorkflowItem)workflowItem, (EPerson)context.getCurrentUser());
            this.showMainPage(context, request, response);
            context.complete();
            ok = true;
        }
        if (!ok) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
            JSPManager.showIntegrityError(request, response);
        }
    }

    private void processRemoveItem(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        WorkspaceItem workspaceItem;
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_cancel");
        try {
            int wsID = Integer.parseInt(request.getParameter("workspace_id"));
            workspaceItem = WorkspaceItem.find((Context)context, (int)wsID);
        }
        catch (NumberFormatException nfe) {
            workspaceItem = null;
        }
        if (workspaceItem == null) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
            JSPManager.showIntegrityError(request, response);
            return;
        }
        if (buttonPressed.equals("submit_delete")) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"remove_submission", (String)("workspace_item_id=" + workspaceItem.getID() + ",item_id=" + workspaceItem.getItem().getID())));
            workspaceItem.deleteAll();
            this.showMainPage(context, request, response);
            context.complete();
        } else {
            this.showMainPage(context, request, response);
        }
    }

    private void processPreviewTask(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        WorkflowItem workflowItem;
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_cancel");
        try {
            int wfID = Integer.parseInt(request.getParameter("workflow_id"));
            workflowItem = WorkflowItem.find((Context)context, (int)wfID);
        }
        catch (NumberFormatException nfe) {
            workflowItem = null;
        }
        if (workflowItem == null) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
            JSPManager.showIntegrityError(request, response);
            return;
        }
        if (buttonPressed.equals("submit_start")) {
            WorkflowManager.claim((Context)context, (WorkflowItem)workflowItem, (EPerson)context.getCurrentUser());
            request.setAttribute("workflow.item", (Object)workflowItem);
            JSPManager.showJSP(request, response, "/mydspace/perform-task.jsp");
            context.complete();
        } else {
            this.showMainPage(context, request, response);
        }
    }

    private void processPerformTask(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        WorkflowItem workflowItem;
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_cancel");
        try {
            int wfID = Integer.parseInt(request.getParameter("workflow_id"));
            workflowItem = WorkflowItem.find((Context)context, (int)wfID);
        }
        catch (NumberFormatException nfe) {
            workflowItem = null;
        }
        if (workflowItem == null) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
            JSPManager.showIntegrityError(request, response);
            return;
        }
        if (buttonPressed.equals("submit_approve")) {
            Item item = workflowItem.getItem();
            WorkflowManager.advance((Context)context, (WorkflowItem)workflowItem, (EPerson)context.getCurrentUser());
            String handle = HandleManager.findHandle((Context)context, (DSpaceObject)item);
            if (handle != null) {
                String displayHandle = HandleManager.getCanonicalForm((String)handle);
                request.setAttribute("handle", (Object)displayHandle);
                JSPManager.showJSP(request, response, "/mydspace/in-archive.jsp");
            } else {
                JSPManager.showJSP(request, response, "/mydspace/task-complete.jsp");
            }
            context.complete();
        } else if (buttonPressed.equals("submit_reject")) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"get_reject_reason", (String)("workflow_id=" + workflowItem.getID() + ",item_id=" + workflowItem.getItem().getID())));
            request.setAttribute("workflow.item", (Object)workflowItem);
            JSPManager.showJSP(request, response, "/mydspace/reject-reason.jsp");
        } else if (buttonPressed.equals("submit_edit")) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"edit_workflow_item", (String)("workflow_id=" + workflowItem.getID() + ",item_id=" + workflowItem.getItem().getID())));
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/submit?workflow=" + workflowItem.getID()));
        } else if (buttonPressed.equals("submit_pool")) {
            WorkflowManager.unclaim((Context)context, (WorkflowItem)workflowItem, (EPerson)context.getCurrentUser());
            this.showMainPage(context, request, response);
            context.complete();
        } else {
            this.showMainPage(context, request, response);
        }
    }

    private void processRejectReason(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        WorkflowItem workflowItem;
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_cancel");
        try {
            int wfID = Integer.parseInt(request.getParameter("workflow_id"));
            workflowItem = WorkflowItem.find((Context)context, (int)wfID);
        }
        catch (NumberFormatException nfe) {
            workflowItem = null;
        }
        if (workflowItem == null) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
            JSPManager.showIntegrityError(request, response);
            return;
        }
        if (buttonPressed.equals("submit_send")) {
            String reason = request.getParameter("reason");
            WorkspaceItem wsi = WorkflowManager.reject((Context)context, (WorkflowItem)workflowItem, (EPerson)context.getCurrentUser(), (String)reason);
            Collection c = wsi.getCollection();
            SubmissionConfigReader subConfigReader = new SubmissionConfigReader();
            SubmissionConfig subConfig = subConfigReader.getSubmissionConfig(c.getHandle(), false);
            int lastStep = subConfig.getNumberOfSteps() - 2;
            wsi.setStageReached(lastStep);
            wsi.setPageReached(AbstractProcessingStep.LAST_PAGE_REACHED);
            wsi.update();
            JSPManager.showJSP(request, response, "/mydspace/task-complete.jsp");
            context.complete();
        } else {
            request.setAttribute("workflow.item", (Object)workflowItem);
            JSPManager.showJSP(request, response, "/mydspace/perform-task.jsp");
        }
    }

    private void showMainPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        log.info((Object)LogManager.getHeader((Context)context, (String)"view_mydspace", (String)""));
        EPerson currentUser = context.getCurrentUser();
        List ownedList = WorkflowManager.getOwnedTasks((Context)context, (EPerson)currentUser);
        WorkflowItem[] owned = new WorkflowItem[ownedList.size()];
        owned = ownedList.toArray(owned);
        List pooledList = WorkflowManager.getPooledTasks((Context)context, (EPerson)currentUser);
        WorkflowItem[] pooled = new WorkflowItem[pooledList.size()];
        pooled = pooledList.toArray(pooled);
        WorkflowItem[] workflowItems = WorkflowItem.findByEPerson((Context)context, (EPerson)currentUser);
        WorkspaceItem[] workspaceItems = WorkspaceItem.findByEPerson((Context)context, (EPerson)currentUser);
        Group[] memberships = Group.allMemberGroups((Context)context, (EPerson)currentUser);
        boolean displayMemberships = ConfigurationManager.getBooleanProperty((String)"webui.mydspace.showgroupmemberships", (boolean)false);
        SupervisedItem[] supervisedItems = SupervisedItem.findbyEPerson((Context)context, (EPerson)currentUser);
        request.setAttribute("mydspace.user", (Object)currentUser);
        request.setAttribute("workspace.items", (Object)workspaceItems);
        request.setAttribute("workflow.items", (Object)workflowItems);
        request.setAttribute("workflow.owned", (Object)owned);
        request.setAttribute("workflow.pooled", (Object)pooled);
        request.setAttribute("group.memberships", (Object)memberships);
        request.setAttribute("display.groupmemberships", (Object)new Boolean(displayMemberships));
        request.setAttribute("supervised.items", (Object)supervisedItems);
        JSPManager.showJSP(request, response, "/mydspace/main.jsp");
    }

    private void showPreviousSubmissions(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        ItemIterator subs = Item.findBySubmitter((Context)context, (EPerson)context.getCurrentUser());
        LinkedList<Item> subList = new LinkedList<Item>();
        while (subs.hasNext()) {
            subList.add(subs.next());
        }
        Item[] items = new Item[subList.size()];
        for (int i = 0; i < subList.size(); ++i) {
            items[i] = (Item)subList.get(i);
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"view_own_submissions", (String)("count=" + items.length)));
        request.setAttribute("user", (Object)context.getCurrentUser());
        request.setAttribute("items", (Object)items);
        JSPManager.showJSP(request, response, "/mydspace/own-submissions.jsp");
    }
}

