/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;
import org.dspace.search.DSQuery;
import org.dspace.search.QueryArgs;
import org.dspace.search.QueryResults;
import org.dspace.sort.SortOption;

public class SimpleSearchServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(SimpleSearchServlet.class);

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int i;
        String location;
        String query = request.getParameter("query");
        int start = UIUtil.getIntParameter((HttpServletRequest)request, (String)"start");
        String advanced = request.getParameter("advanced");
        String fromAdvanced = request.getParameter("from_advanced");
        int sortBy = UIUtil.getIntParameter((HttpServletRequest)request, (String)"sort_by");
        String order = request.getParameter("order");
        int rpp = UIUtil.getIntParameter((HttpServletRequest)request, (String)"rpp");
        String advancedQuery = "";
        HashMap queryHash = new HashMap();
        if (start < 0) {
            start = 0;
        }
        int collCount = 0;
        int commCount = 0;
        int itemCount = 0;
        QueryResults qResults = null;
        QueryArgs qArgs = new QueryArgs();
        SortOption sortOption = null;
        if (request.getParameter("etal") != null) {
            qArgs.setEtAl(UIUtil.getIntParameter((HttpServletRequest)request, (String)"etal"));
        }
        try {
            if (sortBy > 0) {
                sortOption = SortOption.getSortOption((int)sortBy);
                qArgs.setSortOption(sortOption);
            }
            if ("ASC".equalsIgnoreCase(order)) {
                qArgs.setSortOrder("ASC");
            } else {
                qArgs.setSortOrder("DESC");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (rpp > 0) {
            qArgs.setPageSize(rpp);
        }
        if (advanced != null) {
            query = qArgs.buildQuery(request);
            advancedQuery = qArgs.buildHTTPQuery(request);
        }
        if (query == null) {
            query = "";
        }
        if ((location = request.getParameter("location")) != null && !location.equals("")) {
            String url = "";
            if (!location.equals("/")) {
                url = "/handle/" + location;
            }
            query = URLEncoder.encode(query, "UTF-8");
            if (advancedQuery.length() > 0) {
                query = query + "&from_advanced=true&" + advancedQuery;
            }
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + url + "/simple-search?query=" + query));
            return;
        }
        String logInfo = "";
        Community community = UIUtil.getCommunityLocation(request);
        Collection collection = UIUtil.getCollectionLocation(request);
        qArgs.setQuery(query);
        qArgs.setStart(start);
        if (collection != null) {
            logInfo = "collection_id=" + collection.getID() + ",";
            request.setAttribute("community", (Object)community);
            request.setAttribute("collection", (Object)collection);
            qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs, (Collection)collection);
        } else if (community != null) {
            logInfo = "community_id=" + community.getID() + ",";
            request.setAttribute("community", (Object)community);
            request.setAttribute("collection.array", (Object)community.getCollections());
            qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs, (Community)community);
        } else {
            Community[] communities = Community.findAll((Context)context);
            request.setAttribute("community.array", (Object)communities);
            qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs);
        }
        block12: for (i = 0; i < qResults.getHitTypes().size(); ++i) {
            Integer myType = (Integer)qResults.getHitTypes().get(i);
            switch (myType) {
                case 2: {
                    ++itemCount;
                    continue block12;
                }
                case 3: {
                    ++collCount;
                    continue block12;
                }
                case 4: {
                    ++commCount;
                }
            }
        }
        Community[] resultsCommunities = new Community[commCount];
        Collection[] resultsCollections = new Collection[collCount];
        Item[] resultsItems = new Item[itemCount];
        collCount = 0;
        commCount = 0;
        itemCount = 0;
        block13: for (i = 0; i < qResults.getHitTypes().size(); ++i) {
            Integer myId = (Integer)qResults.getHitIds().get(i);
            String myHandle = (String)qResults.getHitHandles().get(i);
            Integer myType = (Integer)qResults.getHitTypes().get(i);
            switch (myType) {
                case 2: {
                    resultsItems[itemCount] = myId != null ? Item.find((Context)context, (int)myId) : (Item)HandleManager.resolveToObject((Context)context, (String)myHandle);
                    if (resultsItems[itemCount] == null) {
                        throw new SQLException("Query \"" + query + "\" returned unresolvable item");
                    }
                    ++itemCount;
                    continue block13;
                }
                case 3: {
                    resultsCollections[collCount] = myId != null ? Collection.find((Context)context, (int)myId) : (Collection)HandleManager.resolveToObject((Context)context, (String)myHandle);
                    if (resultsCollections[collCount] == null) {
                        throw new SQLException("Query \"" + query + "\" returned unresolvable collection");
                    }
                    ++collCount;
                    continue block13;
                }
                case 4: {
                    resultsCommunities[commCount] = myId != null ? Community.find((Context)context, (int)myId) : (Community)HandleManager.resolveToObject((Context)context, (String)myHandle);
                    if (resultsCommunities[commCount] == null) {
                        throw new SQLException("Query \"" + query + "\" returned unresolvable community");
                    }
                    ++commCount;
                }
            }
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"search", (String)(logInfo + "query=\"" + query + "\",results=(" + resultsCommunities.length + "," + resultsCollections.length + "," + resultsItems.length + ")")));
        int pageTotal = 1 + (qResults.getHitCount() - 1) / qResults.getPageSize();
        int pageCurrent = 1 + qResults.getStart() / qResults.getPageSize();
        int pageLast = pageCurrent + 9 > pageTotal ? pageTotal : pageCurrent + 9;
        int pageFirst = pageCurrent - 9 > 1 ? pageCurrent - 9 : 1;
        request.setAttribute("items", (Object)resultsItems);
        request.setAttribute("communities", (Object)resultsCommunities);
        request.setAttribute("collections", (Object)resultsCollections);
        request.setAttribute("pagetotal", (Object)new Integer(pageTotal));
        request.setAttribute("pagecurrent", (Object)new Integer(pageCurrent));
        request.setAttribute("pagelast", (Object)new Integer(pageLast));
        request.setAttribute("pagefirst", (Object)new Integer(pageFirst));
        request.setAttribute("queryresults", (Object)qResults);
        request.setAttribute("query", (Object)query);
        request.setAttribute("order", (Object)qArgs.getSortOrder());
        request.setAttribute("sortedBy", (Object)sortOption);
        if (fromAdvanced != null && qResults.getHitCount() == 0) {
            Community[] communities = Community.findAll((Context)context);
            request.setAttribute("communities", (Object)communities);
            request.setAttribute("no_results", (Object)"yes");
            queryHash = qArgs.buildQueryHash(request);
            for (String key : queryHash.keySet()) {
                String value = (String)queryHash.get(key);
                request.setAttribute(key, (Object)value);
            }
            JSPManager.showJSP(request, response, "/search/advanced.jsp");
        } else {
            JSPManager.showJSP(request, response, "/search/results.jsp");
        }
    }
}

