/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.submit.JSPStepManager;
import org.dspace.app.webui.util.FileUploadRequest;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.submit.AbstractProcessingStep;
import org.dspace.workflow.WorkflowItem;

public class SubmissionController
extends DSpaceServlet {
    public static final int SELECT_COLLECTION = 0;
    public static final int BEFORE_FIRST_STEP = 0;
    public static int FIRST_STEP = 1;
    private static String COMPLETE_JSP = "/submit/complete.jsp";
    private static Logger log = Logger.getLogger(SubmissionController.class);
    private SubmissionStepConfig currentStepConfig;

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String workspaceID = request.getParameter("resume");
        String workflowID = request.getParameter("workflow");
        if (workspaceID != null) {
            try {
                WorkspaceItem wi = WorkspaceItem.find((Context)context, (int)Integer.parseInt(workspaceID));
                SubmissionInfo si = SubmissionInfo.load((HttpServletRequest)request, (InProgressSubmission)wi);
                if (SubmissionController.getStepReached(si) >= si.getSubmissionConfig().getNumberOfSteps()) {
                    int lastStep = si.getSubmissionConfig().getNumberOfSteps() - 1;
                    wi.setStageReached(lastStep);
                    wi.setPageReached(AbstractProcessingStep.LAST_PAGE_REACHED);
                    wi.update();
                    context.commit();
                    si.setSubmissionItem((InProgressSubmission)wi);
                }
                SubmissionController.setBeginningOfStep(request, true);
                this.doStep(context, request, response, si, FIRST_STEP);
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"bad_workspace_id", (String)("bad_id=" + workspaceID)));
                JSPManager.showInvalidIDError(request, response, workspaceID, -1);
            }
        } else if (workflowID != null) {
            try {
                WorkflowItem wi = WorkflowItem.find((Context)context, (int)Integer.parseInt(workflowID));
                SubmissionInfo si = SubmissionInfo.load((HttpServletRequest)request, (InProgressSubmission)wi);
                FIRST_STEP = 0;
                SubmissionController.setBeginningOfStep(request, true);
                this.doStep(context, request, response, si, FIRST_STEP);
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"bad_workflow_id", (String)("bad_id=" + workflowID)));
                JSPManager.showInvalidIDError(request, response, workflowID, -1);
            }
        } else {
            this.doDSPost(context, request, response);
        }
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        SubmissionInfo subInfo;
        String contentType = request.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            request = this.wrapMultipartRequest(request);
            this.uploadFiles(context, request);
        }
        if ((subInfo = SubmissionController.getSubmissionInfo(context, request)) == null) {
            if (request.getSession().getAttribute("removed_thesis") != null) {
                request.getSession().removeAttribute("removed_thesis");
                JSPManager.showJSP(request, response, "/submit/thesis-removed-workaround.jsp");
                return;
            }
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
            JSPManager.showIntegrityError(request, response);
            return;
        }
        if (UIUtil.getSubmitButton((HttpServletRequest)request, (String)"").equals(AbstractProcessingStep.CANCEL_BUTTON)) {
            this.doCancelOrSave(context, request, response, subInfo, this.currentStepConfig);
        } else if (subInfo.getSubmissionItem() == null) {
            this.doStep(context, request, response, subInfo, 0);
        } else {
            this.currentStepConfig = SubmissionController.getCurrentStepConfig(request, subInfo);
            if (UIUtil.getBoolParameter((HttpServletRequest)request, (String)"cancellation")) {
                this.processCancelOrSave(context, request, response, subInfo);
            } else if (UIUtil.getSubmitButton((HttpServletRequest)request, (String)"").startsWith(AbstractProcessingStep.PREVIOUS_BUTTON)) {
                this.doPreviousStep(context, request, response, subInfo);
            } else if (UIUtil.getSubmitButton((HttpServletRequest)request, (String)"").startsWith(AbstractProcessingStep.PROGRESS_BAR_PREFIX)) {
                this.doStepJump(context, request, response, subInfo);
            } else {
                this.doStep(context, request, response, subInfo, this.currentStepConfig.getStepNumber());
            }
        }
    }

    private void doStep(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, int stepNumber) throws ServletException, IOException, SQLException, AuthorizeException {
        if (subInfo.getSubmissionConfig() != null) {
            this.currentStepConfig = subInfo.getSubmissionConfig().getStep(stepNumber);
        } else {
            log.fatal((Object)LogManager.getHeader((Context)context, (String)"no_submission_process", (String)("trying to load step=" + stepNumber + ", but submission process is null")));
            JSPManager.showInternalError(request, response);
        }
        if (!subInfo.isInWorkflow() && this.currentStepConfig.getStepNumber() > SubmissionController.getStepReached(subInfo)) {
            this.userHasReached(subInfo, this.currentStepConfig.getStepNumber());
            context.commit();
            SubmissionController.setBeginningOfStep(request, true);
        }
        SubmissionController.saveCurrentStepConfig(request, this.currentStepConfig);
        log.debug((Object)("Calling Step Class: '" + this.currentStepConfig.getProcessingClassName() + "'"));
        try {
            JSPStepManager stepManager = JSPStepManager.loadStep(this.currentStepConfig);
            boolean stepFinished = stepManager.processStep(context, request, response, subInfo);
            if (stepFinished) {
                if (request instanceof FileUploadRequest) {
                    request = ((FileUploadRequest)request).getOriginalRequest();
                }
                subInfo = SubmissionController.getSubmissionInfo(context, request);
                this.doNextStep(context, request, response, subInfo);
            } else {
                context.complete();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error loading step class'" + this.currentStepConfig.getProcessingClassName() + "':"), (Throwable)e);
            JSPManager.showInternalError(request, response);
        }
    }

    private void doNextStep(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        int currentStepNum = this.currentStepConfig == null ? -1 : this.currentStepConfig.getStepNumber();
        if (subInfo.getSubmissionConfig().hasMoreSteps(currentStepNum)) {
            SubmissionController.setBeginningOfStep(request, true);
            this.doStep(context, request, response, subInfo, ++currentStepNum);
        } else if (subInfo.isInWorkflow()) {
            request.setAttribute("workflow.item", (Object)subInfo.getSubmissionItem());
            JSPManager.showJSP(request, response, "/mydspace/perform-task.jsp");
        } else {
            SubmissionController.saveSubmissionInfo(request, subInfo);
            SubmissionController.showProgressAwareJSP(request, response, subInfo, COMPLETE_JSP);
        }
    }

    private void doPreviousStep(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        int currentStepNum = this.currentStepConfig == null ? -1 : this.currentStepConfig.getStepNumber();
        int currentPageNum = AbstractProcessingStep.getCurrentPage((HttpServletRequest)request);
        boolean foundPrevious = false;
        if (currentPageNum > 1) {
            AbstractProcessingStep.setCurrentPage((HttpServletRequest)request, (int)(currentPageNum - 1));
            foundPrevious = true;
            SubmissionController.setBeginningOfStep(request, true);
            this.doStep(context, request, response, subInfo, currentStepNum);
        } else if (currentStepNum > FIRST_STEP) {
            while (currentStepNum > FIRST_STEP) {
                this.currentStepConfig = subInfo.getSubmissionConfig().getStep(--currentStepNum);
                if (!this.currentStepConfig.isVisible()) continue;
                foundPrevious = true;
                break;
            }
            if (foundPrevious) {
                request.setAttribute("step.backwards", (Object)new Boolean(true));
                SubmissionController.setBeginningOfStep(request, true);
                this.doStep(context, request, response, subInfo, currentStepNum);
            }
        }
        if (!foundPrevious) {
            log.error((Object)LogManager.getHeader((Context)context, (String)"no_previous_visible_step", (String)("Attempting to go to previous step for step=" + currentStepNum + "." + "NO PREVIOUS VISIBLE STEP OR PAGE FOUND!")));
            JSPManager.showIntegrityError(request, response);
        }
    }

    public void doStepJump(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"");
        if (request instanceof FileUploadRequest) {
            FileUploadRequest fur = (FileUploadRequest)request;
            request = fur.getOriginalRequest();
        }
        int nextStep = -1;
        int nextPage = -1;
        if (buttonPressed.startsWith("submit_jump_")) {
            try {
                String stepAndPage = buttonPressed.substring(12);
                String[] fields = stepAndPage.split("\\.");
                nextStep = Integer.parseInt(fields[0]);
                nextPage = Integer.parseInt(fields[1]);
            }
            catch (NumberFormatException ne) {
                nextStep = -1;
                nextPage = -1;
            }
            if (nextStep < FIRST_STEP) {
                nextStep = -1;
                nextPage = -1;
            }
            if (!subInfo.isInWorkflow() && nextStep > SubmissionController.getStepReached(subInfo)) {
                nextStep = -1;
            }
        }
        if (nextStep == -1) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
            JSPManager.showIntegrityError(request, response);
        } else {
            AbstractProcessingStep.setCurrentPage((HttpServletRequest)request, (int)nextPage);
            SubmissionController.setBeginningOfStep(request, true);
            log.debug((Object)("Jumping to Step " + nextStep + " and Page " + nextPage));
            this.doStep(context, request, response, subInfo, nextStep);
        }
    }

    private void doCancelOrSave(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, SubmissionStepConfig stepConfig) throws ServletException, IOException, SQLException {
        if (subInfo.isInWorkflow()) {
            request.setAttribute("workflow.item", (Object)subInfo.getSubmissionItem());
            JSPManager.showJSP(request, response, "/mydspace/perform-task.jsp");
        } else if (subInfo.getSubmissionItem() == null) {
            JSPManager.showJSP(request, response, "/submit/cancelled-removed.jsp");
        } else {
            try {
                if (!Class.forName("org.dspace.app.webui.util.FileUploadRequest").isInstance(request)) {
                    log.debug((Object)("Cancel/Save Request: calling processing for Step: '" + this.currentStepConfig.getProcessingClassName() + "'"));
                    try {
                        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
                        Class<?> stepClass = loader.loadClass(this.currentStepConfig.getProcessingClassName());
                        AbstractProcessingStep step = (AbstractProcessingStep)stepClass.newInstance();
                        SubmissionController.setCancellationInProgress(request, true);
                        step.doProcessing(context, request, response, subInfo);
                        context.complete();
                    }
                    catch (Exception e) {
                        log.error((Object)("Error loading step class'" + this.currentStepConfig.getProcessingClassName() + "':"), (Throwable)e);
                        JSPManager.showInternalError(request, response);
                    }
                }
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            SubmissionController.saveSubmissionInfo(request, subInfo);
            SubmissionController.saveCurrentStepConfig(request, stepConfig);
            SubmissionController.showProgressAwareJSP(request, response, subInfo, "/submit/cancel.jsp");
        }
    }

    private void processCancelOrSave(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_back");
        if (buttonPressed.equals("submit_back")) {
            SubmissionController.setBeginningOfStep(request, true);
            this.doStep(context, request, response, subInfo, this.currentStepConfig.getStepNumber());
        } else if (buttonPressed.equals("submit_remove")) {
            WorkspaceItem wi = (WorkspaceItem)subInfo.getSubmissionItem();
            wi.deleteAll();
            JSPManager.showJSP(request, response, "/submit/cancelled-removed.jsp");
            context.complete();
        } else if (buttonPressed.equals("submit_keep")) {
            JSPManager.showJSP(request, response, "/submit/saved.jsp");
        } else {
            this.doStepJump(context, request, response, subInfo);
        }
    }

    private static void showProgressAwareJSP(HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, String jspPath) throws ServletException, IOException {
        SubmissionController.saveSubmissionInfo(request, subInfo);
        JSPManager.showJSP(request, response, jspPath);
    }

    public static SubmissionInfo getSubmissionInfo(Context context, HttpServletRequest request) throws SQLException, ServletException {
        SubmissionInfo info = null;
        if (request.getAttribute("submission.info") != null) {
            info = (SubmissionInfo)request.getAttribute("submission.info");
        } else {
            if (request.getParameter("workflow_id") != null) {
                int workflowID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"workflow_id");
                info = SubmissionInfo.load((HttpServletRequest)request, (InProgressSubmission)WorkflowItem.find((Context)context, (int)workflowID));
            } else if (request.getParameter("workspace_item_id") != null) {
                int workspaceID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"workspace_item_id");
                info = SubmissionInfo.load((HttpServletRequest)request, (InProgressSubmission)WorkspaceItem.find((Context)context, (int)workspaceID));
            } else {
                info = SubmissionInfo.load((HttpServletRequest)request, null);
            }
            if (SubmissionController.getStepReached(info) > FIRST_STEP && info.getSubmissionItem() == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"cannot_load_submission_info", (String)"InProgressSubmission is null!"));
                return null;
            }
            if (request.getParameter("bundle_id") != null) {
                int bundleID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"bundle_id");
                info.setBundle(Bundle.find((Context)context, (int)bundleID));
            }
            if (request.getParameter("bitstream_id") != null) {
                int bitstreamID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"bitstream_id");
                info.setBitstream(Bitstream.find((Context)context, (int)bitstreamID));
            }
            SubmissionController.saveSubmissionInfo(request, info);
        }
        return info;
    }

    public static void saveSubmissionInfo(HttpServletRequest request, SubmissionInfo si) {
        request.setAttribute("submission.info", (Object)si);
    }

    public static SubmissionStepConfig getCurrentStepConfig(HttpServletRequest request, SubmissionInfo si) {
        int stepNum = -1;
        SubmissionStepConfig step = (SubmissionStepConfig)request.getAttribute("step");
        if (step == null) {
            stepNum = UIUtil.getIntParameter((HttpServletRequest)request, (String)"step");
            if (stepNum < 0 || si == null || si.getSubmissionConfig() == null) {
                return null;
            }
            return si.getSubmissionConfig().getStep(stepNum);
        }
        return step;
    }

    public static void saveCurrentStepConfig(HttpServletRequest request, SubmissionStepConfig step) {
        request.setAttribute("step", (Object)step);
    }

    public static boolean isFirstStep(HttpServletRequest request, SubmissionInfo si) {
        SubmissionStepConfig step = SubmissionController.getCurrentStepConfig(request, si);
        return step != null && step.getStepNumber() == FIRST_STEP;
    }

    public static boolean isBeginningOfStep(HttpServletRequest request) {
        Boolean stepStart = (Boolean)request.getAttribute("step.start");
        if (stepStart != null) {
            return stepStart;
        }
        return false;
    }

    public static void setBeginningOfStep(HttpServletRequest request, boolean beginningOfStep) {
        request.setAttribute("step.start", (Object)new Boolean(beginningOfStep));
    }

    public static boolean isCancellationInProgress(HttpServletRequest request) {
        Boolean cancellation = (Boolean)request.getAttribute("submission.cancellation");
        if (cancellation != null) {
            return cancellation;
        }
        return false;
    }

    private static void setCancellationInProgress(HttpServletRequest request, boolean cancellationInProgress) {
        request.setAttribute("submission.cancellation", (Object)new Boolean(cancellationInProgress));
    }

    public static String getSubmissionParameters(Context context, HttpServletRequest request) throws SQLException, ServletException {
        SubmissionInfo si = SubmissionController.getSubmissionInfo(context, request);
        SubmissionStepConfig step = SubmissionController.getCurrentStepConfig(request, si);
        String info = "";
        if (si.getSubmissionItem() != null && si.isInWorkflow()) {
            info = info + "<input type=\"hidden\" name=\"workflow_id\" value=\"" + si.getSubmissionItem().getID() + "\"/>";
        } else if (si.getSubmissionItem() != null) {
            info = info + "<input type=\"hidden\" name=\"workspace_item_id\" value=\"" + si.getSubmissionItem().getID() + "\"/>";
        }
        if (si.getBundle() != null) {
            info = info + "<input type=\"hidden\" name=\"bundle_id\" value=\"" + si.getBundle().getID() + "\"/>";
        }
        if (si.getBitstream() != null) {
            info = info + "<input type=\"hidden\" name=\"bitstream_id\" value=\"" + si.getBitstream().getID() + "\"/>";
        }
        if (step != null) {
            info = info + "<input type=\"hidden\" name=\"step\" value=\"" + step.getStepNumber() + "\"/>";
        }
        int page = AbstractProcessingStep.getCurrentPage((HttpServletRequest)request);
        info = info + "<input type=\"hidden\" name=\"page\" value=\"" + page + "\"/>";
        String jspDisplayed = JSPStepManager.getLastJSPDisplayed(request);
        info = info + "<input type=\"hidden\" name=\"jsp\" value=\"" + jspDisplayed + "\"/>";
        return info;
    }

    private void userHasReached(SubmissionInfo subInfo, int step) throws SQLException, AuthorizeException, IOException {
        WorkspaceItem wi;
        if (!subInfo.isInWorkflow() && subInfo.getSubmissionItem() != null && step > (wi = (WorkspaceItem)subInfo.getSubmissionItem()).getStageReached()) {
            wi.setStageReached(step);
            wi.setPageReached(1);
            wi.update();
        }
    }

    public static int getStepReached(SubmissionInfo subInfo) {
        if (subInfo == null || subInfo.isInWorkflow() || subInfo.getSubmissionItem() == null) {
            return -1;
        }
        WorkspaceItem wi = (WorkspaceItem)subInfo.getSubmissionItem();
        int i = wi.getStageReached();
        if (i == -1) {
            i = FIRST_STEP;
        }
        return i;
    }

    private HttpServletRequest wrapMultipartRequest(HttpServletRequest request) throws ServletException {
        try {
            if (!Class.forName("org.dspace.app.webui.util.FileUploadRequest").isInstance(request)) {
                FileUploadRequest wrappedRequest = new FileUploadRequest(request);
                return wrappedRequest;
            }
            return request;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void uploadFiles(Context context, HttpServletRequest request) throws ServletException {
        FileUploadRequest wrapper = null;
        String filePath = null;
        BufferedInputStream fileInputStream = null;
        try {
            wrapper = Class.forName("org.dspace.app.webui.util.FileUploadRequest").isInstance(request) ? (FileUploadRequest)request : new FileUploadRequest(request);
            Enumeration fileParams = wrapper.getFileParameterNames();
            while (fileParams.hasMoreElements()) {
                String fileName = (String)fileParams.nextElement();
                File temp = wrapper.getFile(fileName);
                if (temp == null || temp.length() <= 0L) continue;
                fileInputStream = new BufferedInputStream(new FileInputStream(temp));
                filePath = wrapper.getFilesystemName(fileName);
                temp.delete();
                request.setAttribute(fileName + "-path", (Object)filePath);
                request.setAttribute(fileName + "-inputstream", (Object)fileInputStream);
                request.setAttribute(fileName + "-description", (Object)wrapper.getParameter("description"));
            }
        }
        catch (Exception e) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"upload_error", (String)""), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }
}

