/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.core.Context;

public class MetadataFieldRegistryServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(MetadataFieldRegistryServlet.class);
    private String clazz = "org.dspace.app.webui.servlet.admin.MetadataFieldRegistryServlet";

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int schemaID = this.getSchemaID(request);
        this.showTypes(context, request, response, schemaID);
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        block22: {
            String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
            int schemaID = this.getSchemaID(request);
            Locale locale = context.getCurrentLocale();
            ResourceBundle labels = ResourceBundle.getBundle("Messages", locale);
            if (button.equals("submit_update")) {
                if (!this.sanityCheck(request, labels)) {
                    this.showTypes(context, request, response, schemaID);
                    context.abort();
                    return;
                }
                try {
                    MetadataField dc = MetadataField.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"dc_type_id"));
                    dc.setElement(request.getParameter("element"));
                    String qual = request.getParameter("qualifier");
                    if (qual.equals("")) {
                        qual = null;
                    }
                    dc.setQualifier(qual);
                    dc.setScopeNote(request.getParameter("scope_note"));
                    dc.update(context);
                    this.showTypes(context, request, response, schemaID);
                    context.complete();
                }
                catch (NonUniqueMetadataException e) {
                    context.abort();
                    log.error((Object)e);
                }
            } else if (button.equals("submit_add")) {
                if (!this.sanityCheck(request, labels)) {
                    this.showTypes(context, request, response, schemaID);
                    context.abort();
                    return;
                }
                try {
                    MetadataField dc = new MetadataField();
                    dc.setSchemaID(schemaID);
                    dc.setElement(request.getParameter("element"));
                    String qual = request.getParameter("qualifier");
                    if (qual.equals("")) {
                        qual = null;
                    }
                    dc.setQualifier(qual);
                    dc.setScopeNote(request.getParameter("scope_note"));
                    dc.create(context);
                    this.showTypes(context, request, response, schemaID);
                    context.complete();
                }
                catch (NonUniqueMetadataException e) {
                    log.warn((Object)e);
                    request.setAttribute("error", (Object)labels.getString(this.clazz + ".createfailed"));
                    this.showTypes(context, request, response, schemaID);
                    context.abort();
                }
            } else if (button.equals("submit_delete")) {
                MetadataField dc = MetadataField.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"dc_type_id"));
                request.setAttribute("type", (Object)dc);
                JSPManager.showJSP(request, response, "/dspace-admin/confirm-delete-mdfield.jsp");
            } else if (button.equals("submit_confirm_delete")) {
                MetadataField dc = MetadataField.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"dc_type_id"));
                dc.delete(context);
                this.showTypes(context, request, response, schemaID);
                context.complete();
            } else if (button.equals("submit_move")) {
                try {
                    schemaID = Integer.parseInt(request.getParameter("dc_dest_schema_id"));
                    String[] param = request.getParameterValues("dc_field_id");
                    if (schemaID == 0 || param == null) {
                        request.setAttribute("error", (Object)labels.getString(this.clazz + ".movearguments"));
                        this.showTypes(context, request, response, schemaID);
                        context.abort();
                        break block22;
                    }
                    for (int ii = 0; ii < param.length; ++ii) {
                        int fieldID = Integer.parseInt(param[ii]);
                        MetadataField field = MetadataField.find((Context)context, (int)fieldID);
                        field.setSchemaID(schemaID);
                        field.update(context);
                    }
                    context.complete();
                    response.sendRedirect(request.getContextPath() + "/dspace-admin/metadata-schema-registry?dc_schema_id=" + schemaID);
                }
                catch (NonUniqueMetadataException e) {
                    log.warn((Object)e);
                    request.setAttribute("error", (Object)labels.getString(this.clazz + ".movefailed"));
                    this.showTypes(context, request, response, schemaID);
                    context.abort();
                }
            } else {
                this.showTypes(context, request, response, schemaID);
            }
        }
    }

    private int getSchemaID(HttpServletRequest request) {
        int schemaID = 1;
        if (request.getParameter("dc_schema_id") != null) {
            schemaID = Integer.parseInt(request.getParameter("dc_schema_id"));
        }
        return schemaID;
    }

    private void showTypes(Context context, HttpServletRequest request, HttpServletResponse response, int schemaID) throws ServletException, IOException, SQLException, AuthorizeException {
        MetadataField[] types = MetadataField.findAllInSchema((Context)context, (int)schemaID);
        request.setAttribute("types", (Object)types);
        MetadataSchema schema = MetadataSchema.find((Context)context, (int)schemaID);
        request.setAttribute("schema", (Object)schema);
        MetadataSchema[] schemas = MetadataSchema.findAll((Context)context);
        request.setAttribute("schemas", (Object)schemas);
        JSPManager.showJSP(request, response, "/dspace-admin/list-metadata-fields.jsp");
    }

    private boolean sanityCheck(HttpServletRequest request, ResourceBundle labels) {
        String element = request.getParameter("element");
        if (element.length() == 0) {
            return this.error(request, labels.getString(this.clazz + ".elemempty"));
        }
        for (int ii = 0; ii < element.length(); ++ii) {
            if (element.charAt(ii) != '.' && element.charAt(ii) != '_' && element.charAt(ii) != ' ') continue;
            return this.error(request, labels.getString(this.clazz + ".badelemchar"));
        }
        if (element.length() > 64) {
            return this.error(request, labels.getString(this.clazz + ".elemtoolong"));
        }
        String qualifier = request.getParameter("qualifier");
        if (qualifier == "") {
            qualifier = null;
        }
        if (qualifier != null) {
            if (qualifier.length() > 64) {
                return this.error(request, labels.getString(this.clazz + ".qualtoolong"));
            }
            for (int ii = 0; ii < qualifier.length(); ++ii) {
                if (qualifier.charAt(ii) != '.' && qualifier.charAt(ii) != '_' && qualifier.charAt(ii) != ' ') continue;
                return this.error(request, labels.getString(this.clazz + ".badqualchar"));
            }
        }
        return true;
    }

    private boolean error(HttpServletRequest request, String text) {
        request.setAttribute("error", (Object)text);
        return false;
    }
}

