/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.servlet.LDAPResult;
import org.dspace.app.webui.util.Authenticate;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;

public class LDAPServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(LDAPServlet.class);

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        boolean ldap_enabled = ConfigurationManager.getBooleanProperty((String)"ldap.enable");
        if (ldap_enabled) {
            JSPManager.showJSP(request, response, "/login/ldap.jsp");
        } else {
            JSPManager.showJSP(request, response, "/login/password.jsp");
        }
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String netid = request.getParameter("login_netid");
        String password = request.getParameter("login_password");
        EPerson eperson = EPerson.findByNetid((Context)context, (String)netid.toLowerCase());
        EPerson eperson2 = EPerson.findByEmail((Context)context, (String)netid.toLowerCase());
        boolean loggedIn = false;
        LDAPResult ldapResult = new LDAPResult();
        ldapResult.givenName = null;
        ldapResult.surname = null;
        ldapResult.email = null;
        ldapResult.phone = null;
        if (eperson != null && eperson.canLogIn()) {
            if (eperson.getRequireCertificate()) {
                JSPManager.showJSP(request, response, "/error/require-certificate.jsp");
                return;
            }
            if (this.ldapAuthenticate(netid, password, context, ldapResult)) {
                Authenticate.loggedIn(context, request, eperson);
                log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=ldap"));
                Authenticate.resumeInterruptedRequest(request, response);
                return;
            }
            JSPManager.showJSP(request, response, "/login/ldap-incorrect.jsp");
            return;
        }
        if (eperson2 != null && eperson2.canLogIn()) {
            if (eperson2.getRequireCertificate()) {
                JSPManager.showJSP(request, response, "/error/require-certificate.jsp");
                return;
            }
            if (eperson2.checkPassword(password)) {
                Authenticate.loggedIn(context, request, eperson2);
                log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=password"));
                Authenticate.resumeInterruptedRequest(request, response);
                return;
            }
            JSPManager.showJSP(request, response, "/login/ldap-incorrect.jsp");
            return;
        }
        if (this.ldapAuthenticate(netid, password, context, ldapResult)) {
            if (ConfigurationManager.getBooleanProperty((String)"webui.ldap.autoregister")) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"autoregister", (String)("netid=" + netid)));
                if (ldapResult.email != null && !ldapResult.email.equals("") && (eperson = EPerson.findByEmail((Context)context, (String)ldapResult.email)) != null) {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"failed_autoregister", (String)"type=ldap_but_already_email"));
                    JSPManager.showJSP(request, response, "/register/already-registered.jsp");
                    return;
                }
                context.setIgnoreAuthorization(true);
                eperson = EPerson.create((Context)context);
                if (ldapResult.email != null && !ldapResult.email.equals("")) {
                    eperson.setEmail(ldapResult.email);
                } else {
                    eperson.setEmail(netid);
                }
                if (ldapResult.givenName != null && !ldapResult.givenName.equals("")) {
                    eperson.setFirstName(ldapResult.givenName);
                }
                if (ldapResult.surname != null && !ldapResult.surname.equals("")) {
                    eperson.setLastName(ldapResult.surname);
                }
                if (ldapResult.phone != null && !ldapResult.phone.equals("")) {
                    eperson.setMetadata("phone", ldapResult.phone);
                }
                eperson.setNetid(netid);
                eperson.setCanLogIn(true);
                AuthenticationManager.initEPerson((Context)context, (HttpServletRequest)request, (EPerson)eperson);
                eperson.update();
                context.commit();
                context.setIgnoreAuthorization(false);
                Authenticate.loggedIn(context, request, eperson);
                log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=ldap-login"));
                Authenticate.resumeInterruptedRequest(request, response);
                return;
            }
            log.info((Object)LogManager.getHeader((Context)context, (String)"failed_login", (String)"type=ldap_but_no_record"));
            JSPManager.showJSP(request, response, "/login/not-in-records.jsp");
            return;
        }
        log.info((Object)LogManager.getHeader((Context)context, (String)"failed_login", (String)("netid=" + netid)));
        JSPManager.showJSP(request, response, "/login/ldap-incorrect.jsp");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean ldapAuthenticate(String netid, String password, Context context, LDAPResult ldapResult) {
        if (password.equals("")) return false;
        String ldap_provider_url = ConfigurationManager.getProperty((String)"ldap.provider_url");
        String ldap_id_field = ConfigurationManager.getProperty((String)"ldap.id_field");
        String ldap_search_context = ConfigurationManager.getProperty((String)"ldap.search_context");
        String ldap_object_context = ConfigurationManager.getProperty((String)"ldap.object_context");
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldap_provider_url);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", ldap_id_field + "=" + netid + "," + ldap_object_context);
        env.put("java.naming.security.credentials", password);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            String ldap_email_field = ConfigurationManager.getProperty((String)"ldap.email_field");
            String ldap_givenname_field = ConfigurationManager.getProperty((String)"ldap.givenname_field");
            String ldap_surname_field = ConfigurationManager.getProperty((String)"ldap.surname_field");
            String ldap_phone_field = ConfigurationManager.getProperty((String)"ldap.phone_field");
            BasicAttributes matchAttrs = new BasicAttributes(true);
            matchAttrs.put(new BasicAttribute(ldap_id_field, netid));
            String[] attlist = new String[]{ldap_email_field, ldap_givenname_field, ldap_surname_field, ldap_phone_field};
            try {
                NamingEnumeration<SearchResult> answer = ctx.search(ldap_search_context, (Attributes)matchAttrs, attlist);
                while (answer.hasMore()) {
                    Attribute att;
                    SearchResult sr = answer.next();
                    Attributes atts = sr.getAttributes();
                    if (attlist[0] != null && (att = atts.get(attlist[0])) != null) {
                        ldapResult.email = (String)att.get();
                    }
                    if (attlist[1] != null && (att = atts.get(attlist[1])) != null) {
                        ldapResult.givenName = (String)att.get();
                    }
                    if (attlist[2] != null && (att = atts.get(attlist[2])) != null) {
                        ldapResult.surname = (String)att.get();
                    }
                    if (attlist[3] == null || (att = atts.get(attlist[3])) == null) continue;
                    ldapResult.phone = (String)att.get();
                }
            }
            catch (NamingException e) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"ldap_attribute_lookup", (String)("type=failed_search " + e)));
                return true;
            }
            ctx.close();
            return true;
        }
        catch (NamingException e) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"ldap_authentication", (String)("type=failed_auth " + e)));
            return false;
        }
    }
}

