/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.handle.HandleManager;

public class SuggestServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(SuggestServlet.class);

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String handle = request.getParameter("handle");
        String title = null;
        String collName = null;
        if (handle != null && !handle.equals("")) {
            Item item = (Item)HandleManager.resolveToObject((Context)context, (String)handle);
            if (item != null) {
                DCValue[] titleDC = item.getDC("title", null, "*");
                if (titleDC != null || titleDC.length > 0) {
                    title = titleDC[0].value;
                }
                Collection[] colls = item.getCollections();
                collName = colls[0].getMetadata("name");
            }
        } else {
            String path = request.getPathInfo();
            log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_id", (String)("path=" + path)));
            JSPManager.showInvalidIDError(request, response, path, -1);
            return;
        }
        if (title == null) {
            title = "";
        }
        if (collName == null) {
            collName = "";
        }
        request.setAttribute("suggest.title", (Object)title);
        EPerson currentUser = context.getCurrentUser();
        String authEmail = null;
        String userName = null;
        if (currentUser != null) {
            authEmail = currentUser.getEmail();
            userName = currentUser.getFullName();
        }
        if (request.getParameter("submit") != null) {
            String senderAddr;
            String senderName;
            String recipAddr = request.getParameter("recip_email");
            if (recipAddr == null || recipAddr.equals("")) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"show_suggest_form", (String)"problem=true"));
                request.setAttribute("suggest.problem", (Object)new Boolean(true));
                JSPManager.showJSP(request, response, "/suggest/suggest.jsp");
                return;
            }
            String recipName = request.getParameter("recip_name");
            if (recipName == null || "".equals(recipName)) {
                try {
                    recipName = I18nUtil.getMessage((String)"org.dspace.app.webui.servlet.SuggestServlet.recipient", (Context)context);
                }
                catch (MissingResourceException e) {
                    log.warn((Object)LogManager.getHeader((Context)context, (String)"show_suggest_form", (String)"Missing Resource: org.dspace.app.webui.servlet.SuggestServlet.sender"));
                    recipName = "colleague";
                }
            }
            if ((senderName = request.getParameter("sender_name")) == null || "".equals(senderName)) {
                if (userName != null) {
                    senderName = userName;
                } else {
                    try {
                        senderName = I18nUtil.getMessage((String)"org.dspace.app.webui.servlet.SuggestServlet.sender", (Context)context);
                    }
                    catch (MissingResourceException e) {
                        log.warn((Object)LogManager.getHeader((Context)context, (String)"show_suggest_form", (String)"Missing Resource: org.dspace.app.webui.servlet.SuggestServlet.sender"));
                        senderName = "A DSpace User";
                    }
                }
            }
            if (((senderAddr = request.getParameter("sender_email")) == null || "".equals(senderAddr)) && authEmail != null) {
                senderAddr = authEmail;
            }
            String itemUri = HandleManager.getCanonicalForm((String)handle);
            String itemUrl = HandleManager.resolveToURL((Context)context, (String)handle);
            String message = request.getParameter("message");
            String siteName = ConfigurationManager.getProperty((String)"dspace.name");
            try {
                Email email = ConfigurationManager.getEmail((String)I18nUtil.getEmailFilename((Locale)context.getCurrentLocale(), (String)"suggest"));
                email.addRecipient(recipAddr);
                email.addArgument((Object)recipName);
                email.addArgument((Object)senderName);
                email.addArgument((Object)siteName);
                email.addArgument((Object)title);
                email.addArgument((Object)itemUri);
                email.addArgument((Object)itemUrl);
                email.addArgument((Object)collName);
                email.addArgument((Object)message);
                if (senderAddr != null && !"".equals(senderAddr)) {
                    email.setReplyTo(senderAddr);
                }
                if (!ConfigurationManager.getBooleanProperty((String)"webui.suggest.enable", (boolean)false)) {
                    throw new MessagingException("Suggest item email not sent - webui.suggest.enable = false");
                }
                email.send();
                log.info((Object)LogManager.getHeader((Context)context, (String)"sent_suggest", (String)("from=" + senderAddr)));
                JSPManager.showJSP(request, response, "/suggest/suggest_ok.jsp");
            }
            catch (MessagingException me) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"error_mailing_suggest", (String)""), (Throwable)me);
                JSPManager.showInternalError(request, response);
            }
        } else {
            log.info((Object)LogManager.getHeader((Context)context, (String)"show_suggest_form", (String)"problem=false"));
            request.setAttribute("authenticated.email", (Object)authEmail);
            request.setAttribute("eperson.name", (Object)userName);
            JSPManager.showJSP(request, response, "/suggest/suggest.jsp");
        }
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSGet(context, request, response);
    }
}

