/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.PolicySet;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.handle.HandleManager;

public class AuthorizeAdminServlet
extends DSpaceServlet {
    protected void doDSGet(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSPost(c, request, response);
    }

    protected void doDSPost(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        if (button.equals("submit_collection")) {
            Collection[] collections = Collection.findAll((Context)c);
            request.setAttribute("collections", (Object)collections);
            JSPManager.showJSP(request, response, "/dspace-admin/collection-select.jsp");
        } else if (button.equals("submit_community")) {
            Community[] communities = Community.findAll((Context)c);
            request.setAttribute("communities", (Object)communities);
            JSPManager.showJSP(request, response, "/dspace-admin/community-select.jsp");
        } else if (button.equals("submit_advanced")) {
            Collection[] collections = Collection.findAll((Context)c);
            Group[] groups = Group.findAll((Context)c, (int)1);
            request.setAttribute("collections", (Object)collections);
            request.setAttribute("groups", (Object)groups);
            JSPManager.showJSP(request, response, "/dspace-admin/authorize-advanced.jsp");
        } else if (button.equals("submit_item")) {
            JSPManager.showJSP(request, response, "/dspace-admin/item-select.jsp");
        } else if (button.equals("submit_item_select")) {
            DSpaceObject dso;
            Item item = null;
            int item_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"item_id");
            String handle = request.getParameter("handle");
            if (item_id > 0) {
                item = Item.find((Context)c, (int)item_id);
            } else if (handle != null && !handle.equals("") && (dso = HandleManager.resolveToObject((Context)c, (String)handle)) != null && dso.getType() == 2) {
                item = (Item)dso;
            }
            if (item == null) {
                request.setAttribute("invalid.id", (Object)new Boolean(true));
                JSPManager.showJSP(request, response, "/dspace-admin/item-select.jsp");
            } else {
                this.prepItemEditForm(c, request, item);
                JSPManager.showJSP(request, response, "/dspace-admin/authorize-item-edit.jsp");
            }
        } else if (button.equals("submit_item_add_policy")) {
            Item item = Item.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"item_id"));
            ResourcePolicy policy = ResourcePolicy.create((Context)c);
            policy.setResource((DSpaceObject)item);
            policy.update();
            Group[] groups = Group.findAll((Context)c, (int)1);
            EPerson[] epeople = EPerson.findAll((Context)c, (int)1);
            request.setAttribute("edit_title", (Object)("Item " + item.getID()));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"item_id");
            request.setAttribute("id", (Object)("" + item.getID()));
            request.setAttribute("newpolicy", (Object)"true");
            JSPManager.showJSP(request, response, "/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_item_edit_policy")) {
            Item item = Item.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"item_id"));
            int policy_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id");
            ResourcePolicy policy = null;
            policy = ResourcePolicy.find((Context)c, (int)policy_id);
            Group[] groups = Group.findAll((Context)c, (int)1);
            EPerson[] epeople = EPerson.findAll((Context)c, (int)1);
            request.setAttribute("edit_title", (Object)("Item " + item.getID()));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"item_id");
            request.setAttribute("id", (Object)("" + item.getID()));
            JSPManager.showJSP(request, response, "/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_bundle_add_policy")) {
            Item item = Item.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"item_id"));
            Bundle bundle = Bundle.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"bundle_id"));
            ResourcePolicy policy = ResourcePolicy.create((Context)c);
            policy.setResource((DSpaceObject)bundle);
            policy.update();
            Group[] groups = Group.findAll((Context)c, (int)1);
            EPerson[] epeople = EPerson.findAll((Context)c, (int)1);
            request.setAttribute("edit_title", (Object)("(Item, Bundle) = (" + item.getID() + "," + bundle.getID() + ")"));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"item_id");
            request.setAttribute("id", (Object)("" + item.getID()));
            request.setAttribute("newpolicy", (Object)"true");
            JSPManager.showJSP(request, response, "/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_bitstream_add_policy")) {
            Item item = Item.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"item_id"));
            Bitstream bitstream = Bitstream.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"bitstream_id"));
            ResourcePolicy policy = ResourcePolicy.create((Context)c);
            policy.setResource((DSpaceObject)bitstream);
            policy.update();
            Group[] groups = Group.findAll((Context)c, (int)1);
            EPerson[] epeople = EPerson.findAll((Context)c, (int)1);
            request.setAttribute("edit_title", (Object)("(Item,Bitstream) = (" + item.getID() + "," + bitstream.getID() + ")"));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"item_id");
            request.setAttribute("id", (Object)("" + item.getID()));
            request.setAttribute("newpolicy", (Object)"true");
            JSPManager.showJSP(request, response, "/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_item_delete_policy")) {
            Item item = Item.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"item_id"));
            ResourcePolicy policy = ResourcePolicy.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id"));
            policy.delete();
            this.prepItemEditForm(c, request, item);
            JSPManager.showJSP(request, response, "/dspace-admin/authorize-item-edit.jsp");
        } else if (button.equals("submit_collection_add_policy")) {
            Collection collection = Collection.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection_id"));
            ResourcePolicy policy = ResourcePolicy.create((Context)c);
            policy.setResource((DSpaceObject)collection);
            policy.update();
            Group[] groups = Group.findAll((Context)c, (int)1);
            EPerson[] epeople = EPerson.findAll((Context)c, (int)1);
            request.setAttribute("edit_title", (Object)("Collection " + collection.getID()));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"collection_id");
            request.setAttribute("id", (Object)("" + collection.getID()));
            request.setAttribute("newpolicy", (Object)"true");
            JSPManager.showJSP(request, response, "/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_community_select")) {
            Community target = Community.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"community_id"));
            List policies = AuthorizeManager.getPolicies((Context)c, (DSpaceObject)target);
            request.setAttribute("community", (Object)target);
            request.setAttribute("policies", (Object)policies);
            JSPManager.showJSP(request, response, "/dspace-admin/authorize-community-edit.jsp");
        } else if (button.equals("submit_collection_delete_policy")) {
            Collection collection = Collection.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection_id"));
            ResourcePolicy policy = ResourcePolicy.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id"));
            policy.delete();
            request.setAttribute("collection", (Object)collection);
            List policies = AuthorizeManager.getPolicies((Context)c, (DSpaceObject)collection);
            request.setAttribute("policies", (Object)policies);
            JSPManager.showJSP(request, response, "/dspace-admin/authorize-collection-edit.jsp");
        } else if (button.equals("submit_community_delete_policy")) {
            Community community = Community.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"community_id"));
            ResourcePolicy policy = ResourcePolicy.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id"));
            policy.delete();
            request.setAttribute("community", (Object)community);
            List policies = AuthorizeManager.getPolicies((Context)c, (DSpaceObject)community);
            request.setAttribute("policies", (Object)policies);
            JSPManager.showJSP(request, response, "/dspace-admin/authorize-community-edit.jsp");
        } else if (button.equals("submit_collection_edit_policy")) {
            Collection collection = Collection.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection_id"));
            int policy_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id");
            ResourcePolicy policy = null;
            if (policy_id == -1) {
                policy = ResourcePolicy.create((Context)c);
                policy.setResource((DSpaceObject)collection);
                policy.update();
            } else {
                policy = ResourcePolicy.find((Context)c, (int)policy_id);
            }
            Group[] groups = Group.findAll((Context)c, (int)1);
            EPerson[] epeople = EPerson.findAll((Context)c, (int)1);
            request.setAttribute("edit_title", (Object)("Collection " + collection.getID()));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"collection_id");
            request.setAttribute("id", (Object)("" + collection.getID()));
            JSPManager.showJSP(request, response, "/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_community_edit_policy")) {
            Community community = Community.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"community_id"));
            int policy_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id");
            ResourcePolicy policy = null;
            if (policy_id == -1) {
                policy = ResourcePolicy.create((Context)c);
                policy.setResource((DSpaceObject)community);
                policy.update();
            } else {
                policy = ResourcePolicy.find((Context)c, (int)policy_id);
            }
            Group[] groups = Group.findAll((Context)c, (int)1);
            EPerson[] epeople = EPerson.findAll((Context)c, (int)1);
            request.setAttribute("edit_title", (Object)("Community " + community.getID()));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"community_id");
            request.setAttribute("id", (Object)("" + community.getID()));
            JSPManager.showJSP(request, response, "/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_collection_add_policy")) {
            Collection collection = Collection.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection_id"));
            ResourcePolicy policy = ResourcePolicy.create((Context)c);
            policy.setResource((DSpaceObject)collection);
            policy.update();
            Group[] groups = Group.findAll((Context)c, (int)1);
            EPerson[] epeople = EPerson.findAll((Context)c, (int)1);
            request.setAttribute("edit_title", (Object)("Collection " + collection.getID()));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"collection_id");
            request.setAttribute("id", (Object)("" + collection.getID()));
            request.setAttribute("newpolicy", (Object)"true");
            JSPManager.showJSP(request, response, "/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_community_add_policy")) {
            Community community = Community.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"community_id"));
            ResourcePolicy policy = ResourcePolicy.create((Context)c);
            policy.setResource((DSpaceObject)community);
            policy.update();
            Group[] groups = Group.findAll((Context)c, (int)1);
            EPerson[] epeople = EPerson.findAll((Context)c, (int)1);
            request.setAttribute("edit_title", (Object)("Community " + community.getID()));
            request.setAttribute("policy", (Object)policy);
            request.setAttribute("groups", (Object)groups);
            request.setAttribute("epeople", (Object)epeople);
            request.setAttribute("id_name", (Object)"community_id");
            request.setAttribute("id", (Object)("" + community.getID()));
            request.setAttribute("newpolicy", (Object)"true");
            JSPManager.showJSP(request, response, "/dspace-admin/authorize-policy-edit.jsp");
        } else if (button.equals("submit_save_policy")) {
            int policy_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id");
            int action_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"action_id");
            int group_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"group_id");
            int collection_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection_id");
            int community_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"community_id");
            int item_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"item_id");
            Item item = null;
            Collection collection = null;
            Community community = null;
            String display_page = null;
            ResourcePolicy policy = ResourcePolicy.find((Context)c, (int)policy_id);
            Group group = Group.find((Context)c, (int)group_id);
            if (collection_id != -1) {
                collection = Collection.find((Context)c, (int)collection_id);
                policy.setAction(action_id);
                policy.setGroup(group);
                policy.update();
                if (action_id == 0) {
                    List rps = AuthorizeManager.getPoliciesActionFilter((Context)c, (DSpaceObject)collection, (int)0);
                    Bitstream bs = collection.getLogo();
                    if (bs != null) {
                        AuthorizeManager.removeAllPolicies((Context)c, (DSpaceObject)bs);
                        AuthorizeManager.addPolicies((Context)c, (List)rps, (DSpaceObject)bs);
                    }
                }
                request.setAttribute("collection", (Object)collection);
                request.setAttribute("policies", (Object)AuthorizeManager.getPolicies((Context)c, (DSpaceObject)collection));
                display_page = "/dspace-admin/authorize-collection-edit.jsp";
            } else if (community_id != -1) {
                community = Community.find((Context)c, (int)community_id);
                policy.setAction(action_id);
                policy.setGroup(group);
                policy.update();
                if (action_id == 0) {
                    List rps = AuthorizeManager.getPoliciesActionFilter((Context)c, (DSpaceObject)community, (int)0);
                    Bitstream bs = community.getLogo();
                    if (bs != null) {
                        AuthorizeManager.removeAllPolicies((Context)c, (DSpaceObject)bs);
                        AuthorizeManager.addPolicies((Context)c, (List)rps, (DSpaceObject)bs);
                    }
                }
                request.setAttribute("community", (Object)community);
                request.setAttribute("policies", (Object)AuthorizeManager.getPolicies((Context)c, (DSpaceObject)community));
                display_page = "/dspace-admin/authorize-community-edit.jsp";
            } else if (item_id != -1) {
                item = Item.find((Context)c, (int)item_id);
                policy.setAction(action_id);
                policy.setGroup(group);
                policy.update();
                this.prepItemEditForm(c, request, item);
                display_page = "/dspace-admin/authorize-item-edit.jsp";
            }
            JSPManager.showJSP(request, response, display_page);
        } else if (button.equals("submit_cancel_policy")) {
            if (request.getParameter("newpolicy") != null) {
                int policy_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"policy_id");
                ResourcePolicy rp = ResourcePolicy.find((Context)c, (int)policy_id);
                rp.delete();
            }
            int collection_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection_id");
            int community_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"community_id");
            int item_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"item_id");
            String display_page = null;
            if (collection_id != -1) {
                Collection t = Collection.find((Context)c, (int)collection_id);
                request.setAttribute("collection", (Object)t);
                request.setAttribute("policies", (Object)AuthorizeManager.getPolicies((Context)c, (DSpaceObject)t));
                display_page = "/dspace-admin/authorize-collection-edit.jsp";
            } else if (community_id != -1) {
                Community t = Community.find((Context)c, (int)community_id);
                request.setAttribute("community", (Object)t);
                request.setAttribute("policies", (Object)AuthorizeManager.getPolicies((Context)c, (DSpaceObject)t));
                display_page = "/dspace-admin/authorize-community-edit.jsp";
            } else if (item_id != -1) {
                Item t = Item.find((Context)c, (int)item_id);
                this.prepItemEditForm(c, request, t);
                display_page = "/dspace-admin/authorize-item-edit.jsp";
            }
            JSPManager.showJSP(request, response, display_page);
        } else if (button.equals("submit_advanced_clear")) {
            int collection_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection_id");
            int resource_type = UIUtil.getIntParameter((HttpServletRequest)request, (String)"resource_type");
            PolicySet.setPolicies((Context)c, (int)3, (int)collection_id, (int)resource_type, (int)0, (int)0, (boolean)false, (boolean)true);
            if (resource_type == 0) {
                PolicySet.setPolicies((Context)c, (int)3, (int)collection_id, (int)1, (int)0, (int)0, (boolean)false, (boolean)true);
            }
            this.showMainPage(c, request, response);
        } else if (button.equals("submit_advanced_add")) {
            int collection_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection_id");
            int resource_type = UIUtil.getIntParameter((HttpServletRequest)request, (String)"resource_type");
            int action_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"action_id");
            int group_id = UIUtil.getIntParameter((HttpServletRequest)request, (String)"group_id");
            PolicySet.setPolicies((Context)c, (int)3, (int)collection_id, (int)resource_type, (int)action_id, (int)group_id, (boolean)false, (boolean)false);
            if (resource_type == 0) {
                PolicySet.setPolicies((Context)c, (int)3, (int)collection_id, (int)1, (int)action_id, (int)group_id, (boolean)false, (boolean)false);
            }
            this.showMainPage(c, request, response);
        } else if (button.equals("submit_collection_select")) {
            Collection collection = Collection.find((Context)c, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection_id"));
            List policies = AuthorizeManager.getPolicies((Context)c, (DSpaceObject)collection);
            request.setAttribute("collection", (Object)collection);
            request.setAttribute("policies", (Object)policies);
            JSPManager.showJSP(request, response, "/dspace-admin/authorize-collection-edit.jsp");
        } else {
            this.showMainPage(c, request, response);
        }
        c.complete();
    }

    void showMainPage(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        JSPManager.showJSP(request, response, "/dspace-admin/authorize-main.jsp");
    }

    void prepItemEditForm(Context c, HttpServletRequest request, Item item) throws SQLException {
        List item_policies = AuthorizeManager.getPolicies((Context)c, (DSpaceObject)item);
        HashMap<Integer, List> bundle_policies = new HashMap<Integer, List>();
        HashMap<Integer, List> bitstream_policies = new HashMap<Integer, List>();
        Bundle[] bundles = item.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bundle myBundle = bundles[i];
            List myPolicies = AuthorizeManager.getPolicies((Context)c, (DSpaceObject)myBundle);
            bundle_policies.put(new Integer(myBundle.getID()), myPolicies);
            Bitstream[] bitstreams = myBundle.getBitstreams();
            for (int j = 0; j < bitstreams.length; ++j) {
                Bitstream myBitstream = bitstreams[j];
                myPolicies = AuthorizeManager.getPolicies((Context)c, (DSpaceObject)myBitstream);
                bitstream_policies.put(new Integer(myBitstream.getID()), myPolicies);
            }
        }
        request.setAttribute("item", (Object)item);
        request.setAttribute("item_policies", (Object)item_policies);
        request.setAttribute("bundles", (Object)bundles);
        request.setAttribute("bundle_policies", bundle_policies);
        request.setAttribute("bitstream_policies", bitstream_policies);
    }
}

