/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class GroupEditServlet
extends DSpaceServlet {
    protected void doDSGet(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSPost(c, request, response);
    }

    protected void doDSPost(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int groupID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"group_id");
        Group group = null;
        if (groupID >= 0) {
            group = Group.find((Context)c, (int)groupID);
        }
        if (group != null) {
            boolean submit_group_delete;
            AuthorizeManager.authorizeAction((Context)c, (DSpaceObject)group, (int)3);
            boolean submit_edit = request.getParameter("submit_edit") != null;
            boolean submit_group_update = request.getParameter("submit_group_update") != null;
            boolean bl = submit_group_delete = request.getParameter("submit_group_delete") != null;
            if (submit_edit && !submit_group_update && !submit_group_delete) {
                request.setAttribute("group", (Object)group);
                request.setAttribute("members", (Object)group.getMembers());
                request.setAttribute("membergroups", (Object)group.getMemberGroups());
                JSPManager.showJSP(request, response, "/tools/group-edit.jsp");
            } else if (submit_group_update) {
                HashSet<Integer> memberSet;
                String newName = request.getParameter("group_name");
                if (!newName.equals(group.getName())) {
                    group.setName(newName);
                    group.update();
                }
                int[] eperson_ids = UIUtil.getIntParameters((HttpServletRequest)request, (String)"eperson_id");
                int[] group_ids = UIUtil.getIntParameters((HttpServletRequest)request, (String)"group_ids");
                EPerson[] members = group.getMembers();
                Group[] membergroups = group.getMemberGroups();
                if (eperson_ids != null) {
                    int x;
                    memberSet = new HashSet<Integer>();
                    HashSet<Integer> epersonIDSet = new HashSet<Integer>();
                    for (x = 0; x < members.length; ++x) {
                        Integer epersonID = new Integer(members[x].getID());
                        memberSet.add(epersonID);
                    }
                    for (x = 0; x < eperson_ids.length; ++x) {
                        epersonIDSet.add(new Integer(eperson_ids[x]));
                    }
                    for (Integer currentID : epersonIDSet) {
                        if (memberSet.contains(currentID)) continue;
                        group.addMember(EPerson.find((Context)c, (int)currentID));
                    }
                    for (int x2 = 0; x2 < members.length; ++x2) {
                        EPerson e = members[x2];
                        if (epersonIDSet.contains(new Integer(e.getID()))) continue;
                        group.removeMember(e);
                    }
                } else {
                    for (int y = 0; y < members.length; ++y) {
                        group.removeMember(members[y]);
                    }
                }
                if (group_ids != null) {
                    int x;
                    memberSet = new HashSet();
                    HashSet<Integer> groupIDSet = new HashSet<Integer>();
                    for (x = 0; x < membergroups.length; ++x) {
                        Integer myID = new Integer(membergroups[x].getID());
                        memberSet.add(myID);
                    }
                    for (x = 0; x < group_ids.length; ++x) {
                        groupIDSet.add(new Integer(group_ids[x]));
                    }
                    for (Integer currentID : groupIDSet) {
                        if (memberSet.contains(currentID)) continue;
                        group.addMember(Group.find((Context)c, (int)currentID));
                    }
                    for (int x3 = 0; x3 < membergroups.length; ++x3) {
                        Group g = membergroups[x3];
                        if (groupIDSet.contains(new Integer(g.getID()))) continue;
                        group.removeMember(g);
                    }
                } else {
                    for (int y = 0; y < membergroups.length; ++y) {
                        group.removeMember(membergroups[y]);
                    }
                }
                group.update();
                request.setAttribute("group", (Object)group);
                request.setAttribute("members", (Object)group.getMembers());
                request.setAttribute("membergroups", (Object)group.getMemberGroups());
                JSPManager.showJSP(request, response, "/tools/group-edit.jsp");
                c.complete();
            } else if (submit_group_delete) {
                AuthorizeManager.authorizeAction((Context)c, (DSpaceObject)group, (int)1);
                group.delete();
                this.showMainPage(c, request, response);
            } else {
                request.setAttribute("group", (Object)group);
                request.setAttribute("members", (Object)group.getMembers());
                request.setAttribute("membergroups", (Object)group.getMemberGroups());
                JSPManager.showJSP(request, response, "/tools/group-edit.jsp");
            }
        } else {
            String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
            if (button.equals("submit_add")) {
                group = Group.create((Context)c);
                group.setName("new group" + group.getID());
                group.update();
                request.setAttribute("group", (Object)group);
                request.setAttribute("members", (Object)group.getMembers());
                request.setAttribute("membergroups", (Object)group.getMemberGroups());
                JSPManager.showJSP(request, response, "/tools/group-edit.jsp");
                c.complete();
            } else {
                this.showMainPage(c, request, response);
            }
        }
    }

    private void showMainPage(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        Group[] groups = Group.findAll((Context)c, (int)1);
        request.setAttribute("groups", (Object)groups);
        JSPManager.showJSP(request, response, "/tools/group-list.jsp");
        c.complete();
    }
}

