/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseInfo;
import org.dspace.browse.BrowserScope;
import org.dspace.browse.IndexBrowse;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class ItemMapServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(ItemMapServlet.class);

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws SQLException, ServletException, IOException, AuthorizeException {
        this.doDSPost(context, request, response);
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws SQLException, ServletException, IOException, AuthorizeException {
        String cancel;
        String jspPage = null;
        int myID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"cid");
        Collection myCollection = Collection.find((Context)context, (int)myID);
        AuthorizeManager.authorizeAction((Context)context, (DSpaceObject)myCollection, (int)11);
        String action = request.getParameter("action");
        if (action == null) {
            action = "";
        }
        if ((cancel = request.getParameter("cancel")) == null) {
            cancel = "";
        }
        if (action.equals("") || !cancel.equals("")) {
            int count_native = 0;
            int count_import = 0;
            HashMap<Integer, Item> myItems = new HashMap<Integer, Item>();
            HashMap<Integer, Collection> myCollections = new HashMap<Integer, Collection>();
            HashMap<Integer, Integer> myCounts = new HashMap<Integer, Integer>();
            ItemIterator i = myCollection.getItems();
            while (i.hasNext()) {
                Item myItem = i.next();
                Integer myKey = new Integer(myItem.getID());
                if (myItem.isOwningCollection(myCollection)) {
                    ++count_native;
                } else {
                    ++count_import;
                }
                Collection owningCollection = myItem.getOwningCollection();
                Integer cKey = new Integer(owningCollection.getID());
                if (myCollections.containsKey(cKey)) {
                    Integer x = (Integer)myCounts.get(cKey);
                    int myCount = x + 1;
                    myCounts.put(cKey, new Integer(myCount));
                } else {
                    myCollections.put(cKey, owningCollection);
                    myCounts.put(cKey, new Integer(1));
                }
                myItems.put(myKey, myItem);
            }
            myCollections.remove(new Integer(myCollection.getID()));
            request.setAttribute("collection", (Object)myCollection);
            request.setAttribute("count_native", (Object)new Integer(count_native));
            request.setAttribute("count_import", (Object)new Integer(count_import));
            request.setAttribute("items", myItems);
            request.setAttribute("collections", myCollections);
            request.setAttribute("collection_counts", myCounts);
            request.setAttribute("all_collections", (Object)Collection.findAll((Context)context));
            jspPage = "itemmap-main.jsp";
            JSPManager.showJSP(request, response, jspPage);
        } else if (action.equals("Remove")) {
            String[] itemIDs = request.getParameterValues("item_ids");
            String message = "remove";
            LinkedList<String> removedItems = new LinkedList<String>();
            for (int j = 0; j < itemIDs.length; ++j) {
                int i = Integer.parseInt(itemIDs[j]);
                removedItems.add(itemIDs[j]);
                Item myItem = Item.find((Context)context, (int)i);
                if (myItem.isOwningCollection(myCollection)) continue;
                myCollection.removeItem(myItem);
                try {
                    IndexBrowse ib = new IndexBrowse(context);
                    ib.itemChanged(myItem);
                    continue;
                }
                catch (BrowseException e) {
                    log.error((Object)"caught exception: ", (Throwable)e);
                    throw new ServletException((Throwable)e);
                }
            }
            request.setAttribute("message", (Object)message);
            request.setAttribute("collection", (Object)myCollection);
            request.setAttribute("processedItems", removedItems);
            jspPage = "itemmap-info.jsp";
            JSPManager.showJSP(request, response, jspPage);
        } else if (action.equals("Add")) {
            String[] itemIDs = request.getParameterValues("item_ids");
            String message = "added";
            LinkedList<String> addedItems = new LinkedList<String>();
            if (itemIDs == null) {
                message = "none-selected";
            } else {
                for (int j = 0; j < itemIDs.length; ++j) {
                    int i = Integer.parseInt(itemIDs[j]);
                    Item myItem = Item.find((Context)context, (int)i);
                    if (!AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)myItem, (int)0) || myItem.isOwningCollection(myCollection)) continue;
                    myCollection.addItem(myItem);
                    try {
                        IndexBrowse ib = new IndexBrowse(context);
                        ib.itemChanged(myItem);
                    }
                    catch (BrowseException e) {
                        log.error((Object)"caught exception: ", (Throwable)e);
                        throw new ServletException((Throwable)e);
                    }
                    addedItems.add(itemIDs[j]);
                }
            }
            request.setAttribute("message", (Object)message);
            request.setAttribute("collection", (Object)myCollection);
            request.setAttribute("processedItems", addedItems);
            jspPage = "itemmap-info.jsp";
            JSPManager.showJSP(request, response, jspPage);
        } else if (action.equals("Search Authors")) {
            String name = request.getParameter("namepart");
            String bidx = ConfigurationManager.getProperty((String)"itemmap.author.index");
            if (bidx == null) {
                throw new ServletException("There is no configuration for itemmap.author.index");
            }
            HashMap<Integer, Item> items = new HashMap<Integer, Item>();
            try {
                BrowserScope bs = new BrowserScope(context);
                BrowseIndex bi = BrowseIndex.getBrowseIndex((String)bidx);
                bs.setBrowseIndex(bi);
                bs.setOrder("ASC");
                bs.setFilterValue(name);
                bs.setFilterValuePartial(true);
                bs.setJumpToValue(null);
                bs.setResultsPerPage(10000);
                bs.setBrowseLevel(1);
                BrowseEngine be = new BrowseEngine(context);
                BrowseInfo results = be.browse(bs);
                Item[] browseItems = results.getItemResults(context);
                ItemIterator itr = myCollection.getItems();
                ArrayList<Integer> idslist = new ArrayList<Integer>();
                while (itr.hasNext()) {
                    idslist.add(new Integer(itr.nextID()));
                }
                for (int i = 0; i < browseItems.length; ++i) {
                    if (idslist.contains(new Integer(browseItems[i].getID())) || !AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)browseItems[i], (int)0)) continue;
                    items.put(new Integer(browseItems[i].getID()), browseItems[i]);
                }
            }
            catch (BrowseException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            request.setAttribute("collection", (Object)myCollection);
            request.setAttribute("browsetext", (Object)name);
            request.setAttribute("items", items);
            request.setAttribute("browsetype", (Object)new String("Add"));
            jspPage = "itemmap-browse.jsp";
            JSPManager.showJSP(request, response, jspPage);
        } else if (action.equals("browse")) {
            int t = UIUtil.getIntParameter((HttpServletRequest)request, (String)"t");
            Collection targetCollection = Collection.find((Context)context, (int)t);
            ItemIterator i = myCollection.getItems();
            HashMap<Integer, Item> items = new HashMap<Integer, Item>();
            while (i.hasNext()) {
                Item myItem = i.next();
                if (!myItem.isOwningCollection(targetCollection)) continue;
                Integer myKey = new Integer(myItem.getID());
                items.put(myKey, myItem);
            }
            request.setAttribute("collection", (Object)myCollection);
            request.setAttribute("browsetext", (Object)targetCollection.getMetadata("name"));
            request.setAttribute("items", items);
            request.setAttribute("browsetype", (Object)new String("Remove"));
            jspPage = "itemmap-browse.jsp";
            JSPManager.showJSP(request, response, jspPage);
        }
        context.complete();
    }
}

