/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Description;
import com.sun.syndication.feed.rss.Image;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.feed.rss.TextInput;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedOutput;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseInfo;
import org.dspace.browse.BrowserScope;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;
import org.dspace.search.Harvest;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;

public class FeedServlet
extends DSpaceServlet {
    public static final String SITE_FEED_KEY = "site";
    private static final long HOUR_MSECS = 3600000L;
    private static Logger log = Logger.getLogger(FeedServlet.class);
    private String clazz = "org.dspace.app.webui.servlet.FeedServlet";
    private static boolean enabled = false;
    private static int itemCount = 0;
    private static Map feedCache = null;
    private static int cacheSize = 0;
    private static int cacheAge = 0;
    private static List formats = null;
    private static ResourceBundle labels = null;
    private static String defaultDescriptionFields = "dc.title, dc.contributor.author, dc.contributor.editor, dc.description.abstract, dc.description";

    public void init() {
        if (enabled) {
            String fmtsStr = ConfigurationManager.getProperty((String)"webui.feed.formats");
            if (fmtsStr != null) {
                formats = new ArrayList();
                String[] fmts = fmtsStr.split(",");
                for (int i = 0; i < fmts.length; ++i) {
                    formats.add(fmts[i]);
                }
            }
            itemCount = ConfigurationManager.getIntProperty((String)"webui.feed.items");
            cacheSize = ConfigurationManager.getIntProperty((String)"webui.feed.cache.size");
            if (cacheSize > 0) {
                feedCache = new HashMap();
                cacheAge = ConfigurationManager.getIntProperty((String)"webui.feed.cache.age");
            }
        }
    }

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        CacheFeed cFeed;
        int split;
        String path = request.getPathInfo();
        String feedType = null;
        String handle = null;
        if (labels == null) {
            Locale locale = request.getLocale();
            labels = ResourceBundle.getBundle("Messages", locale);
        }
        if (path != null && (split = (path = path.substring(1)).indexOf("/")) != -1) {
            feedType = path.substring(0, split);
            handle = path.substring(split + 1);
        }
        DSpaceObject dso = null;
        if (handle != null && !handle.equals(SITE_FEED_KEY)) {
            dso = HandleManager.resolveToObject((Context)context, (String)handle);
        }
        if (!enabled || dso != null && dso.getType() != 3 && dso.getType() != 4) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_id", (String)("path=" + path)));
            JSPManager.showInvalidIDError(request, response, path, -1);
            return;
        }
        if (feedType == null || !formats.contains(feedType)) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_syndformat", (String)("path=" + path)));
            JSPManager.showInvalidIDError(request, response, path, -1);
            return;
        }
        Channel channel = null;
        if (feedCache != null && (cFeed = (CacheFeed)feedCache.get(handle)) != null) {
            boolean cacheFeedCurrent = false;
            if (cFeed.timeStamp + (long)cacheAge * 3600000L < System.currentTimeMillis()) {
                cacheFeedCurrent = true;
            } else if (!this.itemsChanged(context, dso, cFeed.timeStamp)) {
                cFeed.timeStamp = System.currentTimeMillis();
                cacheFeedCurrent = true;
            }
            if (cacheFeedCurrent) {
                channel = cFeed.access();
            }
        }
        if (channel == null) {
            channel = this.generateFeed(context, dso);
            if (feedCache != null) {
                FeedServlet.cache(handle, new CacheFeed(channel));
            }
        }
        channel.setFeedType(feedType);
        WireFeedOutput feedWriter = new WireFeedOutput();
        try {
            response.setContentType("text/xml; charset=UTF-8");
            feedWriter.output((WireFeed)channel, (Writer)response.getWriter());
        }
        catch (FeedException fex) {
            throw new IOException(fex.getMessage());
        }
    }

    private boolean itemsChanged(Context context, DSpaceObject dso, long timeStamp) throws SQLException {
        DCDate dcStartDate = new DCDate(new Date(timeStamp));
        DCDate dcEndDate = new DCDate(new Date(System.currentTimeMillis()));
        String startDate = dcStartDate.toString().substring(0, 10);
        String endDate = dcEndDate.toString().substring(0, 10);
        try {
            return Harvest.harvest((Context)context, (DSpaceObject)dso, (String)startDate, (String)endDate, (int)0, (int)1, (boolean)false, (boolean)false, (boolean)false).size() > 0;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    private Channel generateFeed(Context context, DSpaceObject dso) throws IOException, SQLException {
        try {
            String dspaceUrl = ConfigurationManager.getProperty((String)"dspace.url");
            String type = null;
            String description = null;
            String title = null;
            Bitstream logo = null;
            String idx = ConfigurationManager.getProperty((String)"recent.submissions.sort-option");
            if (idx == null) {
                throw new IOException("There is no configuration supplied for: recent.submissions.sort-option");
            }
            BrowseIndex bix = BrowseIndex.getItemBrowseIndex();
            if (bix == null) {
                throw new IOException("There is no browse index with the name: " + idx);
            }
            BrowserScope scope = new BrowserScope(context);
            scope.setBrowseIndex(bix);
            for (SortOption so : SortOption.getSortOptions()) {
                if (!so.getName().equals(idx)) continue;
                scope.setSortBy(so.getNumber());
            }
            scope.setOrder("DESC");
            Channel channel = new Channel();
            if (dso == null) {
                channel.setTitle(ConfigurationManager.getProperty((String)"dspace.name"));
                channel.setLink(dspaceUrl);
                channel.setDescription(labels.getString(this.clazz + ".general-feed.description"));
            } else {
                if (dso.getType() == 3) {
                    type = labels.getString(this.clazz + ".feed-type.collection");
                    Collection col = (Collection)dso;
                    description = col.getMetadata("short_description");
                    title = col.getMetadata("name");
                    logo = col.getLogo();
                    scope.setBrowseContainer((DSpaceObject)col);
                } else if (dso.getType() == 4) {
                    type = labels.getString(this.clazz + ".feed-type.community");
                    Community comm = (Community)dso;
                    description = comm.getMetadata("short_description");
                    title = comm.getMetadata("name");
                    logo = comm.getLogo();
                    scope.setBrowseContainer((DSpaceObject)comm);
                }
                String objectUrl = ConfigurationManager.getBooleanProperty((String)"webui.feed.localresolve") ? HandleManager.resolveToURL((Context)context, (String)dso.getHandle()) : HandleManager.getCanonicalForm((String)dso.getHandle());
                channel.setDescription(description == null ? "" : description.replaceAll("\\p{Cntrl}", ""));
                channel.setLink(objectUrl);
                String channelTitle = MessageFormat.format(labels.getString(this.clazz + ".feed.title"), type, title);
                channel.setTitle(channelTitle);
                if (logo != null) {
                    Image image = new Image();
                    image.setLink(objectUrl);
                    image.setTitle(labels.getString(this.clazz + ".logo.title"));
                    image.setUrl(dspaceUrl + "/retrieve/" + logo.getID());
                    channel.setImage(image);
                }
            }
            TextInput input = new TextInput();
            input.setLink(dspaceUrl + "/simple-search");
            input.setDescription(labels.getString(this.clazz + ".search.description"));
            String searchTitle = "";
            searchTitle = type != null ? MessageFormat.format(labels.getString(this.clazz + ".search.title"), type) : labels.getString(this.clazz + ".search.title.default");
            input.setTitle(searchTitle);
            input.setName(labels.getString(this.clazz + ".search.name"));
            channel.setTextInput(input);
            scope.setResultsPerPage(itemCount);
            BrowseEngine be = new BrowseEngine(context);
            BrowseInfo bi = be.browseMini(scope);
            org.dspace.content.Item[] results = bi.getItemResults(context);
            ArrayList<Item> items = new ArrayList<Item>();
            for (int i = 0; i < results.length; ++i) {
                items.add(this.itemFromDSpaceItem(context, results[i]));
            }
            channel.setItems(items);
            if (channel.getDescription() == null) {
                channel.setDescription("");
            }
            return channel;
        }
        catch (SortException se) {
            log.error((Object)"caught exception: ", (Throwable)se);
            throw new IOException(se.getMessage());
        }
        catch (BrowseException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    private Item itemFromDSpaceItem(Context context, org.dspace.content.Item dspaceItem) throws SQLException {
        String dateField;
        Item rssItem = new Item();
        String titleField = ConfigurationManager.getProperty((String)"webui.feed.item.title");
        if (titleField == null) {
            titleField = "dc.title";
        }
        if ((dateField = ConfigurationManager.getProperty((String)"webui.feed.item.date")) == null) {
            dateField = "dc.date.issued";
        }
        String itHandle = ConfigurationManager.getBooleanProperty((String)"webui.feed.localresolve") ? HandleManager.resolveToURL((Context)context, (String)dspaceItem.getHandle()) : HandleManager.getCanonicalForm((String)dspaceItem.getHandle());
        rssItem.setLink(itHandle);
        String title = null;
        try {
            title = dspaceItem.getMetadata((String)titleField)[0].value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            title = labels.getString(this.clazz + ".notitle");
        }
        rssItem.setTitle(title);
        String descriptionFields = ConfigurationManager.getProperty((String)"webui.feed.item.description");
        if (descriptionFields == null) {
            descriptionFields = defaultDescriptionFields;
        }
        StringBuffer descBuf = new StringBuffer();
        StringTokenizer st = new StringTokenizer(descriptionFields, ",");
        while (st.hasMoreTokens()) {
            DCValue[] values;
            String field = st.nextToken().trim();
            boolean isDate = false;
            if (field.indexOf("(date)") > 0) {
                field = field.replaceAll("\\(date\\)", "");
                isDate = true;
            }
            if ((values = dspaceItem.getMetadata(field)) == null || values.length <= 0) continue;
            if (descBuf.length() > 0) {
                descBuf.append("\n<br/>");
                descBuf.append("\n<br/>");
            }
            String fieldLabel = null;
            try {
                fieldLabel = labels.getString("metadata." + field);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (fieldLabel != null && fieldLabel.length() > 0) {
                descBuf.append(fieldLabel + ": ");
            }
            for (int i = 0; i < values.length; ++i) {
                String fieldValue = values[i].value;
                if (isDate) {
                    fieldValue = new DCDate(fieldValue).toString();
                }
                descBuf.append(fieldValue);
                if (i >= values.length - 1) continue;
                descBuf.append("; ");
            }
        }
        Description descrip = new Description();
        descrip.setValue(descBuf.toString().replaceAll("\\p{Cntrl}", ""));
        rssItem.setDescription(descrip);
        String dcDate = null;
        try {
            dcDate = dspaceItem.getMetadata((String)dateField)[0].value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (dcDate != null) {
            rssItem.setPubDate(new DCDate(dcDate).toDate());
        }
        return rssItem;
    }

    private static void cache(String feedKey, CacheFeed newFeed) {
        if (feedCache.size() >= cacheSize) {
            int total = 0;
            String minKey = null;
            CacheFeed minFeed = null;
            CacheFeed maxFeed = null;
            for (String key : feedCache.keySet()) {
                CacheFeed feed = (CacheFeed)feedCache.get(key);
                if (minKey != null) {
                    if (feed.hits < minFeed.hits) {
                        minKey = key;
                        minFeed = feed;
                    }
                    if (feed.hits >= maxFeed.hits) {
                        maxFeed = feed;
                    }
                } else {
                    minKey = key;
                    minFeed = maxFeed = feed;
                }
                total += feed.hits;
            }
            int avg = total / feedCache.size();
            String logMsg = "feedCache() - size: " + feedCache.size() + " Hits - total: " + total + " avg: " + avg + " max: " + maxFeed.hits + " min: " + minFeed.hits;
            log.info((Object)logMsg);
            feedCache.remove(minKey);
        }
        feedCache.put(feedKey, newFeed);
    }

    static {
        enabled = ConfigurationManager.getBooleanProperty((String)"webui.feed.enable");
    }

    private class CacheFeed {
        public long timeStamp = 0L;
        public int hits = 0;
        private Channel feed = null;

        public CacheFeed(Channel feed) {
            this.feed = feed;
            this.timeStamp = System.currentTimeMillis();
        }

        public Channel access() {
            ++this.hits;
            return this.feed;
        }
    }
}

