/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPersonDeletionException;
import org.dspace.eperson.Group;

public class EPersonAdminServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(EPersonAdminServlet.class);

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.showMain(context, request, response);
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        if (button.equals("submit_add")) {
            EPerson e = EPerson.create((Context)context);
            e.setEmail("newuser" + e.getID());
            e.update();
            request.setAttribute("eperson", (Object)e);
            JSPManager.showJSP(request, response, "/dspace-admin/eperson-edit.jsp");
            context.complete();
        } else if (button.equals("submit_edit")) {
            EPerson e = EPerson.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"eperson_id"));
            if (e == null) {
                request.setAttribute("no_eperson_selected", (Object)new Boolean(true));
                this.showMain(context, request, response);
            } else {
                Group[] groupMemberships = Group.allMemberGroups((Context)context, (EPerson)e);
                request.setAttribute("eperson", (Object)e);
                request.setAttribute("group.memberships", (Object)groupMemberships);
                JSPManager.showJSP(request, response, "/dspace-admin/eperson-edit.jsp");
                context.complete();
            }
        } else if (button.equals("submit_save")) {
            EPerson e = EPerson.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"eperson_id"));
            String oldEmail = e.getEmail();
            String newEmail = request.getParameter("email").trim();
            String netid = request.getParameter("netid");
            if (!newEmail.equals(oldEmail)) {
                if (EPerson.findByEmail((Context)context, (String)newEmail) == null) {
                    e.setEmail(newEmail);
                    e.setFirstName(request.getParameter("firstname").equals("") ? null : request.getParameter("firstname"));
                    e.setLastName(request.getParameter("lastname").equals("") ? null : request.getParameter("lastname"));
                    if (netid != null) {
                        e.setNetid(netid.equals("") ? null : netid);
                    } else {
                        e.setNetid(null);
                    }
                    e.setMetadata("phone", request.getParameter("phone").equals("") ? null : request.getParameter("phone"));
                    e.setMetadata("language", request.getParameter("language").equals("") ? null : request.getParameter("language"));
                    e.setCanLogIn(request.getParameter("can_log_in") != null && request.getParameter("can_log_in").equals("true"));
                    e.setRequireCertificate(request.getParameter("require_certificate") != null && request.getParameter("require_certificate").equals("true"));
                    e.update();
                    this.showMain(context, request, response);
                    context.complete();
                } else {
                    request.setAttribute("eperson", (Object)e);
                    request.setAttribute("email_exists", (Object)new Boolean(true));
                    JSPManager.showJSP(request, response, "/dspace-admin/eperson-edit.jsp");
                    context.complete();
                }
            } else {
                if (netid != null) {
                    e.setNetid(netid.equals("") ? null : netid);
                } else {
                    e.setNetid(null);
                }
                e.setFirstName(request.getParameter("firstname").equals("") ? null : request.getParameter("firstname"));
                e.setLastName(request.getParameter("lastname").equals("") ? null : request.getParameter("lastname"));
                e.setMetadata("phone", request.getParameter("phone").equals("") ? null : request.getParameter("phone"));
                e.setMetadata("language", request.getParameter("language").equals("") ? null : request.getParameter("language"));
                e.setCanLogIn(request.getParameter("can_log_in") != null && request.getParameter("can_log_in").equals("true"));
                e.setRequireCertificate(request.getParameter("require_certificate") != null && request.getParameter("require_certificate").equals("true"));
                e.update();
                this.showMain(context, request, response);
                context.complete();
            }
        } else if (button.equals("submit_delete")) {
            EPerson e = EPerson.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"eperson_id"));
            if (e == null) {
                request.setAttribute("no_eperson_selected", (Object)new Boolean(true));
                this.showMain(context, request, response);
            } else {
                request.setAttribute("eperson", (Object)e);
                JSPManager.showJSP(request, response, "/dspace-admin/eperson-confirm-delete.jsp");
            }
        } else if (button.equals("submit_confirm_delete")) {
            EPerson e = EPerson.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"eperson_id"));
            try {
                e.delete();
            }
            catch (EPersonDeletionException ex) {
                request.setAttribute("eperson", (Object)e);
                request.setAttribute("tableList", (Object)ex.getTables());
                JSPManager.showJSP(request, response, "/dspace-admin/eperson-deletion-error.jsp");
            }
            this.showMain(context, request, response);
            context.complete();
        } else {
            this.showMain(context, request, response);
        }
    }

    private void showMain(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        JSPManager.showJSP(request, response, "/dspace-admin/eperson-main.jsp");
    }
}

