/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.FileUploadRequest;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class EditCommunitiesServlet
extends DSpaceServlet {
    public static final int START_EDIT_COMMUNITY = 1;
    public static final int START_DELETE_COMMUNITY = 2;
    public static final int START_CREATE_COMMUNITY = 3;
    public static final int START_EDIT_COLLECTION = 4;
    public static final int START_DELETE_COLLECTION = 5;
    public static final int START_CREATE_COLLECTION = 6;
    public static final int CONFIRM_EDIT_COMMUNITY = 7;
    public static final int CONFIRM_DELETE_COMMUNITY = 8;
    public static final int CONFIRM_EDIT_COLLECTION = 9;
    public static final int CONFIRM_DELETE_COLLECTION = 10;
    private static Logger log = Logger.getLogger(EditCommunitiesServlet.class);

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.showControls(context, request, response);
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String contentType = request.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            this.processUploadLogo(context, request, response);
            return;
        }
        int action = UIUtil.getIntParameter((HttpServletRequest)request, (String)"action");
        Community community = Community.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"community_id"));
        Community parentCommunity = Community.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"parent_community_id"));
        Collection collection = Collection.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection_id"));
        request.setAttribute("community", (Object)community);
        request.setAttribute("parent", (Object)parentCommunity);
        request.setAttribute("collection", (Object)collection);
        if (request.getParameter("submit_cancel") != null) {
            this.showControls(context, request, response);
            return;
        }
        if (AuthorizeManager.isAdmin((Context)context)) {
            request.setAttribute("admin_button", (Object)new Boolean(true));
        }
        switch (action) {
            case 1: {
                JSPManager.showJSP(request, response, "/tools/edit-community.jsp");
                break;
            }
            case 2: {
                JSPManager.showJSP(request, response, "/tools/confirm-delete-community.jsp");
                break;
            }
            case 3: {
                JSPManager.showJSP(request, response, "/tools/edit-community.jsp");
                break;
            }
            case 4: {
                JSPManager.showJSP(request, response, "/tools/edit-collection.jsp");
                break;
            }
            case 5: {
                JSPManager.showJSP(request, response, "/tools/confirm-delete-collection.jsp");
                break;
            }
            case 6: {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/collection-wizard?community_id=" + community.getID()));
                break;
            }
            case 7: {
                this.processConfirmEditCommunity(context, request, response, community);
                break;
            }
            case 8: {
                Community parent = community.getParentCommunity();
                community.delete();
                if (parent == null) {
                    response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/community-list"));
                } else {
                    response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/handle/" + parent.getHandle()));
                }
                context.complete();
                break;
            }
            case 9: {
                this.processConfirmEditCollection(context, request, response, community, collection);
                break;
            }
            case 10: {
                community.removeCollection(collection);
                this.showControls(context, request, response);
                context.complete();
                break;
            }
            default: {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
                JSPManager.showIntegrityError(request, response);
            }
        }
    }

    private void showControls(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        Community community = (Community)request.getAttribute("community");
        if (community != null) {
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/handle/" + community.getHandle()));
        } else {
            Community parent = (Community)request.getAttribute("parent");
            if (parent != null) {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/handle/" + parent.getHandle()));
            } else {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/community-list"));
            }
        }
    }

    private void processConfirmEditCommunity(Context context, HttpServletRequest request, HttpServletResponse response, Community community) throws ServletException, IOException, SQLException, AuthorizeException {
        String side;
        String copy;
        if (request.getParameter("create").equals("true")) {
            int parentCommunityID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"parent_community_id");
            if (parentCommunityID != -1) {
                Community parent = Community.find((Context)context, (int)parentCommunityID);
                if (parent != null) {
                    community = parent.createSubcommunity();
                }
            } else {
                community = Community.create(null, (Context)context);
            }
            request.setAttribute("community", (Object)community);
        }
        community.setMetadata("name", request.getParameter("name"));
        community.setMetadata("short_description", request.getParameter("short_description"));
        String intro = request.getParameter("introductory_text");
        if (intro.equals("")) {
            intro = null;
        }
        if ((copy = request.getParameter("copyright_text")).equals("")) {
            copy = null;
        }
        if ((side = request.getParameter("side_bar_text")).equals("")) {
            side = null;
        }
        community.setMetadata("introductory_text", intro);
        community.setMetadata("copyright_text", copy);
        community.setMetadata("side_bar_text", side);
        community.update();
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        if (button.equals("submit_set_logo")) {
            community.setLogo(null);
            community.update();
            JSPManager.showJSP(request, response, "/dspace-admin/upload-logo.jsp");
        } else if (button.equals("submit_delete_logo")) {
            community.setLogo(null);
            community.update();
            JSPManager.showJSP(request, response, "/tools/edit-community.jsp");
        } else if (button.equals("submit_authorization_edit")) {
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/dspace-admin/authorize?community_id=" + community.getID() + "&submit_community_select=1"));
        } else {
            this.showControls(context, request, response);
        }
        context.complete();
    }

    private void processConfirmEditCollection(Context context, HttpServletRequest request, HttpServletResponse response, Community community, Collection collection) throws ServletException, IOException, SQLException, AuthorizeException {
        String provenance;
        String license;
        String side;
        String copy;
        if (request.getParameter("create").equals("true")) {
            collection = community.createCollection();
            request.setAttribute("collection", (Object)collection);
        }
        collection.setMetadata("name", request.getParameter("name"));
        collection.setMetadata("short_description", request.getParameter("short_description"));
        String intro = request.getParameter("introductory_text");
        if (intro.equals("")) {
            intro = null;
        }
        if ((copy = request.getParameter("copyright_text")).equals("")) {
            copy = null;
        }
        if ((side = request.getParameter("side_bar_text")).equals("")) {
            side = null;
        }
        if ((license = request.getParameter("license")).equals("")) {
            license = null;
        }
        if ((provenance = request.getParameter("provenance_description")).equals("")) {
            provenance = null;
        }
        collection.setMetadata("introductory_text", intro);
        collection.setMetadata("copyright_text", copy);
        collection.setMetadata("side_bar_text", side);
        collection.setMetadata("license", license);
        collection.setMetadata("provenance_description", provenance);
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        if (button.equals("submit_set_logo")) {
            collection.setLogo(null);
            JSPManager.showJSP(request, response, "/dspace-admin/upload-logo.jsp");
        } else if (button.equals("submit_delete_logo")) {
            collection.setLogo(null);
            JSPManager.showJSP(request, response, "/tools/edit-collection.jsp");
        } else if (button.startsWith("submit_wf_create_")) {
            int step = Integer.parseInt(button.substring(17));
            Group newGroup = collection.createWorkflowGroup(step);
            collection.update();
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/group-edit?group_id=" + newGroup.getID()));
        } else if (button.equals("submit_admins_create")) {
            Group newGroup = collection.createAdministrators();
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/group-edit?group_id=" + newGroup.getID()));
        } else if (button.equals("submit_admins_delete")) {
            Group g = collection.getAdministrators();
            collection.removeAdministrators();
            collection.update();
            g.delete();
            JSPManager.showJSP(request, response, "/tools/edit-collection.jsp");
        } else if (button.equals("submit_submitters_create")) {
            Group newGroup = collection.createSubmitters();
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/group-edit?group_id=" + newGroup.getID()));
        } else if (button.equals("submit_submitters_delete")) {
            Group g = collection.getSubmitters();
            collection.removeSubmitters();
            collection.update();
            g.delete();
            JSPManager.showJSP(request, response, "/tools/edit-collection.jsp");
        } else if (button.equals("submit_authorization_edit")) {
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/dspace-admin/authorize?collection_id=" + collection.getID() + "&submit_collection_select=1"));
        } else if (button.startsWith("submit_wf_edit_")) {
            int step = Integer.parseInt(button.substring(15));
            Group g = collection.getWorkflowGroup(step);
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/group-edit?group_id=" + g.getID()));
        } else if (button.equals("submit_submitters_edit")) {
            Group g = collection.getSubmitters();
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/group-edit?group_id=" + g.getID()));
        } else if (button.equals("submit_admins_edit")) {
            Group g = collection.getAdministrators();
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/group-edit?group_id=" + g.getID()));
        } else if (button.startsWith("submit_wf_delete_")) {
            int step = Integer.parseInt(button.substring(17));
            Group g = collection.getWorkflowGroup(step);
            collection.setWorkflowGroup(step, null);
            collection.update();
            g.delete();
            JSPManager.showJSP(request, response, "/tools/edit-collection.jsp");
        } else {
            if (button.equals("submit_create_template")) {
                collection.createTemplateItem();
                Item i = collection.getTemplateItem();
                i.setOwningCollection(collection);
                i.update();
                collection.update();
                context.complete();
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/edit-item?item_id=" + i.getID()));
                return;
            }
            if (button.equals("submit_edit_template")) {
                Item i = collection.getTemplateItem();
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/tools/edit-item?item_id=" + i.getID()));
            } else if (button.equals("submit_delete_template")) {
                collection.removeTemplateItem();
                JSPManager.showJSP(request, response, "/tools/edit-collection.jsp");
            } else {
                this.showControls(context, request, response);
            }
        }
        collection.update();
        context.complete();
    }

    private void processUploadLogo(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        FileUploadRequest wrapper = new FileUploadRequest(request);
        Community community = Community.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)wrapper, (String)"community_id"));
        Collection collection = Collection.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)wrapper, (String)"collection_id"));
        File temp = wrapper.getFile("file");
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(temp));
        Bitstream logoBS = collection == null ? community.setLogo((InputStream)is) : collection.setLogo((InputStream)is);
        String noPath = wrapper.getFilesystemName("file");
        while (noPath.indexOf(47) > -1) {
            noPath = noPath.substring(noPath.indexOf(47) + 1);
        }
        while (noPath.indexOf(92) > -1) {
            noPath = noPath.substring(noPath.indexOf(92) + 1);
        }
        logoBS.setName(noPath);
        logoBS.setSource(wrapper.getFilesystemName("file"));
        BitstreamFormat bf = FormatIdentifier.guessFormat((Context)context, (Bitstream)logoBS);
        logoBS.setFormat(bf);
        AuthorizeManager.addPolicy((Context)context, (DSpaceObject)logoBS, (int)1, (EPerson)context.getCurrentUser());
        logoBS.update();
        if (AuthorizeManager.isAdmin((Context)context)) {
            request.setAttribute("admin_button", (Object)new Boolean(true));
        }
        if (collection == null) {
            community.update();
            request.setAttribute("community", (Object)community);
            JSPManager.showJSP(request, response, "/tools/edit-community.jsp");
        } else {
            collection.update();
            request.setAttribute("collection", (Object)collection);
            request.setAttribute("community", (Object)community);
            JSPManager.showJSP(request, response, "/tools/edit-collection.jsp");
        }
        temp.delete();
        context.complete();
    }
}

