/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.core.Context;

public class MetadataSchemaRegistryServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(MetadataSchemaRegistryServlet.class);
    private String clazz = "org.dspace.app.webui.servlet.admin.MetadataSchemaRegistryServlet";

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.showSchemas(context, request, response);
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        if (button.equals("submit_add")) {
            String id = request.getParameter("dc_schema_id");
            if (!this.sanityCheck(request)) {
                this.showSchemas(context, request, response);
                context.abort();
                return;
            }
            try {
                if (id.equals("")) {
                    MetadataSchema schema = new MetadataSchema();
                    schema.setNamespace(request.getParameter("namespace"));
                    schema.setName(request.getParameter("short_name"));
                    schema.create(context);
                    this.showSchemas(context, request, response);
                    context.complete();
                }
                MetadataSchema schema = MetadataSchema.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"dc_schema_id"));
                schema.setNamespace(request.getParameter("namespace"));
                schema.setName(request.getParameter("short_name"));
                schema.update(context);
                this.showSchemas(context, request, response);
                context.complete();
            }
            catch (NonUniqueMetadataException e) {
                request.setAttribute("error", (Object)"Please make the namespace and short name unique.");
                this.showSchemas(context, request, response);
                context.abort();
                return;
            }
        } else if (button.equals("submit_delete")) {
            MetadataSchema schema = MetadataSchema.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"dc_schema_id"));
            request.setAttribute("schema", (Object)schema);
            JSPManager.showJSP(request, response, "/dspace-admin/confirm-delete-mdschema.jsp");
        } else if (button.equals("submit_confirm_delete")) {
            MetadataSchema dc = MetadataSchema.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"dc_schema_id"));
            dc.delete(context);
            this.showSchemas(context, request, response);
            context.complete();
        } else {
            this.showSchemas(context, request, response);
        }
    }

    private boolean sanityCheck(HttpServletRequest request) {
        Locale locale = request.getLocale();
        ResourceBundle labels = ResourceBundle.getBundle("Messages", locale);
        String namespace = request.getParameter("namespace");
        if (namespace.length() == 0) {
            return this.error(request, labels.getString(this.clazz + ".emptynamespace"));
        }
        String name = request.getParameter("short_name");
        if (name.length() == 0) {
            return this.error(request, labels.getString(this.clazz + ".emptyname"));
        }
        if (name.length() > 32) {
            return this.error(request, labels.getString(this.clazz + ".nametolong"));
        }
        for (int ii = 0; ii < name.length(); ++ii) {
            if (name.charAt(ii) != ' ' && name.charAt(ii) != '_' && name.charAt(ii) != '.') continue;
            return this.error(request, labels.getString(this.clazz + ".illegalchar"));
        }
        return true;
    }

    private boolean error(HttpServletRequest request, String text) {
        request.setAttribute("error", (Object)text);
        return false;
    }

    private void showSchemas(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, SQLException, IOException {
        MetadataSchema[] schemas = MetadataSchema.findAll((Context)context);
        request.setAttribute("schemas", (Object)schemas);
        log.info((Object)"Showing Schemas");
        JSPManager.showJSP(request, response, "/dspace-admin/list-metadata-schemas.jsp");
    }
}

