/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.dspace.core.ConfigurationManager;

public class FileUploadRequest
extends HttpServletRequestWrapper {
    private List items = null;
    private HashMap parameters = new HashMap();
    private HashMap fileitems = new HashMap();
    private Vector filenames = new Vector();
    private String tempDir = null;
    private HttpServletRequest original = null;

    public FileUploadRequest(HttpServletRequest req) throws IOException {
        super(req);
        this.original = req;
        this.tempDir = ConfigurationManager.getProperty((String)"upload.temp.dir");
        int maxSize = ConfigurationManager.getIntProperty((String)"upload.max");
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setRepository(new File(this.tempDir));
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            upload.setSizeMax((long)maxSize);
            this.items = upload.parseRequest(req);
            for (FileItem item : this.items) {
                if (item.isFormField()) {
                    this.parameters.put(item.getFieldName(), item.getString("UTF-8"));
                    continue;
                }
                this.parameters.put(item.getFieldName(), item.getName());
                this.fileitems.put(item.getFieldName(), item);
                this.filenames.add(item.getName());
                String filename = this.getFilename(item.getName());
                if (filename == null || "".equals(filename)) continue;
                item.write(new File(this.tempDir + File.separator + filename));
            }
        }
        catch (Exception e) {
            IOException t = new IOException(e.getMessage());
            t.initCause(e);
            throw t;
        }
    }

    public Enumeration getParameterNames() {
        Set c = this.parameters.keySet();
        return Collections.enumeration(c);
    }

    public String getParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.values().toArray();
    }

    public Map getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration eNum = this.getParameterNames();
        while (eNum.hasMoreElements()) {
            String name = (String)eNum.nextElement();
            map.put(name, this.getParameterValues(name));
        }
        return map;
    }

    public String getFilesystemName(String name) {
        String filename = this.getFilename(((FileItem)this.fileitems.get(name)).getName());
        return this.tempDir + File.separator + filename;
    }

    public String getContentType(String name) {
        return ((FileItem)this.fileitems.get(name)).getContentType();
    }

    public File getFile(String name) {
        FileItem temp = (FileItem)this.fileitems.get(name);
        String tempName = temp.getName();
        String filename = this.getFilename(tempName);
        if ("".equals(filename.trim())) {
            return null;
        }
        return new File(this.tempDir + File.separator + filename);
    }

    public Enumeration getFileParameterNames() {
        Set c = this.fileitems.keySet();
        return Collections.enumeration(c);
    }

    public Enumeration getFileNames() {
        return this.filenames.elements();
    }

    public HttpServletRequest getOriginalRequest() {
        return this.original;
    }

    private String getFilename(String filepath) {
        String filename = filepath.trim();
        int index = filepath.lastIndexOf(File.separator);
        if (index > -1) {
            filename = filepath.substring(index);
        }
        return filename;
    }
}

