/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.io.IOException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.StyleSelection;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.browse.BrowseException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.I18nUtil;
import org.dspace.core.PluginManager;
import org.dspace.core.Utils;

public class ItemTag
extends TagSupport {
    private Item item;
    private Collection[] collections;
    private String style;
    private boolean showThumbs;
    private static String defaultFields = "dc.title, dc.title.alternative, dc.contributor.*, dc.subject, dc.date.issued(date), dc.publisher, dc.identifier.citation, dc.relation.ispartofseries, dc.description.abstract, dc.description, dc.identifier.govdoc, dc.identifier.uri(link), dc.identifier.isbn, dc.identifier.issn, dc.identifier.ismn, dc.identifier";
    private static Logger log = Logger.getLogger(ItemTag.class);
    private StyleSelection styleSelection = (StyleSelection)PluginManager.getSinglePlugin(StyleSelection.class);
    private Map<String, String> linkedMetadata;

    public ItemTag() {
        String linkMetadata;
        this.getThumbSettings();
        this.linkedMetadata = new HashMap<String, String>();
        int i = 1;
        while (null != (linkMetadata = ConfigurationManager.getProperty((String)("webui.browse.link." + i)))) {
            String[] linkedMetadataSplit = linkMetadata.split(":");
            String indexName = linkedMetadataSplit[0].trim();
            String metadataName = linkedMetadataSplit[1].trim();
            this.linkedMetadata.put(indexName, metadataName);
            ++i;
        }
    }

    public int doStartTag() throws JspException {
        try {
            if (this.style == null || this.style.equals("")) {
                this.style = this.styleSelection.getStyleForItem(this.item);
            }
            if (this.style.equals("full")) {
                this.renderFull();
            } else {
                this.render();
            }
        }
        catch (SQLException sqle) {
            throw new JspException((Throwable)sqle);
        }
        catch (IOException ie) {
            throw new JspException((Throwable)ie);
        }
        return 0;
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item itemIn) {
        this.item = itemIn;
    }

    public Collection[] getCollections() {
        return this.collections;
    }

    public void setCollections(Collection[] collectionsIn) {
        this.collections = collectionsIn;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String styleIn) {
        this.style = styleIn;
    }

    public void release() {
        this.style = "default";
        this.item = null;
        this.collections = null;
    }

    private void render() throws IOException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String configLine = this.styleSelection.getConfigurationForStyle(this.style);
        if (configLine == null) {
            configLine = defaultFields;
        }
        out.println("<center><table class=\"itemDisplayTable\">");
        StringTokenizer st = new StringTokenizer(configLine, ",");
        while (st.hasMoreTokens()) {
            DCValue[] values;
            String browseIndex;
            String field = st.nextToken().trim();
            boolean isDate = false;
            boolean isLink = false;
            try {
                browseIndex = this.getBrowseField(field);
            }
            catch (BrowseException e) {
                log.error((Object)e);
                browseIndex = null;
            }
            if (field.indexOf("(date)") > 0) {
                field = field.replaceAll("\\(date\\)", "");
                isDate = true;
            }
            if (field.indexOf("(link)") > 0) {
                field = field.replaceAll("\\(link\\)", "");
                isLink = true;
            }
            String[] eq = field.split("\\.");
            String schema = eq[0];
            String element = eq[1];
            String qualifier = null;
            if (eq.length > 2 && eq[2].equals("*")) {
                qualifier = "*";
            } else if (eq.length > 2) {
                qualifier = eq[2];
            }
            if ((values = this.item.getMetadata(schema, element, qualifier, "*")).length <= 0) continue;
            out.print("<tr><td class=\"metadataFieldLabel\">");
            String label = null;
            try {
                label = I18nUtil.getMessage((String)("metadata." + (this.style != null ? this.style + "." : "") + field), (Locale)this.pageContext.getRequest().getLocale());
            }
            catch (MissingResourceException e) {
                label = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)("metadata." + field));
            }
            out.print(label);
            out.print(":&nbsp;</td><td class=\"metadataFieldValue\">");
            for (int j = 0; j < values.length; ++j) {
                if (j > 0) {
                    out.print("<br />");
                }
                if (isLink) {
                    out.print("<a href=\"" + values[j].value + "\">" + Utils.addEntities((String)values[j].value) + "</a>");
                    continue;
                }
                if (isDate) {
                    DCDate dd = new DCDate(values[j].value);
                    out.print(UIUtil.displayDate(dd, false, false, (HttpServletRequest)this.pageContext.getRequest()));
                    continue;
                }
                if (browseIndex != null) {
                    out.print("<a href=\"" + request.getContextPath() + "/browse?type=" + browseIndex + "&value=" + URLEncoder.encode(values[j].value, "UTF-8") + "\">" + Utils.addEntities((String)values[j].value) + "</a>");
                    continue;
                }
                out.print(Utils.addEntities((String)values[j].value));
            }
            out.println("</td></tr>");
        }
        this.listCollections();
        out.println("</table></center><br/>");
        this.listBitstreams();
        if (ConfigurationManager.getBooleanProperty((String)"webui.licence_bundle.show")) {
            out.println("<br/><br/>");
            this.showLicence();
        }
    }

    private void renderFull() throws IOException {
        JspWriter out = this.pageContext.getOut();
        DCValue[] values = this.item.getMetadata("*", "*", "*", "*");
        out.println("<p align=\"center\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.full") + "</p>");
        out.println("<center><table class=\"itemDisplayTable\">");
        out.println("<tr><th id=\"s1\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.dcfield") + "</th><th id=\"s2\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.value") + "</th><th id=\"s3\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.lang") + "</th></tr>");
        for (int i = 0; i < values.length; ++i) {
            boolean hidden = false;
            if (values[i].element.equals("description") && values[i].qualifier != null && values[i].qualifier.equals("provenance")) {
                hidden = true;
            }
            if (hidden) continue;
            out.print("<tr><td headers=\"s1\" class=\"metadataFieldLabel\">");
            out.print(values[i].schema);
            out.print("." + values[i].element);
            if (values[i].qualifier != null) {
                out.print("." + values[i].qualifier);
            }
            out.print("</td><td headers=\"s2\" class=\"metadataFieldValue\">");
            out.print(Utils.addEntities((String)values[i].value));
            out.print("</td><td headers=\"s3\" class=\"metadataFieldValue\">");
            if (values[i].language == null) {
                out.print("-");
            } else {
                out.print(values[i].language);
            }
            out.println("</td></tr>");
        }
        this.listCollections();
        out.println("</table></center><br/>");
        this.listBitstreams();
        if (ConfigurationManager.getBooleanProperty((String)"webui.licence_bundle.show")) {
            out.println("<br/><br/>");
            this.showLicence();
        }
    }

    private void listCollections() throws IOException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (this.collections != null) {
            out.print("<tr><td class=\"metadataFieldLabel\">");
            if (this.item.getHandle() == null) {
                out.print(LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.submitted"));
            } else {
                out.print(LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.appears"));
            }
            out.print("</td><td class=\"metadataFieldValue\">");
            for (int i = 0; i < this.collections.length; ++i) {
                out.print("<a href=\"");
                out.print(request.getContextPath());
                out.print("/handle/");
                out.print(this.collections[i].getHandle());
                out.print("\">");
                out.print(this.collections[i].getMetadata("name"));
                out.print("</a><br/>");
            }
            out.println("</td></tr>");
        }
    }

    private void listBitstreams() throws IOException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        out.print("<table align=\"center\" class=\"miscTable\"><tr>");
        out.println("<td class=\"evenRowEvenCol\"><p><strong>" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.files") + "</strong></p>");
        try {
            Bundle[] bundles = this.item.getBundles("ORIGINAL");
            if (bundles.length == 0) {
                out.println("<p>" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.files.no") + "</p>");
            } else {
                int i;
                boolean html = false;
                String handle = this.item.getHandle();
                Bitstream primaryBitstream = null;
                Bundle[] bunds = this.item.getBundles("ORIGINAL");
                Bundle[] thumbs = this.item.getBundles("THUMBNAIL");
                boolean multiFile = false;
                Bundle[] allBundles = this.item.getBundles();
                int filecount = 0;
                for (i = 0; i < allBundles.length && !multiFile; ++i) {
                    multiFile = (filecount += allBundles[i].getBitstreams().length) > 1;
                }
                if (bunds[0] != null) {
                    Bitstream[] bits = bunds[0].getBitstreams();
                    for (int i2 = 0; i2 < bits.length && !html; ++i2) {
                        if (bits[i2].getID() != bunds[0].getPrimaryBitstreamID()) continue;
                        html = bits[i2].getFormat().getMIMEType().equals("text/html");
                        primaryBitstream = bits[i2];
                    }
                }
                out.println("<table cellpadding=\"6\"><tr><th id=\"t1\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.file") + "</th>");
                if (multiFile) {
                    out.println("<th id=\"t2\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.description") + "</th>");
                }
                out.println("<th id=\"t3\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.filesize") + "</th><th id=\"t4\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.fileformat") + "</th></tr>");
                if (html) {
                    if (handle == null) {
                        handle = "db-id/" + this.item.getID();
                    }
                    out.print("<tr><td headers=\"t1\" class=\"standard\">");
                    out.print("<a target=\"_blank\" href=\"");
                    out.print(request.getContextPath());
                    out.print("/html/");
                    out.print(handle + "/");
                    out.print(UIUtil.encodeBitstreamName((String)primaryBitstream.getName(), (String)"UTF-8"));
                    out.print("\">");
                    out.print(primaryBitstream.getName());
                    out.print("</a>");
                    if (multiFile) {
                        out.print("</td><td headers=\"t2\" class=\"standard\">");
                        String desc = primaryBitstream.getDescription();
                        out.print(desc != null ? desc : "");
                    }
                    out.print("</td><td headers=\"t3\" class=\"standard\">");
                    out.print(UIUtil.formatFileSize((double)primaryBitstream.getSize()));
                    out.print("</td><td headers=\"t4\" class=\"standard\">");
                    out.print(primaryBitstream.getFormatDescription());
                    out.print("</td><td class=\"standard\"><a target=\"_blank\" href=\"");
                    out.print(request.getContextPath());
                    out.print("/html/");
                    out.print(handle + "/");
                    out.print(UIUtil.encodeBitstreamName((String)primaryBitstream.getName(), (String)"UTF-8"));
                    out.print("\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.view") + "</a></td></tr>");
                } else {
                    for (i = 0; i < bundles.length; ++i) {
                        Bitstream[] bitstreams = bundles[i].getBitstreams();
                        for (int k = 0; k < bitstreams.length; ++k) {
                            if (bitstreams[k].getFormat().isInternal()) continue;
                            String bsLink = "<a target=\"_blank\" href=\"" + request.getContextPath();
                            bsLink = handle != null && bitstreams[k].getSequenceID() > 0 ? bsLink + "/bitstream/" + this.item.getHandle() + "/" + bitstreams[k].getSequenceID() + "/" : bsLink + "/retrieve/" + bitstreams[k].getID() + "/";
                            bsLink = bsLink + UIUtil.encodeBitstreamName((String)bitstreams[k].getName(), (String)"UTF-8") + "\">";
                            out.print("<tr><td headers=\"t1\" class=\"standard\">");
                            out.print(bsLink);
                            out.print(bitstreams[k].getName());
                            out.print("</a>");
                            if (multiFile) {
                                out.print("</td><td headers=\"t2\" class=\"standard\">");
                                String desc = bitstreams[k].getDescription();
                                out.print(desc != null ? desc : "");
                            }
                            out.print("</td><td headers=\"t3\" class=\"standard\">");
                            out.print(UIUtil.formatFileSize((double)bitstreams[k].getSize()));
                            out.print("</td><td headers=\"t4\" class=\"standard\">");
                            out.print(bitstreams[k].getFormatDescription());
                            out.print("</td><td class=\"standard\" align=\"center\">");
                            if (thumbs.length > 0 && this.showThumbs) {
                                String tName = bitstreams[k].getName() + ".jpg";
                                String tAltText = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.thumbnail");
                                Bitstream tb = thumbs[0].getBitstreamByName(tName);
                                if (tb != null) {
                                    String myPath = request.getContextPath() + "/retrieve/" + tb.getID() + "/" + UIUtil.encodeBitstreamName((String)tb.getName(), (String)"UTF-8");
                                    out.print(bsLink);
                                    out.print("<img src=\"" + myPath + "\" ");
                                    out.print("alt=\"" + tAltText + "\" /></a><br />");
                                }
                            }
                            out.print(bsLink + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.view") + "</a></td></tr>");
                        }
                    }
                }
                out.println("</table>");
            }
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
        out.println("</td></tr></table>");
    }

    private void getThumbSettings() {
        this.showThumbs = ConfigurationManager.getBooleanProperty((String)"webui.item.thumbnail.show");
    }

    private void showLicence() throws IOException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Bundle[] bundles = null;
        try {
            bundles = this.item.getBundles("LICENSE");
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
        out.println("<table align=\"center\" class=\"attentionTable\"><tr>");
        out.println("<td class=\"attentionCell\"><p><strong>" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.itemprotected") + "</strong></p>");
        for (int i = 0; i < bundles.length; ++i) {
            Bitstream[] bitstreams = bundles[i].getBitstreams();
            for (int k = 0; k < bitstreams.length; ++k) {
                out.print("<div align=\"center\" class=\"standard\">");
                out.print("<strong><a target=\"_blank\" href=\"");
                out.print(request.getContextPath());
                out.print("/retrieve/");
                out.print(bitstreams[k].getID() + "/");
                out.print(UIUtil.encodeBitstreamName((String)bitstreams[k].getName(), (String)"UTF-8"));
                out.print("\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.viewlicence") + "</a></strong></div>");
            }
        }
        out.println("</td></tr></table>");
    }

    private String getBrowseField(String field) throws BrowseException {
        for (String indexName : this.linkedMetadata.keySet()) {
            StringTokenizer bw_dcf = new StringTokenizer(this.linkedMetadata.get(indexName), ".");
            String[] bw_tokens = new String[]{"", "", ""};
            int i = 0;
            while (bw_dcf.hasMoreTokens()) {
                bw_tokens[i] = bw_dcf.nextToken().toLowerCase().trim();
                ++i;
            }
            String bw_schema = bw_tokens[0];
            String bw_element = bw_tokens[1];
            String bw_qualifier = bw_tokens[2];
            StringTokenizer dcf = new StringTokenizer(field, ".");
            String[] tokens = new String[]{"", "", ""};
            int j = 0;
            while (dcf.hasMoreTokens()) {
                tokens[j] = dcf.nextToken().toLowerCase().trim();
                ++j;
            }
            String schema = tokens[0];
            String element = tokens[1];
            String qualifier = tokens[2];
            if (!schema.equals(bw_schema) || !element.equals(bw_element) || (bw_qualifier == null || (qualifier == null || !qualifier.equals(bw_qualifier)) && !bw_qualifier.equals("*")) && (bw_qualifier != null || qualifier != null)) continue;
            return indexName;
        }
        return null;
    }
}

