/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class CommunityListServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(CommunityListServlet.class);

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        log.info((Object)LogManager.getHeader((Context)context, (String)"view_community_list", (String)""));
        HashMap<Integer, Collection[]> colMap = new HashMap<Integer, Collection[]>();
        HashMap<Integer, Community[]> commMap = new HashMap<Integer, Community[]>();
        Community[] communities = Community.findAllTop((Context)context);
        for (int com = 0; com < communities.length; ++com) {
            Integer comID = new Integer(communities[com].getID());
            Collection[] colls = communities[com].getCollections();
            colMap.put(comID, colls);
            Community[] comms = communities[com].getSubcommunities();
            commMap.put(comID, comms);
        }
        if (AuthorizeManager.isAdmin((Context)context)) {
            request.setAttribute("admin_button", (Object)new Boolean(true));
        }
        request.setAttribute("communities", (Object)communities);
        request.setAttribute("collections.map", colMap);
        request.setAttribute("subcommunities.map", commMap);
        JSPManager.showJSP(request, response, "/community-list.jsp");
    }
}

