/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UsageEvent;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;

public class RetrieveServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(RetrieveServlet.class);

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        Bitstream bitstream = null;
        String idString = request.getPathInfo();
        if (idString != null) {
            int slashIndex;
            if (idString.startsWith("/")) {
                idString = idString.substring(1);
            }
            if ((slashIndex = idString.indexOf(47)) != -1) {
                idString = idString.substring(0, slashIndex);
            }
            try {
                int id = Integer.parseInt(idString);
                bitstream = Bitstream.find((Context)context, (int)id);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (bitstream != null) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_bitstream", (String)("bitstream_id=" + bitstream.getID())));
            UsageEvent ue = new UsageEvent();
            ue.fire(request, context, 1, 0, bitstream.getID());
            InputStream is = bitstream.retrieve();
            response.setContentType(bitstream.getFormat().getMIMEType());
            response.setHeader("Content-Length", String.valueOf(bitstream.getSize()));
            Utils.bufferedCopy((InputStream)is, (OutputStream)response.getOutputStream());
            is.close();
            response.getOutputStream().flush();
        } else {
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_bitstream", (String)("invalid_bitstream_id=" + idString)));
            JSPManager.showInvalidIDError(request, response, idString, 0);
        }
    }
}

