/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.itemexport.ItemExport;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;
import org.dspace.eperson.EPerson;

public class ItemExportArchiveServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(ItemExportArchiveServlet.class);
    private int threshold;

    public void init(ServletConfig arg0) throws ServletException {
        super.init(arg0);
        this.threshold = ConfigurationManager.getIntProperty((String)"webui.content_disposition_threshold");
    }

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String filename = null;
        filename = request.getPathInfo().substring(request.getPathInfo().lastIndexOf(47) + 1);
        System.out.println(filename);
        if (ItemExport.canDownload((Context)context, (String)filename)) {
            try {
                InputStream exportStream = ItemExport.getExportDownloadInputStream((String)filename, (EPerson)context.getCurrentUser());
                if (exportStream == null || filename == null) {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_id", (String)("path=" + filename)));
                    JSPManager.showInvalidIDError(request, response, filename, 0);
                    return;
                }
                log.info((Object)LogManager.getHeader((Context)context, (String)"download_export_archive", (String)("filename=" + filename)));
                long lastModified = ItemExport.getExportFileLastModified((String)filename);
                response.setDateHeader("Last-Modified", lastModified);
                long modSince = request.getDateHeader("If-Modified-Since");
                if (modSince != -1L && lastModified < modSince) {
                    response.setStatus(304);
                    return;
                }
                response.setContentType("application/zip");
                long size = ItemExport.getExportFileSize((String)filename);
                response.setHeader("Content-Length", String.valueOf(size));
                response.setHeader("Content-Disposition", "attachment;filename=" + filename);
                Utils.bufferedCopy((InputStream)exportStream, (OutputStream)response.getOutputStream());
                exportStream.close();
                response.getOutputStream().flush();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            throw new AuthorizeException("You are not authorized to download this Export Archive.");
        }
    }
}

