/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.webui.submit.JSPStep;
import org.dspace.app.webui.submit.JSPStepManager;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.submit.step.DescribeStep;

public class JSPDescribeStep
extends JSPStep {
    private static final String DISPLAY_JSP = "/submit/edit-metadata.jsp";
    private static final String REVIEW_JSP = "/submit/review-metadata.jsp";
    private static Logger log = Logger.getLogger(JSPDescribeStep.class);

    public void doPreProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        this.showEditMetadata(context, request, response, subInfo);
    }

    public void doPostProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, int status) throws ServletException, IOException, SQLException, AuthorizeException {
        List missingFields;
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)DescribeStep.NEXT_BUTTON);
        if (subInfo.getSubmissionItem() == null) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
            JSPManager.showIntegrityError(request, response);
            return;
        }
        if (status == 1) {
            this.showEditMetadata(context, request, response, subInfo);
        } else if (buttonPressed.indexOf("remove") > -1) {
            this.showEditMetadata(context, request, response, subInfo);
        } else if (status == 2 && (missingFields = DescribeStep.getErrorFields((HttpServletRequest)request)).size() > 0) {
            subInfo.setJumpToField((String)missingFields.get(0));
            subInfo.setMissingFields(missingFields);
            this.showEditMetadata(context, request, response, subInfo);
        }
    }

    private void showEditMetadata(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws SQLException, ServletException, IOException {
        Locale sessionLocale = null;
        sessionLocale = UIUtil.getSessionLocale(request);
        String formFileName = I18nUtil.getInputFormsFileName((Locale)sessionLocale);
        Collection c = subInfo.getSubmissionItem().getCollection();
        request.setAttribute("submission.inputs", (Object)DescribeStep.getInputsReader((String)formFileName).getInputs(c.getHandle()));
        JSPStepManager.showJSP(request, response, subInfo, DISPLAY_JSP);
    }

    public String getReviewJSP(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) {
        return REVIEW_JSP;
    }
}

