/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.app.webui.util.Authenticate;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.EPerson;

public class UIUtil
extends Util {
    public static Logger log = Logger.getLogger(UIUtil.class);

    public static Context obtainContext(HttpServletRequest request) throws SQLException {
        try {
            if (request.getCharacterEncoding() == null) {
                request.setCharacterEncoding("UTF-8");
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to set encoding to UTF-8.", (Throwable)e);
        }
        Context c = (Context)request.getAttribute("dspace.context");
        if (c == null) {
            c = new Context();
            HttpSession session = request.getSession();
            Integer userID = (Integer)session.getAttribute("dspace.current.user.id");
            if (userID != null) {
                String remAddr = (String)session.getAttribute("dspace.current.remote.addr");
                if (remAddr != null && remAddr.equals(request.getRemoteAddr())) {
                    EPerson e = EPerson.find((Context)c, (int)userID);
                    Authenticate.loggedIn(c, request, e);
                } else {
                    log.warn((Object)("POSSIBLE HIJACKED SESSION: request from " + request.getRemoteAddr() + " does not match original " + "session address: " + remAddr + ". Authentication rejected."));
                }
            }
            int[] groupIDs = AuthenticationManager.getSpecialGroups((Context)c, (HttpServletRequest)request);
            for (int i = 0; i < groupIDs.length; ++i) {
                c.setSpecialGroup(groupIDs[i]);
                log.debug((Object)("Adding Special Group id=" + String.valueOf(groupIDs[i])));
            }
            c.setExtraLogInfo("session_id=" + request.getSession().getId() + ":ip_addr=" + request.getRemoteAddr());
            request.setAttribute("dspace.context", (Object)c);
        }
        Locale sessionLocale = UIUtil.getSessionLocale(request);
        Config.set((HttpSession)request.getSession(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)sessionLocale);
        c.setCurrentLocale(sessionLocale);
        return c;
    }

    public static Community getCommunityLocation(HttpServletRequest request) {
        return (Community)request.getAttribute("dspace.community");
    }

    public static Collection getCollectionLocation(HttpServletRequest request) {
        return (Collection)request.getAttribute("dspace.collection");
    }

    public static void storeOriginalURL(HttpServletRequest request) {
        String orig = (String)request.getAttribute("dspace.original.url");
        if (orig == null) {
            String fullURL = request.getRequestURL().toString();
            if (request.getQueryString() != null) {
                fullURL = fullURL + "?" + request.getQueryString();
            }
            request.setAttribute("dspace.original.url", (Object)fullURL);
        }
    }

    public static String getOriginalURL(HttpServletRequest request) {
        UIUtil.storeOriginalURL(request);
        return (String)request.getAttribute("dspace.original.url");
    }

    public static String displayDate(DCDate d, boolean time, boolean localTime, HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        Locale locale = ((Context)request.getAttribute("dspace.context")).getCurrentLocale();
        if (locale == null) {
            locale = I18nUtil.DEFAULTLOCALE;
        }
        if (d != null) {
            int second;
            int minute;
            int hour;
            int day;
            int month;
            int year;
            if (localTime) {
                year = d.getYear();
                month = d.getMonth();
                day = d.getDay();
                hour = d.getHour();
                minute = d.getMinute();
                second = d.getSecond();
            } else {
                year = d.getYearGMT();
                month = d.getMonthGMT();
                day = d.getDayGMT();
                hour = d.getHourGMT();
                minute = d.getMinuteGMT();
                second = d.getSecondGMT();
            }
            if (year > -1) {
                if (month > -1) {
                    String monthName;
                    int monthLength;
                    if (day > -1) {
                        sb.append(day + "-");
                    }
                    monthLength = (monthLength = (monthName = DCDate.getMonthName((int)month, (Locale)UIUtil.getSessionLocale(request))).length()) > 2 ? 3 : monthLength;
                    sb.append(monthName.substring(0, monthLength) + "-");
                }
                sb.append(year + " ");
            }
            if (time && hour > -1) {
                String hr = String.valueOf(hour);
                while (hr.length() < 2) {
                    hr = "0" + hr;
                }
                String mn = String.valueOf(minute);
                while (mn.length() < 2) {
                    mn = "0" + mn;
                }
                String sc = String.valueOf(second);
                while (sc.length() < 2) {
                    sc = "0" + sc;
                }
                sb.append(hr + ":" + mn + ":" + sc + " ");
            }
        } else {
            sb.append("Unset");
        }
        return sb.toString();
    }

    public static String getRequestLogInfo(HttpServletRequest request) {
        String report = "-- URL Was: " + UIUtil.getOriginalURL(request) + "\n";
        report = report + "-- Method: " + request.getMethod() + "\n";
        report = report + "-- Parameters were:\n";
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("login_password")) {
                report = report + "-- " + name + ": *not logged*\n";
                continue;
            }
            report = report + "-- " + name + ": \"" + request.getParameter(name) + "\"\n";
        }
        return report;
    }

    public static Locale getSessionLocale(HttpServletRequest request) {
        String paramLocale = request.getParameter("locale");
        Locale sessionLocale = null;
        Locale supportedLocale = null;
        if (paramLocale != null && paramLocale != "") {
            sessionLocale = new Locale(paramLocale);
        }
        if (sessionLocale == null) {
            HttpSession session = request.getSession();
            sessionLocale = (Locale)Config.get((HttpSession)session, (String)"javax.servlet.jsp.jstl.fmt.locale");
        }
        if (sessionLocale == null) {
            sessionLocale = request.getLocale();
        }
        if (sessionLocale == null) {
            sessionLocale = I18nUtil.DEFAULTLOCALE;
        }
        supportedLocale = I18nUtil.getSupportedLocale((Locale)sessionLocale);
        return supportedLocale;
    }

    public static void sendAlert(HttpServletRequest request, Exception exception) {
        String logInfo = UIUtil.getRequestLogInfo(request);
        Context c = (Context)request.getAttribute("dspace.context");
        try {
            String recipient = ConfigurationManager.getProperty((String)"alert.recipient");
            if (recipient != null) {
                String stackTrace;
                Email email = ConfigurationManager.getEmail((String)I18nUtil.getEmailFilename((Locale)c.getCurrentLocale(), (String)"internal_error"));
                email.addRecipient(recipient);
                email.addArgument((Object)ConfigurationManager.getProperty((String)"dspace.url"));
                email.addArgument((Object)new Date());
                email.addArgument((Object)request.getSession().getId());
                email.addArgument((Object)logInfo);
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    pw.flush();
                    stackTrace = sw.toString();
                } else {
                    stackTrace = "No exception";
                }
                email.addArgument((Object)stackTrace);
                email.send();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to send email alert", (Throwable)e);
        }
    }
}

