/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static Document loadXML(String filename) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse(new File(filename));
    }

    public static Document transformDocument(Document xmlDocument, String xsltFilename) throws Exception {
        return XMLUtil.transformDocument(xmlDocument, new Hashtable(), xsltFilename);
    }

    public static Document transformDocument(Document xmlDocument, Hashtable parameters, String xsltFilename) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xsltFilename));
        if (parameters != null) {
            Enumeration keys = parameters.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)parameters.get(key);
                transformer.setParameter(key, value);
            }
        }
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
        Document dstDocument = dBuilder.newDocument();
        DOMResult domResult = new DOMResult(dstDocument);
        transformer.transform(new DOMSource(xmlDocument), domResult);
        return dstDocument;
    }

    public static String transformDocumentAsString(Document xmlDocument, Hashtable parameters, String xsltFilename) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xsltFilename));
        if (parameters != null) {
            Enumeration keys = parameters.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)parameters.get(key);
                transformer.setParameter(key, value);
            }
        }
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        transformer.transform(new DOMSource(xmlDocument), streamResult);
        return stringWriter.toString();
    }

    public static String transformDocumentAsString(Document xmlDocument, String xsltFilename) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xsltFilename));
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        transformer.transform(new DOMSource(xmlDocument), streamResult);
        return stringWriter.toString();
    }
}

