/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.MetadataExport;
import org.dspace.app.webui.servlet.AbstractBrowserServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseInfo;
import org.dspace.browse.BrowseItem;
import org.dspace.browse.BrowserScope;
import org.dspace.content.ItemIterator;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class BrowserServlet
extends AbstractBrowserServlet {
    private static Logger log = Logger.getLogger(AbstractBrowserServlet.class);

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        BrowserScope scope = this.getBrowserScopeForRequest(context, request, response);
        if (scope.getBrowseIndex() == null) {
            throw new ServletException("There is no browse index for the request");
        }
        if ("submit_export_metadata".equals(UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit"))) {
            this.exportMetadata(context, request, response, scope);
        } else {
            this.processBrowse(context, scope, request, response);
        }
    }

    @Override
    protected void showError(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        JSPManager.showJSP(request, response, "/browse/error.jsp");
    }

    @Override
    protected void showNoResultsPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        JSPManager.showJSP(request, response, "/browse/no-results.jsp");
    }

    @Override
    protected void showSinglePage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        JSPManager.showJSP(request, response, "/browse/single.jsp");
    }

    @Override
    protected void showFullPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        JSPManager.showJSP(request, response, "/browse/full.jsp");
    }

    protected void exportMetadata(Context context, HttpServletRequest request, HttpServletResponse response, BrowserScope scope) throws IOException, ServletException {
        try {
            log.info((Object)LogManager.getHeader((Context)context, (String)"metadataexport", (String)"exporting_browse"));
            scope.setOffset(0);
            scope.setResultsPerPage(Integer.MAX_VALUE);
            BrowseEngine be = new BrowseEngine(context);
            BrowseInfo binfo = be.browse(scope);
            ArrayList<Integer> iids = new ArrayList<Integer>();
            for (BrowseItem bi : binfo.getBrowseItemResults()) {
                iids.add(bi.getID());
            }
            ItemIterator ii = new ItemIterator(context, iids);
            MetadataExport exporter = new MetadataExport(context, ii, false);
            DSpaceCSV csv = exporter.export();
            response.setContentType("text/csv; charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=browse-result.csv");
            PrintWriter out = response.getWriter();
            out.write(csv.toString());
            out.flush();
            out.close();
            log.info((Object)LogManager.getHeader((Context)context, (String)"metadataexport", (String)"exported_file:browse-results.csv"));
            return;
        }
        catch (BrowseException be) {
            JSPManager.showIntegrityError(request, response);
            return;
        }
    }
}

