/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.servlet.admin.EditCommunitiesServlet;
import org.dspace.app.webui.util.FileUploadRequest;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.authority.Choices;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;
import org.dspace.license.CreativeCommons;

public class EditItemServlet
extends DSpaceServlet {
    public static final int START_DELETE = 1;
    public static final int CONFIRM_DELETE = 2;
    public static final int UPDATE_ITEM = 3;
    public static final int START_WITHDRAW = 4;
    public static final int CONFIRM_WITHDRAW = 5;
    public static final int REINSTATE = 6;
    public static final int START_MOVE_ITEM = 7;
    public static final int CONFIRM_MOVE_ITEM = 8;
    private static Logger log = Logger.getLogger(EditCommunitiesServlet.class);

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int internalID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"item_id");
        String handle = request.getParameter("handle");
        boolean showError = false;
        Item itemToEdit = null;
        if (internalID > 0) {
            itemToEdit = Item.find((Context)context, (int)internalID);
            showError = itemToEdit == null;
        } else if (handle != null && !handle.equals("")) {
            DSpaceObject dso = HandleManager.resolveToObject((Context)context, (String)handle.trim());
            if (dso != null && dso.getType() == 2) {
                itemToEdit = (Item)dso;
                showError = false;
            } else {
                showError = true;
            }
        }
        if (itemToEdit != null) {
            this.checkEditAuthorization(context, itemToEdit);
            this.showEditForm(context, request, response, itemToEdit);
        } else {
            if (showError) {
                request.setAttribute("invalid.id", (Object)Boolean.TRUE);
            }
            JSPManager.showJSP(request, response, "/tools/get-item-id.jsp");
        }
    }

    @Override
    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String contentType = request.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            this.processUploadBitstream(context, request, response);
            return;
        }
        if (request.getParameter("submit_cancel") != null) {
            JSPManager.showJSP(request, response, "/tools/get-item-id.jsp");
            return;
        }
        int action = UIUtil.getIntParameter((HttpServletRequest)request, (String)"action");
        Item item = Item.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"item_id"));
        String handle = HandleManager.findHandle((Context)context, (DSpaceObject)item);
        this.checkEditAuthorization(context, item);
        request.setAttribute("item", (Object)item);
        request.setAttribute("handle", (Object)handle);
        switch (action) {
            case 1: {
                JSPManager.showJSP(request, response, "/tools/confirm-delete-item.jsp");
                break;
            }
            case 2: {
                Collection[] collections = item.getCollections();
                for (int i = 0; i < collections.length; ++i) {
                    collections[i].removeItem(item);
                }
                JSPManager.showJSP(request, response, "/tools/get-item-id.jsp");
                context.complete();
                break;
            }
            case 3: {
                this.processUpdateItem(context, request, response, item);
                break;
            }
            case 4: {
                JSPManager.showJSP(request, response, "/tools/confirm-withdraw-item.jsp");
                break;
            }
            case 5: {
                item.withdraw();
                JSPManager.showJSP(request, response, "/tools/get-item-id.jsp");
                context.complete();
                break;
            }
            case 6: {
                item.reinstate();
                JSPManager.showJSP(request, response, "/tools/get-item-id.jsp");
                context.complete();
                break;
            }
            case 7: {
                if (AuthorizeManager.isAdmin((Context)context, (DSpaceObject)item)) {
                    Collection[] allNotLinkedCollections = item.getCollectionsNotLinked();
                    Collection[] allLinkedCollections = item.getCollections();
                    ArrayList<Collection> authNotLinkedCollections = new ArrayList<Collection>();
                    for (Collection c : allNotLinkedCollections) {
                        if (!AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)c, (int)3)) continue;
                        authNotLinkedCollections.add(c);
                    }
                    ArrayList<Collection> authLinkedCollections = new ArrayList<Collection>();
                    for (Collection c : allLinkedCollections) {
                        if (!AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)c, (int)4)) continue;
                        authLinkedCollections.add(c);
                    }
                    Collection[] notLinkedCollections = new Collection[authNotLinkedCollections.size()];
                    notLinkedCollections = authNotLinkedCollections.toArray(notLinkedCollections);
                    Collection[] linkedCollections = new Collection[authLinkedCollections.size()];
                    linkedCollections = authLinkedCollections.toArray(linkedCollections);
                    request.setAttribute("linkedCollections", (Object)linkedCollections);
                    request.setAttribute("notLinkedCollections", (Object)notLinkedCollections);
                    JSPManager.showJSP(request, response, "/tools/move-item.jsp");
                    break;
                }
                throw new ServletException("You must be an administrator to move an item");
            }
            case 8: {
                if (AuthorizeManager.isAdmin((Context)context, (DSpaceObject)item)) {
                    Collection fromCollection = Collection.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection_from_id"));
                    Collection toCollection = Collection.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection_to_id"));
                    Boolean inheritPolicies = false;
                    if (request.getParameter("inheritpolicies") != null) {
                        inheritPolicies = true;
                    }
                    if (fromCollection == null || toCollection == null) {
                        throw new ServletException("Missing or incorrect collection IDs for moving item");
                    }
                    item.move(fromCollection, toCollection, inheritPolicies.booleanValue());
                    this.showEditForm(context, request, response, item);
                    context.complete();
                    break;
                }
                throw new ServletException("You must be an administrator to move an item");
            }
            default: {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
                JSPManager.showIntegrityError(request, response);
            }
        }
    }

    private void checkEditAuthorization(Context c, Item item) throws AuthorizeException, SQLException {
        if (!item.canEdit()) {
            int userID = 0;
            if (c.getCurrentUser() != null) {
                userID = c.getCurrentUser().getID();
            }
            throw new AuthorizeException("EditItemServlet: User " + userID + " not authorized to edit item " + item.getID());
        }
    }

    private void showEditForm(Context context, HttpServletRequest request, HttpServletResponse response, Item item) throws ServletException, IOException, SQLException, AuthorizeException {
        if (request.getParameter("cc_license_url") != null) {
            AuthorizeUtil.authorizeManageCCLicense((Context)context, (Item)item);
            context.turnOffAuthorisationSystem();
            CreativeCommons.setLicense((Context)context, (Item)item, (String)request.getParameter("cc_license_url"));
            context.restoreAuthSystemState();
            context.commit();
        }
        String handle = HandleManager.findHandle((Context)context, (DSpaceObject)item);
        Collection[] collections = item.getCollections();
        MetadataField[] types = MetadataField.findAll((Context)context);
        HashMap<Integer, String> metadataFields = new HashMap<Integer, String>();
        MetadataSchema[] schemas = MetadataSchema.findAll((Context)context);
        for (int i = 0; i < schemas.length; ++i) {
            String schemaName = schemas[i].getName();
            MetadataField[] fields = MetadataField.findAllInSchema((Context)context, (int)schemas[i].getSchemaID());
            for (int j = 0; j < fields.length; ++j) {
                Integer fieldID = fields[j].getFieldID();
                String displayName = "";
                displayName = schemaName + "." + fields[j].getElement() + (fields[j].getQualifier() == null ? "" : "." + fields[j].getQualifier());
                metadataFields.put(fieldID, displayName);
            }
        }
        request.setAttribute("admin_button", (Object)AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)item, (int)11));
        try {
            AuthorizeUtil.authorizeManageItemPolicy((Context)context, (Item)item);
            request.setAttribute("policy_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("policy_button", (Object)Boolean.FALSE);
        }
        if (AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)item.getParentObject(), (int)4)) {
            request.setAttribute("delete_button", (Object)Boolean.TRUE);
        } else {
            request.setAttribute("delete_button", (Object)Boolean.FALSE);
        }
        try {
            AuthorizeManager.authorizeAction((Context)context, (DSpaceObject)item, (int)3);
            request.setAttribute("create_bitstream_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("create_bitstream_button", (Object)Boolean.FALSE);
        }
        try {
            AuthorizeManager.authorizeAction((Context)context, (DSpaceObject)item, (int)4);
            request.setAttribute("remove_bitstream_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("remove_bitstream_button", (Object)Boolean.FALSE);
        }
        try {
            AuthorizeUtil.authorizeManageCCLicense((Context)context, (Item)item);
            request.setAttribute("cclicense_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("cclicense_button", (Object)Boolean.FALSE);
        }
        if (!item.isWithdrawn()) {
            try {
                AuthorizeUtil.authorizeWithdrawItem((Context)context, (Item)item);
                request.setAttribute("withdraw_button", (Object)Boolean.TRUE);
            }
            catch (AuthorizeException authex) {
                request.setAttribute("withdraw_button", (Object)Boolean.FALSE);
            }
        } else {
            try {
                AuthorizeUtil.authorizeReinstateItem((Context)context, (Item)item);
                request.setAttribute("reinstate_button", (Object)Boolean.TRUE);
            }
            catch (AuthorizeException authex) {
                request.setAttribute("reinstate_button", (Object)Boolean.FALSE);
            }
        }
        request.setAttribute("item", (Object)item);
        request.setAttribute("handle", (Object)handle);
        request.setAttribute("collections", (Object)collections);
        request.setAttribute("dc.types", (Object)types);
        request.setAttribute("metadataFields", metadataFields);
        JSPManager.showJSP(request, response, "/tools/edit-item-form.jsp");
    }

    private void processUpdateItem(Context context, HttpServletRequest request, HttpServletResponse response, Item item) throws ServletException, IOException, SQLException, AuthorizeException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        item.clearMetadata("*", "*", "*", "*");
        Enumeration unsortedParamNames = request.getParameterNames();
        LinkedList<String> sortedParamNames = new LinkedList<String>();
        while (unsortedParamNames.hasMoreElements()) {
            sortedParamNames.add((String)unsortedParamNames.nextElement());
        }
        Collections.sort(sortedParamNames);
        for (String p : sortedParamNames) {
            String key;
            StringTokenizer st;
            if (p.startsWith("value")) {
                String sconfidence;
                String authority;
                st = new StringTokenizer(p, "_");
                st.nextToken();
                String schema = st.nextToken();
                String element = st.nextToken();
                String qualifier = null;
                if (st.countTokens() == 2) {
                    qualifier = st.nextToken();
                }
                String sequenceNumber = st.nextToken();
                key = MetadataField.formKey((String)schema, (String)element, (String)qualifier);
                String language = request.getParameter("language_" + key + "_" + sequenceNumber);
                if (language != null && (language = language.trim()).equals("")) {
                    language = null;
                }
                if ((authority = request.getParameter("choice_" + key + "_authority_" + sequenceNumber)) != null && authority.equals("")) {
                    authority = null;
                }
                int confidence = (sconfidence = request.getParameter("choice_" + key + "_confidence_" + sequenceNumber)) == null || sconfidence.equals("") ? 0 : Choices.getConfidenceValue((String)sconfidence);
                String value = request.getParameter(p).trim();
                if (value.equals("") && authority == null || button.equals("submit_remove_" + key + "_" + sequenceNumber)) continue;
                item.addMetadata(schema, element, qualifier, language, value, authority, confidence);
                continue;
            }
            if (!p.startsWith("bitstream_name")) continue;
            st = new StringTokenizer(p, "_");
            st.nextToken();
            st.nextToken();
            int bundleID = Integer.parseInt(st.nextToken());
            int bitstreamID = Integer.parseInt(st.nextToken());
            Bundle bundle = Bundle.find((Context)context, (int)bundleID);
            Bitstream bitstream = Bitstream.find((Context)context, (int)bitstreamID);
            key = String.valueOf(bundleID) + "_" + bitstreamID;
            if (button.equals("submit_delete_bitstream_" + key)) {
                bundle.removeBitstream(bitstream);
                if (bundle.getBitstreams().length != 0) continue;
                item.removeBundle(bundle);
                continue;
            }
            String name = request.getParameter(p);
            String source = request.getParameter("bitstream_source_" + key);
            String desc = request.getParameter("bitstream_description_" + key);
            int formatID = UIUtil.getIntParameter((HttpServletRequest)request, (String)("bitstream_format_id_" + key));
            String userFormatDesc = request.getParameter("bitstream_user_format_description_" + key);
            int primaryBitstreamID = UIUtil.getIntParameter((HttpServletRequest)request, (String)(bundleID + "_primary_bitstream_id"));
            if (source.equals("")) {
                source = null;
            }
            if (desc.equals("")) {
                desc = null;
            }
            if (userFormatDesc.equals("")) {
                userFormatDesc = null;
            }
            bitstream.setName(name);
            bitstream.setSource(source);
            bitstream.setDescription(desc);
            bitstream.setFormat(BitstreamFormat.find((Context)context, (int)formatID));
            if (primaryBitstreamID > 0) {
                bundle.setPrimaryBitstreamID(primaryBitstreamID);
            }
            if (userFormatDesc != null) {
                bitstream.setUserFormatDescription(userFormatDesc);
            }
            bitstream.update();
            bundle.update();
        }
        if (button.equals("submit_addfield")) {
            int dcTypeID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"addfield_dctype");
            String value = request.getParameter("addfield_value").trim();
            String lang = request.getParameter("addfield_language");
            if (lang != null && (lang = lang.trim()).equals("")) {
                lang = null;
            }
            MetadataField field = MetadataField.find((Context)context, (int)dcTypeID);
            MetadataSchema schema = MetadataSchema.find((Context)context, (int)field.getSchemaID());
            item.addMetadata(schema.getName(), field.getElement(), field.getQualifier(), lang, value);
        }
        item.update();
        if (button.equals("submit_addcc")) {
            request.setAttribute("item", (Object)item);
            JSPManager.showJSP(request, response, "/tools/creative-commons-edit.jsp");
        }
        if (button.equals("submit_addbitstream")) {
            request.setAttribute("item", (Object)item);
            JSPManager.showJSP(request, response, "/tools/upload-bitstream.jsp");
        } else {
            this.showEditForm(context, request, response, item);
        }
        context.complete();
    }

    private void processUploadBitstream(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        FileUploadRequest wrapper = new FileUploadRequest(request);
        Bitstream b = null;
        Item item = Item.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)wrapper, (String)"item_id"));
        File temp = wrapper.getFile("file");
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(temp));
        this.checkEditAuthorization(context, item);
        Bundle[] bundles = item.getBundles("ORIGINAL");
        if (bundles.length < 1) {
            b = item.createSingleBitstream((InputStream)is, "ORIGINAL");
            Collection owningCollection = item.getOwningCollection();
            if (owningCollection != null) {
                Bundle bnd = b.getBundles()[0];
                bnd.inheritCollectionDefaultPolicies(owningCollection);
            }
        } else {
            b = bundles[0].createBitstream((InputStream)is);
        }
        String noPath = wrapper.getFilesystemName("file");
        while (noPath.indexOf(47) > -1) {
            noPath = noPath.substring(noPath.indexOf(47) + 1);
        }
        while (noPath.indexOf(92) > -1) {
            noPath = noPath.substring(noPath.indexOf(92) + 1);
        }
        b.setName(noPath);
        b.setSource(wrapper.getFilesystemName("file"));
        BitstreamFormat bf = FormatIdentifier.guessFormat((Context)context, (Bitstream)b);
        b.setFormat(bf);
        b.update();
        item.update();
        this.showEditForm(context, request, response, item);
        if (!temp.delete()) {
            log.error((Object)"Unable to delete temporary file");
        }
        context.complete();
    }
}

