/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.ConfigurationManager;

public class LayoutTag
extends TagSupport {
    private static Logger log = Logger.getLogger(LayoutTag.class);
    private String style;
    private String title;
    private String titleKey;
    private String navbar;
    private String locbar;
    private String parentTitle;
    private String parentTitleKey;
    private String parentLink;
    private String sidebar;
    private String noCache;
    private String feedData;

    public int doStartTag() throws JspException {
        ServletRequest request = this.pageContext.getRequest();
        String header = "/layout/header-default.jsp";
        if (this.style != null) {
            header = "/layout/header-" + this.style.toLowerCase() + ".jsp";
        }
        if (this.locbar == null) {
            this.locbar = "auto";
        }
        ArrayList<String> parents = new ArrayList<String>();
        ArrayList<String> parentLinks = new ArrayList<String>();
        if (this.locbar.equalsIgnoreCase("off")) {
            request.setAttribute("dspace.layout.locbar", (Object)Boolean.FALSE);
        } else {
            parents.add(ConfigurationManager.getProperty((String)"dspace.name"));
            if (this.locbar.equalsIgnoreCase("nolink")) {
                parentLinks.add("");
            } else {
                parentLinks.add("/");
            }
            if (this.locbar.equalsIgnoreCase("link")) {
                if (this.parentTitle != null) {
                    parents.add(this.parentTitle);
                    parentLinks.add(this.parentLink);
                } else if (this.parentTitleKey != null) {
                    parents.add(LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)this.parentTitleKey));
                    parentLinks.add(this.parentLink);
                }
            } else if (this.locbar.equalsIgnoreCase("commLink")) {
                Community[] comms = (Community[])request.getAttribute("dspace.communities");
                if (comms != null) {
                    for (int i = 0; i < comms.length; ++i) {
                        parents.add(comms[i].getMetadata("name"));
                        parentLinks.add("/handle/" + comms[i].getHandle());
                    }
                }
            } else if (this.locbar.equalsIgnoreCase("nolink")) {
                if (this.parentTitle != null) {
                    parents.add(this.parentTitle);
                    parentLinks.add("");
                }
            } else {
                Collection col = (Collection)request.getAttribute("dspace.collection");
                Community[] comms = (Community[])request.getAttribute("dspace.communities");
                if (comms != null) {
                    for (int i = 0; i < comms.length; ++i) {
                        parents.add(comms[i].getMetadata("name"));
                        parentLinks.add("/handle/" + comms[i].getHandle());
                    }
                    if (col != null) {
                        parents.add(col.getMetadata("name"));
                        parentLinks.add("/handle/" + col.getHandle());
                    }
                }
            }
            request.setAttribute("dspace.layout.locbar", (Object)Boolean.TRUE);
        }
        request.setAttribute("dspace.layout.parenttitles", parents);
        request.setAttribute("dspace.layout.parentlinks", parentLinks);
        if (this.navbar == null) {
            this.navbar = "default";
        }
        if (this.navbar.equals("off")) {
            request.setAttribute("dspace.layout.navbar", (Object)"off");
        } else {
            request.setAttribute("dspace.layout.navbar", (Object)("/layout/navbar-" + this.navbar + ".jsp"));
        }
        if (this.title != null) {
            request.setAttribute("dspace.layout.title", (Object)this.title);
        } else if (this.titleKey != null) {
            request.setAttribute("dspace.layout.title", (Object)LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)this.titleKey));
        } else {
            request.setAttribute("dspace.layout.title", (Object)"NO TITLE");
        }
        if (this.feedData != null && !"NONE".equals(this.feedData)) {
            boolean commLinks = this.feedData.startsWith("comm:");
            boolean collLinks = this.feedData.startsWith("coll:");
            if (commLinks) {
                Community com = (Community)request.getAttribute("dspace.community");
                request.setAttribute("dspace.layout.feedref", (Object)com.getHandle());
            } else if (collLinks) {
                Collection col = (Collection)request.getAttribute("dspace.collection");
                request.setAttribute("dspace.layout.feedref", (Object)col.getHandle());
            } else {
                request.setAttribute("dspace.layout.feedref", (Object)"site");
            }
            String[] formats = this.feedData.substring(this.feedData.indexOf(58) + 1).split(",");
            ArrayList<String> linkParts = new ArrayList<String>();
            for (int i = 0; i < formats.length; ++i) {
                if ("rss_1.0".equals(formats[i])) {
                    linkParts.add("rdf+xml");
                } else {
                    linkParts.add("rss+xml");
                }
                if (commLinks) {
                    linkParts.add("Items in Community");
                } else if (collLinks) {
                    linkParts.add("Items in Collection");
                } else {
                    linkParts.add("Items in " + ConfigurationManager.getProperty((String)"dspace.name"));
                }
                linkParts.add(formats[i]);
            }
            request.setAttribute("dspace.layout.linkparts", linkParts);
        } else {
            request.setAttribute("dspace.layout.feedref", (Object)"NONE");
        }
        try {
            HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
            if (this.noCache != null && this.noCache.equalsIgnoreCase("true")) {
                response.addDateHeader("expires", 1L);
                response.addHeader("Pragma", "no-cache");
                response.addHeader("Cache-control", "no-store");
            }
            response.setContentType("text/html; charset=UTF-8");
            ServletConfig config = this.pageContext.getServletConfig();
            RequestDispatcher rd = config.getServletContext().getRequestDispatcher(header);
            rd.include(request, (ServletResponse)response);
        }
        catch (IOException ioe) {
            throw new JspException("Got IOException: " + ioe);
        }
        catch (ServletException se) {
            log.warn((Object)"Exception", se.getRootCause());
            throw new JspException("Got ServletException: " + (Object)((Object)se));
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        String footer = "/layout/footer-default.jsp";
        if (this.style != null) {
            footer = "/layout/footer-" + this.style.toLowerCase() + ".jsp";
        }
        try {
            this.pageContext.getOut().flush();
            ServletRequest request = this.pageContext.getRequest();
            ServletResponse response = this.pageContext.getResponse();
            ServletConfig config = this.pageContext.getServletConfig();
            if (this.sidebar != null) {
                request.setAttribute("dspace.layout.sidebar", (Object)this.sidebar);
            }
            RequestDispatcher rd = config.getServletContext().getRequestDispatcher(footer);
            rd.include(request, response);
        }
        catch (ServletException se) {
            throw new JspException("Got ServletException: " + (Object)((Object)se));
        }
        catch (IOException ioe) {
            throw new JspException("Got IOException: " + ioe);
        }
        return 6;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String v) {
        this.title = v;
    }

    public String getTitlekey() {
        return this.titleKey;
    }

    public void setTitlekey(String titleKey) {
        this.titleKey = titleKey;
    }

    public String getNavbar() {
        return this.navbar;
    }

    public void setNavbar(String v) {
        this.navbar = v;
    }

    public String getLocbar() {
        return this.locbar;
    }

    public void setLocbar(String v) {
        this.locbar = v;
    }

    public String getParenttitle() {
        return this.parentTitle;
    }

    public void setParenttitle(String v) {
        this.parentTitle = v;
    }

    public String getParenttitlekey() {
        return this.parentTitleKey;
    }

    public void setParenttitlekey(String parentTitleKey) {
        this.parentTitleKey = parentTitleKey;
    }

    public String getParentlink() {
        return this.parentLink;
    }

    public void setParentlink(String v) {
        this.parentLink = v;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String v) {
        this.style = v;
    }

    public String getSidebar() {
        return this.sidebar;
    }

    public void setSidebar(String v) {
        this.sidebar = v;
    }

    public String getNocache() {
        return this.noCache;
    }

    public void setNocache(String v) {
        this.noCache = v;
    }

    public String getFeedData() {
        return this.feedData;
    }

    public void setFeedData(String v) {
        this.feedData = v;
    }

    public void release() {
        this.style = null;
        this.title = null;
        this.sidebar = null;
        this.navbar = null;
        this.locbar = null;
        this.parentTitle = null;
        this.parentLink = null;
        this.noCache = null;
        this.feedData = null;
    }
}

