/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.webui.submit.JSPStep;
import org.dspace.app.webui.submit.JSPStepManager;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.FormatIdentifier;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class JSPUploadStep
extends JSPStep {
    private static final String CHOOSE_FILE_JSP = "/submit/choose-file.jsp";
    private static final String UPLOAD_LIST_JSP = "/submit/upload-file-list.jsp";
    private static final String UPLOAD_FILE_JSP = "/submit/show-uploaded-file.jsp";
    private static final String FILE_DESCRIPTION_JSP = "/submit/change-file-description.jsp";
    private static final String FILE_FORMAT_JSP = "/submit/get-file-format.jsp";
    private static final String UPLOAD_ERROR_JSP = "/submit/upload-error.jsp";
    private static final String REVIEW_JSP = "/submit/review-upload.jsp";
    private static Logger log = Logger.getLogger(JSPUploadStep.class);

    @Override
    public void doPreProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        if (subInfo != null) {
            Collection c = subInfo.getSubmissionItem().getCollection();
            try {
                DCInputsReader inputsReader = new DCInputsReader();
                request.setAttribute("submission.inputs", (Object)inputsReader.getInputs(c.getHandle()));
            }
            catch (DCInputsReaderException e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            throw new IllegalStateException("SubInfo must not be null");
        }
        this.showUploadPage(context, request, response, subInfo, false);
    }

    @Override
    public void doPostProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, int status) throws ServletException, IOException, SQLException, AuthorizeException {
        Bitstream bitstream;
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_next");
        boolean fileRequired = ConfigurationManager.getBooleanProperty((String)"webui.submit.upload.required", (boolean)true);
        if (buttonPressed.equalsIgnoreCase("submit_skip") || buttonPressed.equalsIgnoreCase("submit_upload") && !fileRequired) {
            Bundle[] bundles = subInfo.getSubmissionItem().getItem().getBundles("ORIGINAL");
            boolean fileAlreadyUploaded = false;
            for (Bundle bnd : bundles) {
                boolean bl = fileAlreadyUploaded = bnd.getBitstreams().length > 0;
                if (fileAlreadyUploaded) break;
            }
            if (fileAlreadyUploaded) {
                this.showUploadFileList(context, request, response, subInfo, true, false);
            }
            return;
        }
        if (buttonPressed.equalsIgnoreCase("submit_retry")) {
            this.showUploadPage(context, request, response, subInfo, false);
        }
        if (status != 0) {
            if (status == 1) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
                JSPManager.showIntegrityError(request, response);
            } else if (status == 2 || status == 5) {
                if (buttonPressed.startsWith("submit_remove_")) {
                    this.showUploadPage(context, request, response, subInfo, false);
                } else {
                    if (subInfo != null) {
                        try {
                            Collection c = subInfo.getSubmissionItem().getCollection();
                            DCInputsReader inputsReader = new DCInputsReader();
                            request.setAttribute("submission.inputs", (Object)inputsReader.getInputs(c.getHandle()));
                        }
                        catch (DCInputsReaderException e) {
                            throw new ServletException((Throwable)e);
                        }
                    }
                    JSPStepManager.showJSP(request, response, subInfo, UPLOAD_ERROR_JSP);
                }
            } else if (status == 10) {
                this.showGetFileFormat(context, request, response, subInfo);
            }
        }
        if (status == 0 && buttonPressed.equals("submit_next")) {
            return;
        }
        if (buttonPressed.equals("submit_more")) {
            this.showChooseFile(context, request, response, subInfo);
        } else if (buttonPressed.equals("submit_show_checksums")) {
            this.showUploadFileList(context, request, response, subInfo, false, true);
        } else if (buttonPressed.startsWith("submit_describe_")) {
            try {
                int id = Integer.parseInt(buttonPressed.substring(16));
                bitstream = Bitstream.find((Context)context, (int)id);
            }
            catch (NumberFormatException nfe) {
                bitstream = null;
            }
            if (bitstream == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
                JSPManager.showIntegrityError(request, response);
            }
            subInfo.setBitstream(bitstream);
            this.showFileDescription(context, request, response, subInfo);
        } else if (buttonPressed.startsWith("submit_format_")) {
            try {
                int id = Integer.parseInt(buttonPressed.substring(14));
                bitstream = Bitstream.find((Context)context, (int)id);
            }
            catch (NumberFormatException nfe) {
                bitstream = null;
            }
            if (bitstream == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
                JSPManager.showIntegrityError(request, response);
            }
            subInfo.setBitstream(bitstream);
            this.showGetFileFormat(context, request, response, subInfo);
        } else {
            String contentType = request.getContentType();
            boolean fileUpload = false;
            if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
                fileUpload = true;
            }
            this.showUploadPage(context, request, response, subInfo, fileUpload);
        }
    }

    private void showUploadPage(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, boolean justUploaded) throws SQLException, ServletException, IOException {
        Bundle[] bundles = subInfo.getSubmissionItem().getItem().getBundles("ORIGINAL");
        boolean fileAlreadyUploaded = false;
        if (!justUploaded) {
            for (Bundle bnd : bundles) {
                boolean bl = fileAlreadyUploaded = bnd.getBitstreams().length > 0;
                if (fileAlreadyUploaded) break;
            }
        }
        if (justUploaded || fileAlreadyUploaded) {
            this.showUploadFileList(context, request, response, subInfo, justUploaded, false);
        } else {
            this.showChooseFile(context, request, response, subInfo);
        }
    }

    private void showChooseFile(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws SQLException, ServletException, IOException {
        subInfo.setBitstream(null);
        JSPStepManager.showJSP(request, response, subInfo, CHOOSE_FILE_JSP);
    }

    private void showUploadFileList(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, boolean justUploaded, boolean showChecksums) throws SQLException, ServletException, IOException {
        request.setAttribute("just.uploaded", (Object)justUploaded);
        request.setAttribute("show.checksums", (Object)showChecksums);
        if (subInfo.isInWorkflow() || subInfo.getSubmissionItem().hasMultipleFiles()) {
            JSPStepManager.showJSP(request, response, subInfo, UPLOAD_LIST_JSP);
        } else {
            JSPStepManager.showJSP(request, response, subInfo, UPLOAD_FILE_JSP);
        }
    }

    private void showGetFileFormat(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws SQLException, ServletException, IOException {
        if (subInfo == null || subInfo.getBitstream() == null) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
            JSPManager.showIntegrityError(request, response);
        }
        BitstreamFormat[] formats = BitstreamFormat.findNonInternal((Context)context);
        request.setAttribute("bitstream.formats", (Object)formats);
        BitstreamFormat guess = FormatIdentifier.guessFormat((Context)context, (Bitstream)subInfo.getBitstream());
        request.setAttribute("guessed.format", (Object)guess);
        JSPStepManager.showJSP(request, response, subInfo, FILE_FORMAT_JSP);
    }

    private void showFileDescription(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws SQLException, ServletException, IOException {
        JSPStepManager.showJSP(request, response, subInfo, FILE_DESCRIPTION_JSP);
    }

    @Override
    public String getReviewJSP(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) {
        return REVIEW_JSP;
    }
}

