/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.dspace.app.bulkedit.BulkEditChange;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.MetadataImport;
import org.dspace.app.bulkedit.MetadataImportInvalidHeadingException;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.FileUploadRequest;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class MetadataImportServlet
extends DSpaceServlet {
    private int limit;
    private static Logger log = Logger.getLogger(MetadataImportServlet.class);

    public void init() {
        this.limit = ConfigurationManager.getIntProperty((String)"bulkedit", (String)"gui-item-limit", (int)20);
        log.debug((Object)("Setting bulk edit limit to " + this.limit + " items"));
    }

    @Override
    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        block14: {
            String contentType = request.getContentType();
            HttpSession session = request.getSession(true);
            if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
                try {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"metadataimport", (String)"loading file"));
                    List<BulkEditChange> changes = this.processUpload(context, request);
                    log.debug((Object)LogManager.getHeader((Context)context, (String)"metadataimport", (String)(changes.size() + " items with changes identified")));
                    if (changes.size() != 0) {
                        request.setAttribute("changes", changes);
                        request.setAttribute("changed", (Object)false);
                        if (changes.size() <= this.limit) {
                            request.setAttribute("allow", (Object)true);
                        } else {
                            request.setAttribute("allow", (Object)false);
                            session.removeAttribute("csv");
                            log.info((Object)LogManager.getHeader((Context)context, (String)"metadataimport", (String)("too many changes: " + changes.size() + " (" + this.limit + " allowed)")));
                        }
                        JSPManager.showJSP(request, response, "/dspace-admin/metadataimport-showchanges.jsp");
                        break block14;
                    }
                    request.setAttribute("message", (Object)"No changes detected");
                    JSPManager.showJSP(request, response, "/dspace-admin/metadataimport.jsp");
                }
                catch (MetadataImportInvalidHeadingException mihe) {
                    request.setAttribute("message", (Object)mihe.getBadHeader());
                    request.setAttribute("badheading", (Object)mihe.getType());
                    log.info((Object)LogManager.getHeader((Context)context, (String)"metadataimport", (String)("Error encountered while looking for changes: " + mihe.getMessage())));
                    JSPManager.showJSP(request, response, "/dspace-admin/metadataimport-error.jsp");
                }
                catch (Exception e) {
                    request.setAttribute("message", (Object)e.getMessage());
                    log.info((Object)LogManager.getHeader((Context)context, (String)"metadataimport", (String)("Error encountered while looking for changes: " + e.getMessage())));
                    JSPManager.showJSP(request, response, "/dspace-admin/metadataimport-error.jsp");
                }
            } else if ("confirm".equals(request.getParameter("type"))) {
                DSpaceCSV csv = (DSpaceCSV)session.getAttribute("csv");
                try {
                    MetadataImport mImport = new MetadataImport(context, csv);
                    List changes = mImport.runImport(true, false, false, false);
                    context.commit();
                    log.debug((Object)LogManager.getHeader((Context)context, (String)"metadataimport", (String)(changes.size() + " items changed")));
                    session.removeAttribute("csv");
                    request.setAttribute("changes", (Object)changes);
                    request.setAttribute("changed", (Object)true);
                    request.setAttribute("allow", (Object)true);
                    JSPManager.showJSP(request, response, "/dspace-admin/metadataimport-showchanges.jsp");
                }
                catch (Exception e) {
                    request.setAttribute("message", (Object)e.getMessage());
                    log.debug((Object)LogManager.getHeader((Context)context, (String)"metadataimport", (String)("Error encountered while making changes: " + e.getMessage())));
                    JSPManager.showJSP(request, response, "/dspace-admin/metadataimport-error.jsp");
                }
            } else if ("cancel".equals(request.getParameter("type"))) {
                session.removeAttribute("csv");
                request.setAttribute("message", (Object)"Changes cancelled. No items have been modified.");
                log.debug((Object)LogManager.getHeader((Context)context, (String)"metadataimport", (String)"Changes cancelled"));
                JSPManager.showJSP(request, response, "/dspace-admin/metadataimport.jsp");
            } else {
                JSPManager.showJSP(request, response, "/dspace-admin/metadataimport.jsp");
            }
        }
    }

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        JSPManager.showJSP(request, response, "/dspace-admin/metadataimport.jsp");
    }

    private List<BulkEditChange> processUpload(Context context, HttpServletRequest request) throws Exception {
        FileUploadRequest wrapper = new FileUploadRequest(request);
        File f = wrapper.getFile("file");
        DSpaceCSV csv = new DSpaceCSV(f, context);
        MetadataImport mImport = new MetadataImport(context, csv);
        List changes = mImport.runImport(false, false, false, false);
        HttpSession session = request.getSession(true);
        session.setAttribute("csv", (Object)csv);
        if (!f.delete()) {
            log.error((Object)"Unable to delete upload file");
        }
        return changes;
    }
}

