/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.Authenticate;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;

public class PasswordServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(PasswordServlet.class);

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        JSPManager.showJSP(request, response, "/login/password.jsp");
    }

    @Override
    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String email = request.getParameter("login_email");
        String password = request.getParameter("login_password");
        String jsp = null;
        int status = AuthenticationManager.authenticate((Context)context, (String)email, (String)password, null, (HttpServletRequest)request);
        if (status == 1) {
            Authenticate.loggedIn(context, request, context.getCurrentUser());
            Locale epersonLocale = I18nUtil.getEPersonLocale((EPerson)context.getCurrentUser());
            context.setCurrentLocale(epersonLocale);
            Config.set((HttpSession)request.getSession(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)epersonLocale);
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=explicit"));
            Authenticate.resumeInterruptedRequest(request, response);
            return;
        }
        jsp = status == 3 ? "/error/require-certificate.jsp" : "/login/incorrect.jsp";
        log.info((Object)LogManager.getHeader((Context)context, (String)"failed_login", (String)("email=" + email + ", result=" + String.valueOf(status))));
        JSPManager.showJSP(request, response, jsp);
    }
}

