/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.RequestInfo;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;

public class Authenticate {
    private static Logger log = Logger.getLogger(Authenticate.class);

    public static HttpServletRequest getRealRequest(HttpServletRequest request) {
        HttpSession session = request.getSession();
        if (session.getAttribute("resuming.request") != null) {
            RequestInfo requestInfo = (RequestInfo)session.getAttribute("interrupted.request.info");
            HttpServletRequest actualRequest = requestInfo == null ? request : requestInfo.wrapRequest(request);
            session.removeAttribute("resuming.request");
            session.removeAttribute("interrupted.request.info");
            session.removeAttribute("interrupted.request.url");
            return actualRequest;
        }
        return request;
    }

    public static void resumeInterruptedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        String originalURL = (String)session.getAttribute("interrupted.request.url");
        if (originalURL == null) {
            originalURL = request.getContextPath() + "/mydspace";
        } else {
            session.setAttribute("resuming.request", (Object)Boolean.TRUE);
        }
        response.sendRedirect(response.encodeRedirectURL(originalURL));
    }

    public static boolean startAuthentication(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        if (AuthenticationManager.authenticateImplicit((Context)context, null, null, null, (HttpServletRequest)request) == 1) {
            Authenticate.loggedIn(context, request, context.getCurrentUser());
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=implicit"));
            if (context.getCurrentUser() != null) {
                Authenticate.resumeInterruptedRequest(request, response);
                return false;
            }
            return true;
        }
        response.addDateHeader("expires", 1L);
        response.addHeader("Pragma", "no-cache");
        response.addHeader("Cache-control", "no-store");
        RequestInfo info = new RequestInfo(request);
        session.setAttribute("interrupted.request.info", (Object)info);
        session.setAttribute("interrupted.request.url", (Object)UIUtil.getOriginalURL(request));
        Iterator ai = AuthenticationManager.authenticationMethodIterator();
        int count = 0;
        String url = null;
        while (ai.hasNext()) {
            AuthenticationMethod am = (AuthenticationMethod)ai.next();
            String s = am.loginPageURL(context, request, response);
            if (s == null) continue;
            url = s;
            ++count;
        }
        if (count == 1) {
            response.sendRedirect(url);
        } else {
            JSPManager.showJSP(request, response, "/login/chooser.jsp");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loggedIn(Context context, HttpServletRequest request, EPerson eperson) {
        HttpSession session = request.getSession();
        if (!session.isNew() && session.getAttribute("dspace.current.user.id") == null) {
            Locale sessionLocale = UIUtil.getSessionLocale(request);
            RequestInfo requestInfo = (RequestInfo)session.getAttribute("interrupted.request.info");
            String requestUrl = (String)session.getAttribute("interrupted.request.url");
            if (ConfigurationManager.getBooleanProperty((String)"webui.session.invalidate", (boolean)true)) {
                session.invalidate();
            }
            session = request.getSession();
            if (sessionLocale != null) {
                Config.set((HttpSession)request.getSession(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)sessionLocale);
            }
            if (requestInfo != null && requestUrl != null) {
                session.setAttribute("interrupted.request.info", (Object)requestInfo);
                session.setAttribute("interrupted.request.url", (Object)requestUrl);
            }
        }
        context.setCurrentUser(eperson);
        boolean isAdmin = false;
        try {
            isAdmin = AuthorizeManager.isAdmin((Context)context);
        }
        catch (SQLException se) {
            log.warn((Object)("Unable to use AuthorizeManager " + se));
        }
        finally {
            request.setAttribute("is.admin", (Object)isAdmin);
        }
        request.setAttribute("dspace.current.user", (Object)eperson);
        session.setAttribute("dspace.current.user.id", (Object)eperson.getID());
        session.setAttribute("dspace.current.remote.addr", (Object)request.getRemoteAddr());
    }

    public static void loggedOut(Context context, HttpServletRequest request) {
        HttpSession session = request.getSession();
        context.setCurrentUser(null);
        request.removeAttribute("is.admin");
        request.removeAttribute("dspace.current.user");
        session.removeAttribute("dspace.current.user.id");
        Locale sessionLocale = UIUtil.getSessionLocale(request);
        if (ConfigurationManager.getBooleanProperty((String)"webui.session.invalidate", (boolean)true)) {
            session.invalidate();
        }
        if (sessionLocale != null) {
            Config.set((HttpSession)request.getSession(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)sessionLocale);
        }
    }
}

