/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Subscribe;

public class SubscribeServlet
extends DSpaceServlet {
    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.showSubscriptions(context, request, response, false);
    }

    @Override
    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String submit = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        EPerson e = context.getCurrentUser();
        if (submit.equals("submit_clear")) {
            Subscribe.unsubscribe((Context)context, (EPerson)e, null);
            this.showSubscriptions(context, request, response, true);
            context.complete();
        } else if (submit.equals("submit_unsubscribe")) {
            int collID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection");
            Collection c = Collection.find((Context)context, (int)collID);
            if (c != null) {
                Subscribe.unsubscribe((Context)context, (EPerson)e, (Collection)c);
            }
            this.showSubscriptions(context, request, response, true);
            context.complete();
        } else {
            response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/mydspace"));
        }
    }

    private void showSubscriptions(Context context, HttpServletRequest request, HttpServletResponse response, boolean updated) throws ServletException, IOException, SQLException {
        Collection[] subs = Subscribe.getSubscriptions((Context)context, (EPerson)context.getCurrentUser());
        request.setAttribute("subscriptions", (Object)subs);
        request.setAttribute("updated", (Object)updated);
        JSPManager.showJSP(request, response, "/mydspace/subscriptions.jsp");
    }
}

