/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.app.webui.servlet.SubmissionController;
import org.dspace.app.webui.submit.JSPStep;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.submit.AbstractProcessingStep;

public class JSPStepManager {
    private static Logger log = Logger.getLogger(JSPStepManager.class);
    private AbstractProcessingStep stepProcessing = null;
    private JSPStep stepJSPUI = null;
    private SubmissionStepConfig stepConfig = null;

    public static JSPStepManager loadStep(SubmissionStepConfig stepConfig) throws Exception {
        JSPStepManager stepManager = new JSPStepManager();
        stepManager.stepConfig = stepConfig;
        ClassLoader loader = stepManager.getClass().getClassLoader();
        Class<?> stepClass = loader.loadClass(stepConfig.getProcessingClassName());
        Object stepInstance = stepClass.newInstance();
        if (!(stepInstance instanceof AbstractProcessingStep)) {
            throw new Exception("The submission step class specified by '" + stepConfig.getProcessingClassName() + "' does not extend the class org.dspace.submit.AbstractProcessingStep!" + " Therefore it cannot be used by the Configurable Submission as the <processing-class>!");
        }
        stepManager.stepProcessing = (AbstractProcessingStep)stepClass.newInstance();
        if (stepConfig.getJSPUIClassName() != null && stepConfig.getJSPUIClassName().length() > 0) {
            stepClass = loader.loadClass(stepConfig.getJSPUIClassName());
            stepInstance = stepClass.newInstance();
            if (stepInstance instanceof JSPStep) {
                stepManager.stepJSPUI = (JSPStep)stepClass.newInstance();
            } else {
                throw new Exception("The submission step class specified by '" + stepConfig.getJSPUIClassName() + "' does not extend the class org.dspace.app.webui.JSPStep!" + " Therefore it cannot be used by the Configurable Submission for the JSP user interface!");
            }
        }
        return stepManager;
    }

    public final boolean processStep(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        int currentPage = -1;
        if (request.getAttribute("step.backwards") != null && ((Boolean)request.getAttribute("step.backwards")).booleanValue()) {
            currentPage = JSPStepManager.getNumPagesInProgressBar(subInfo, this.stepConfig.getStepNumber());
            AbstractProcessingStep.setCurrentPage((HttpServletRequest)request, (int)currentPage);
        } else {
            currentPage = AbstractProcessingStep.getCurrentPage((HttpServletRequest)request);
        }
        int pageReached = JSPStepManager.getPageReached(subInfo);
        if (pageReached == Integer.MAX_VALUE) {
            int lastPageNum = JSPStepManager.getNumPagesInProgressBar(subInfo, SubmissionController.getStepReached(subInfo));
            this.updatePageReached(subInfo, lastPageNum);
            context.commit();
        } else if (this.stepConfig.getStepNumber() == SubmissionController.getStepReached(subInfo) && currentPage > pageReached) {
            this.updatePageReached(subInfo, currentPage);
            context.commit();
        }
        boolean beginningOfStep = SubmissionController.isBeginningOfStep(request);
        if (beginningOfStep) {
            return this.doStepStart(context, request, response, subInfo);
        }
        return this.doStepEnd(context, request, response, subInfo);
    }

    private boolean doStepStart(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        log.debug((Object)("Doing pre-processing for step " + this.getClass().getName()));
        if (this.stepJSPUI != null) {
            this.stepJSPUI.doPreProcessing(context, request, response, subInfo);
        }
        if (!response.isCommitted()) {
            log.debug((Object)("Calling processing for step " + this.getClass().getName()));
            int errorFlag = this.stepProcessing.doProcessing(context, request, response, subInfo);
            if (errorFlag != 0) {
                String errorMessage = this.stepProcessing.getErrorMessage(errorFlag);
                if (errorMessage == null) {
                    errorMessage = "The doProcessing() method for " + this.getClass().getName() + " returned an error flag = " + errorFlag + ". " + "It is recommended to define a custom error message for this error flag using the addErrorMessage() method!";
                }
                log.error((Object)errorMessage);
            }
            return this.completeStep(context, request, response, subInfo);
        }
        return false;
    }

    public static final void showJSP(HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, String pathToJSP) throws ServletException, IOException, SQLException {
        if (!response.isCommitted() && !SubmissionController.isCancellationInProgress(request)) {
            SubmissionController.setBeginningOfStep(request, false);
            SubmissionController.saveSubmissionInfo(request, subInfo);
            JSPStepManager.setLastJSPDisplayed(request, pathToJSP);
            JSPManager.showJSP(request, response, pathToJSP);
        }
    }

    private boolean doStepEnd(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        log.debug((Object)("Calling processing for step " + this.getClass().getName()));
        int status = this.stepProcessing.doProcessing(context, request, response, subInfo);
        log.debug((Object)("Calling post-processing for step " + this.getClass().getName()));
        this.stepJSPUI.doPostProcessing(context, request, response, subInfo, status);
        int currentPage = AbstractProcessingStep.getCurrentPage((HttpServletRequest)request);
        if (!response.isCommitted()) {
            if (!this.hasMorePages(request, subInfo, currentPage)) {
                return this.completeStep(context, request, response, subInfo);
            }
            AbstractProcessingStep.setCurrentPage((HttpServletRequest)request, (int)(currentPage + 1));
            SubmissionController.setBeginningOfStep(request, true);
            return this.processStep(context, request, response, subInfo);
        }
        return false;
    }

    protected final boolean completeStep(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        log.debug((Object)("Completing Step " + this.getClass().getName()));
        if (!response.isCommitted()) {
            SubmissionController.saveSubmissionInfo(request, subInfo);
            SubmissionController.saveCurrentStepConfig(request, this.stepConfig);
            AbstractProcessingStep.setCurrentPage((HttpServletRequest)request, (int)1);
            return true;
        }
        return false;
    }

    protected final boolean hasMorePages(HttpServletRequest request, SubmissionInfo subInfo, int pageNumber) throws ServletException {
        int numberOfPages = this.stepProcessing.getNumberOfPages(request, subInfo);
        return pageNumber < numberOfPages;
    }

    public static final int getPageReached(SubmissionInfo subInfo) {
        if (subInfo.isInWorkflow() || subInfo.getSubmissionItem() == null) {
            return -1;
        }
        WorkspaceItem wi = (WorkspaceItem)subInfo.getSubmissionItem();
        int i = wi.getPageReached();
        return i;
    }

    private void updatePageReached(SubmissionInfo subInfo, int page) throws SQLException, AuthorizeException, IOException {
        WorkspaceItem wi;
        if (!subInfo.isInWorkflow() && subInfo.getSubmissionItem() != null && page > (wi = (WorkspaceItem)subInfo.getSubmissionItem()).getPageReached()) {
            wi.setPageReached(page);
            wi.update();
        }
    }

    private static int getNumPagesInProgressBar(SubmissionInfo subInfo, int stepNum) {
        Iterator keyIterator = subInfo.getProgressBarInfo().keySet().iterator();
        int lastPage = 1;
        while (keyIterator.hasNext()) {
            String[] fields;
            int page;
            String stepAndPage = (String)keyIterator.next();
            if (!stepAndPage.startsWith(stepNum + ".") || (page = Integer.parseInt((fields = stepAndPage.split("\\."))[1])) <= lastPage) continue;
            lastPage = page;
        }
        return lastPage;
    }

    public static final String getLastJSPDisplayed(HttpServletRequest request) {
        String jspDisplayed = (String)request.getAttribute("jsp");
        if (jspDisplayed == null || jspDisplayed.length() == 0) {
            jspDisplayed = request.getParameter("jsp") == null ? "" : request.getParameter("jsp");
        }
        return jspDisplayed;
    }

    private static final void setLastJSPDisplayed(HttpServletRequest request, String pathToJSP) {
        request.setAttribute("jsp", (Object)pathToJSP);
    }

    public String getReviewJSP(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) {
        return this.stepJSPUI.getReviewJSP(context, request, response, subInfo);
    }
}

