/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.app.webui.servlet.SubmissionController;
import org.dspace.app.webui.submit.JSPStep;
import org.dspace.app.webui.submit.JSPStepManager;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.LicenseUtils;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;

public class JSPLicenseStep
extends JSPStep {
    private static final String LICENSE_JSP = "/submit/show-license.jsp";
    private static final String CC_LICENSE_JSP = "/submit/creative-commons.jsp";
    private static final String LICENSE_REJECT_JSP = "/submit/license-rejected.jsp";
    private static Logger log = Logger.getLogger(JSPLicenseStep.class);

    @Override
    public void doPreProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        String license = LicenseUtils.getLicenseText((Locale)context.getCurrentLocale(), (Collection)subInfo.getSubmissionItem().getCollection(), (Item)subInfo.getSubmissionItem().getItem(), (EPerson)subInfo.getSubmissionItem().getSubmitter());
        request.setAttribute("license", (Object)license);
        JSPStepManager.showJSP(request, response, subInfo, LICENSE_JSP);
    }

    @Override
    public void doPostProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, int status) throws ServletException, IOException, SQLException, AuthorizeException {
        String buttonPressed = Util.getSubmitButton((HttpServletRequest)request, (String)"submit_cancel");
        if (buttonPressed.equals("submit_reject")) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"reject_license", (String)subInfo.getSubmissionLogInfo()));
            if (!subInfo.isInWorkflow() && SubmissionController.getStepReached(subInfo) <= 1) {
                WorkspaceItem wi = (WorkspaceItem)subInfo.getSubmissionItem();
                wi.deleteAll();
                context.commit();
            }
            JSPManager.showJSP(request, response, LICENSE_REJECT_JSP);
        }
    }

    @Override
    public String getReviewJSP(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) {
        return "";
    }
}

