<%--
  - confirm-delete-mdschema.jsp
  -
  - Version: $Revision: 3206 $
  -
  - Date: $Date: 2008-10-15 23:44:42 -0700 (Wed, 15 Oct 2008) $
  -
  - Copyright (c) 2002, Hewlett-Packard Company and Massachusetts
  - Institute of Technology.  All rights reserved.
  -
  - Redistribution and use in source and binary forms, with or without
  - modification, are permitted provided that the following conditions are
  - met:
  -
  - - Redistributions of source code must retain the above copyright
  - notice, this list of conditions and the following disclaimer.
  -
  - - Redistributions in binary form must reproduce the above copyright
  - notice, this list of conditions and the following disclaimer in the
  - documentation and/or other materials provided with the distribution.
  -
  - - Neither the name of the Hewlett-Packard Company nor the name of the
  - Massachusetts Institute of Technology nor the names of their
  - contributors may be used to endorse or promote products derived from
  - this software without specific prior written permission.
  -
  - THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  - ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  - LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  - A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  - HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  - INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
  - BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  - OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  - ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
  - TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
  - USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
  - DAMAGE.
  --%>

<%--
  - Confirm deletion of a DC schema
  -
  - Attributes:
  -    schema   - schema we may delete
  --%>

<%@ page contentType="text/html;charset=UTF-8" %>

<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt"
    prefix="fmt" %>

<%@ page import="org.dspace.content.MetadataSchema" %>

<%@ taglib uri="http://www.dspace.org/dspace-tags.tld" prefix="dspace" %>

<%
    MetadataSchema schema = (MetadataSchema) request.getAttribute("schema");
%>

<dspace:layout titlekey="jsp.dspace-admin.confirm-delete-dcschema.title"
               navbar="admin"
               locbar="link"
               parenttitlekey="jsp.administer"
               parentlink="/dspace-admin">

    <%-- <H1>Delete Dublin Core Schema</H1> --%>
    <H1><fmt:message key="jsp.dspace-admin.confirm-delete-mdschema.heading">
        <fmt:param><%= schema.getName() %></fmt:param>
    </fmt:message></H1>
    
    <%-- <P>Are you sure the schema <strong><%= schema.getNamespace() %></strong>
    should be deleted?</P> --%> 
    <P><fmt:message key="jsp.dspace-admin.confirm-delete-mdschema.confirm">
        <fmt:param><%= schema.getName() %></fmt:param>
    </fmt:message></P>
    
    <%-- <P>This will result in an error if any metadata fields exist within this schema.</P>  --%>
    <P><fmt:message key="jsp.dspace-admin.confirm-delete-mdschema.warning"/></P>

    <form method="post">
        <input type="hidden" name="dc_schema_id" value="<%= schema.getSchemaID() %>">

        <center>
            <table width="70%">
                <tr>
                    <td align="left">
                        <%-- <input type="submit" name="submit_confirm_delete" value="Delete"> --%>
                        <input type="submit" name="submit_confirm_delete" value="<fmt:message key="jsp.dspace-admin.general.delete"/>">
                        <%-- <input type="submit" name="submit_cancel" value="Cancel">  --%>
                        <input type="submit" name="submit_cancel" value="<fmt:message key="jsp.dspace-admin.general.cancel"/>">
                    </td>
                </tr>
            </table>
        </center>
    </form>
</dspace:layout>
