/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemAuthorExtractor;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.RequestItemManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.handle.HandleManager;
import org.dspace.storage.bitstore.BitstreamStorageManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.utils.DSpace;

public class RequestItemServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(RequestItemServlet.class);
    public static final int ENTER_FORM_PAGE = 1;
    public static final int ENTER_TOKEN = 2;
    public static final int APROVE_TOKEN = 3;
    public static final int RESUME_REQUEST = 4;
    public static final int RESUME_FREEACESS = 5;

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int step = UIUtil.getIntParameter((HttpServletRequest)request, (String)"step");
        try {
            switch (step) {
                case 1: {
                    this.processForm(context, request, response);
                    break;
                }
                case 2: {
                    this.processToken(context, request, response);
                    break;
                }
                case 3: {
                    this.processLetter(context, request, response);
                    break;
                }
                case 4: {
                    this.processAttach(context, request, response);
                    break;
                }
                case 5: {
                    this.processAdmin(context, request, response);
                    break;
                }
                default: {
                    this.processForm(context, request, response);
                }
            }
            context.complete();
        }
        catch (MessagingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSGet(context, request, response);
    }

    private void processForm(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        Metadatum[] titleDC;
        boolean showRequestCopy = false;
        if ("all".equalsIgnoreCase(ConfigurationManager.getProperty((String)"request.item.type")) || "logged".equalsIgnoreCase(ConfigurationManager.getProperty((String)"request.item.type")) && context.getCurrentUser() != null) {
            showRequestCopy = true;
        }
        if (!showRequestCopy) {
            throw new AuthorizeException("The request copy feature is disabled");
        }
        String handle = request.getParameter("handle");
        String bitstream_id = request.getParameter("bitstream-id");
        String title = null;
        Item item = null;
        if (StringUtils.isNotBlank((String)handle)) {
            item = (Item)HandleManager.resolveToObject((Context)context, (String)handle);
        }
        if (item == null) {
            JSPManager.showInvalidIDError(request, response, handle, -1);
        }
        title = (titleDC = item.getDC("title", null, "*")) != null || titleDC.length > 0 ? titleDC[0].value : I18nUtil.getMessage((String)"jsp.general.untitled", (Context)context);
        String requesterEmail = request.getParameter("email");
        EPerson currentUser = context.getCurrentUser();
        String userName = null;
        if (currentUser != null) {
            requesterEmail = currentUser.getEmail();
            userName = currentUser.getFullName();
        }
        if (request.getParameter("submit") != null) {
            String reqname = request.getParameter("reqname");
            String coment = request.getParameter("coment");
            if (coment == null || coment.equals("")) {
                coment = "";
            }
            boolean allfiles = "true".equals(request.getParameter("allfiles"));
            if (requesterEmail == null || requesterEmail.equals("") || reqname == null || reqname.equals("")) {
                request.setAttribute("handle", (Object)handle);
                request.setAttribute("bitstream-id", (Object)bitstream_id);
                request.setAttribute("reqname", (Object)reqname);
                request.setAttribute("email", (Object)requesterEmail);
                request.setAttribute("coment", (Object)coment);
                request.setAttribute("title", (Object)title);
                request.setAttribute("allfiles", (Object)(allfiles ? "true" : null));
                request.setAttribute("requestItem.problem", (Object)new Boolean(true));
                JSPManager.showJSP(request, response, "/requestItem/request-form.jsp");
                return;
            }
            try {
                Email email = Email.getEmail((String)I18nUtil.getEmailFilename((Locale)context.getCurrentLocale(), (String)"request_item.author"));
                RequestItemAuthor author = ((RequestItemAuthorExtractor)new DSpace().getServiceManager().getServiceByName(RequestItemAuthorExtractor.class.getName(), RequestItemAuthorExtractor.class)).getRequestItemAuthor(context, item);
                String authorEmail = author.getEmail();
                String authorName = author.getFullName();
                email.addRecipient(authorEmail);
                email.addArgument((Object)reqname);
                email.addArgument((Object)requesterEmail);
                email.addArgument((Object)(allfiles ? I18nUtil.getMessage((String)"itemRequest.all") : Bitstream.find((Context)context, (int)Integer.parseInt(bitstream_id)).getName()));
                email.addArgument((Object)HandleManager.getCanonicalForm((String)item.getHandle()));
                email.addArgument((Object)title);
                email.addArgument((Object)coment);
                email.addArgument((Object)RequestItemManager.getLinkTokenEmail(context, bitstream_id, item.getID(), requesterEmail, reqname, allfiles));
                email.addArgument((Object)authorName);
                email.addArgument((Object)authorEmail);
                email.addArgument((Object)ConfigurationManager.getProperty((String)"dspace.name"));
                email.addArgument((Object)ConfigurationManager.getProperty((String)"mail.helpdesk"));
                email.setReplyTo(requesterEmail);
                email.send();
                log.info((Object)LogManager.getHeader((Context)context, (String)"sent_email_requestItem", (String)("submitter_id=" + requesterEmail + ",bitstream_id=" + bitstream_id + ",requestEmail=" + requesterEmail)));
                request.setAttribute("handle", (Object)handle);
                JSPManager.showJSP(request, response, "/requestItem/request-send.jsp");
            }
            catch (MessagingException me) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"error_mailing_requestItem", (String)""), (Throwable)me);
                JSPManager.showInternalError(request, response);
            }
        } else {
            log.info((Object)LogManager.getHeader((Context)context, (String)"show_requestItem_form", (String)"problem=false"));
            request.setAttribute("handle", (Object)handle);
            request.setAttribute("bitstream-id", (Object)bitstream_id);
            request.setAttribute("email", (Object)requesterEmail);
            request.setAttribute("reqname", (Object)userName);
            request.setAttribute("title", (Object)title);
            request.setAttribute("allfiles", (Object)"true");
            JSPManager.showJSP(request, response, "/requestItem/request-form.jsp");
        }
    }

    private void processToken(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String token = request.getParameter("token");
        TableRow requestItem = RequestItemManager.getRequestbyToken(context, token);
        if (requestItem != null) {
            Metadatum[] titleDC;
            Item item = Item.find((Context)context, (int)requestItem.getIntColumn("item_id"));
            String title = "";
            if (item != null && ((titleDC = item.getDC("title", null, "*")) != null || titleDC.length > 0)) {
                title = titleDC[0].value;
            }
            request.setAttribute("request-name", (Object)requestItem.getStringColumn("request_name"));
            request.setAttribute("handle", (Object)item.getHandle());
            request.setAttribute("title", (Object)title);
            JSPManager.showJSP(request, response, "/requestItem/request-information.jsp");
        } else {
            JSPManager.showInvalidIDError(request, response, token, -1);
        }
    }

    private void processLetter(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException, MessagingException {
        String token = request.getParameter("token");
        boolean yes = request.getParameter("submit_yes") != null;
        boolean no = request.getParameter("submit_no") != null;
        TableRow requestItem = RequestItemManager.getRequestbyToken(context, token);
        if (requestItem != null && (yes || no)) {
            Item item = Item.find((Context)context, (int)requestItem.getIntColumn("item_id"));
            Metadatum[] titleDC = item.getDC("title", null, "*");
            String title = titleDC.length > 0 ? titleDC[0].value : I18nUtil.getMessage((String)"jsp.general.untitled", (Context)context);
            EPerson submiter = item.getSubmitter();
            Object[] args = new String[]{requestItem.getStringColumn("request_name"), HandleManager.getCanonicalForm((String)item.getHandle()), title, submiter.getFullName(), submiter.getEmail()};
            String subject = I18nUtil.getMessage((String)("itemRequest.response.subject." + (yes ? "approve" : "reject")), (Context)context);
            String message = MessageFormat.format(I18nUtil.getMessage((String)("itemRequest.response.body." + (yes ? "approve" : "reject")), (Context)context), args);
            request.setAttribute("response", (Object)yes);
            request.setAttribute("subject", (Object)subject);
            request.setAttribute("message", (Object)message);
            JSPManager.showJSP(request, response, "/requestItem/request-letter.jsp");
        } else {
            JSPManager.showInvalidIDError(request, response, token, -1);
        }
    }

    private void processAttach(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        boolean submit_next;
        String token = request.getParameter("token");
        boolean bl = submit_next = request.getParameter("submit_next") != null;
        if (submit_next) {
            TableRow requestItem = RequestItemManager.getRequestbyToken(context, token);
            if (requestItem != null) {
                String subject = request.getParameter("subject");
                String message = request.getParameter("message");
                boolean accept = UIUtil.getBoolParameter((HttpServletRequest)request, (String)"accept_request");
                try {
                    Item item = Item.find((Context)context, (int)requestItem.getIntColumn("item_id"));
                    Email email = new Email();
                    email.setSubject(subject);
                    email.setContent("{0}");
                    email.addRecipient(requestItem.getStringColumn("request_email"));
                    email.addArgument((Object)message);
                    if (accept) {
                        if (requestItem.getBooleanColumn("allfiles")) {
                            Bundle[] bundles = item.getBundles("ORIGINAL");
                            for (int i = 0; i < bundles.length; ++i) {
                                Bitstream[] bitstreams = bundles[i].getBitstreams();
                                for (int k = 0; k < bitstreams.length; ++k) {
                                    if (bitstreams[k].getFormat().isInternal() || !RequestItemManager.isRestricted(context, (DSpaceObject)bitstreams[k])) continue;
                                    email.addAttachment(BitstreamStorageManager.retrieve((Context)context, (int)bitstreams[k].getID()), bitstreams[k].getName(), bitstreams[k].getFormat().getMIMEType());
                                }
                            }
                        } else {
                            Bitstream bit = Bitstream.find((Context)context, (int)requestItem.getIntColumn("bitstream_id"));
                            email.addAttachment(BitstreamStorageManager.retrieve((Context)context, (int)requestItem.getIntColumn("bitstream_id")), bit.getName(), bit.getFormat().getMIMEType());
                        }
                    }
                    email.send();
                    requestItem.setColumn("accept_request", accept);
                    requestItem.setColumn("decision_date", new Date());
                    DatabaseManager.update((Context)context, (TableRow)requestItem);
                    log.info((Object)LogManager.getHeader((Context)context, (String)"sent_attach_requestItem", (String)("token=" + token)));
                    JSPManager.showJSP(request, response, "/requestItem/request-free-access.jsp");
                }
                catch (MessagingException me) {
                    log.warn((Object)LogManager.getHeader((Context)context, (String)"error_mailing_requestItem", (String)""), (Throwable)me);
                    JSPManager.showInternalError(request, response);
                }
            } else {
                JSPManager.showInvalidIDError(request, response, null, -1);
            }
        } else {
            this.processToken(context, request, response);
        }
    }

    private void processAdmin(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String token = request.getParameter("token");
        boolean free = request.getParameter("submit_free") != null;
        String name = request.getParameter("name");
        String mail = request.getParameter("email");
        TableRow requestItem = RequestItemManager.getRequestbyToken(context, token);
        if (requestItem != null && free) {
            try {
                Item item = Item.find((Context)context, (int)requestItem.getIntColumn("item_id"));
                EPerson submiter = item.getSubmitter();
                String emailRequest = submiter != null ? submiter.getEmail() : ConfigurationManager.getProperty((String)"mail.helpdesk");
                if (emailRequest == null) {
                    emailRequest = ConfigurationManager.getProperty((String)"mail.admin");
                }
                Email email = Email.getEmail((String)I18nUtil.getEmailFilename((Locale)context.getCurrentLocale(), (String)"request_item.admin"));
                email.addRecipient(emailRequest);
                email.addArgument((Object)Bitstream.find((Context)context, (int)requestItem.getIntColumn("bitstream_id")).getName());
                email.addArgument((Object)HandleManager.getCanonicalForm((String)item.getHandle()));
                email.addArgument((Object)requestItem.getStringColumn("token"));
                email.addArgument((Object)name);
                email.addArgument((Object)mail);
                email.send();
                log.info((Object)LogManager.getHeader((Context)context, (String)"sent_adm_requestItem", (String)("token=" + requestItem.getStringColumn("token") + "item_id=" + item.getID())));
                JSPManager.showJSP(request, response, "/requestItem/response-send.jsp");
            }
            catch (MessagingException me) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"error_mailing_requestItem", (String)""), (Throwable)me);
                JSPManager.showInternalError(request, response);
            }
        } else {
            JSPManager.showInvalidIDError(request, response, token, -1);
        }
    }
}

