/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.CurateTaskResult;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.curate.Curator;
import org.dspace.handle.HandleManager;

public class CurateServlet
extends DSpaceServlet {
    private static final String TASK_QUEUE_NAME = ConfigurationManager.getProperty((String)"curate", (String)"ui.queuename");
    private static final Map<String, String> statusMessages = new HashMap<String, String>();
    private static Map<String, String> allTasks = new LinkedHashMap<String, String>();
    private static Map<String, String> taskGroups = new LinkedHashMap<String, String>();
    private static Map<String, String[]> groupedTasks = new LinkedHashMap<String, String[]>();
    private static Logger log;

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSPost(context, request, response);
    }

    @Override
    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        if ("submit".equals(button)) {
            button = request.getParameter("community_id") != null ? "submit_community_select" : (request.getParameter("collection_id") != null ? "submit_collection_select" : (request.getParameter("item_id") != null ? "submit_item_select" : "submit_main_select"));
        }
        if (button.startsWith("submit_community_")) {
            Community community = Community.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"community_id"));
            request.setAttribute("community", (Object)community);
            if (!AuthorizeManager.isAdmin((Context)context, (DSpaceObject)community)) {
                throw new AuthorizeException("Only community admins are allowed to perform curation tasks");
            }
            if ("submit_community_curate".equals(button)) {
                this.processCurateObject(context, request, community.getHandle());
            } else if ("submit_community_queue".equals(button)) {
                this.processQueueObject(context, request, community.getHandle());
            }
            this.showPage(request, response, "/tools/curate-community.jsp");
        } else if (button.startsWith("submit_collection_")) {
            Collection collection = Collection.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"collection_id"));
            request.setAttribute("collection", (Object)collection);
            if (!AuthorizeManager.isAdmin((Context)context, (DSpaceObject)collection)) {
                throw new AuthorizeException("Only collection admins are allowed to perform curation tasks");
            }
            if ("submit_collection_curate".equals(button)) {
                this.processCurateObject(context, request, collection.getHandle());
            } else if ("submit_collection_queue".equals(button)) {
                this.processQueueObject(context, request, collection.getHandle());
            }
            this.showPage(request, response, "/tools/curate-collection.jsp");
        } else if (button.startsWith("submit_item_")) {
            Item item = Item.find((Context)context, (int)UIUtil.getIntParameter((HttpServletRequest)request, (String)"item_id"));
            request.setAttribute("item", (Object)item);
            if (!AuthorizeManager.isAdmin((Context)context, (DSpaceObject)item)) {
                throw new AuthorizeException("Only item admins are allowed to perform curation tasks");
            }
            if ("submit_item_curate".equals(button)) {
                this.processCurateObject(context, request, item.getHandle());
            } else if ("submit_item_queue".equals(button)) {
                this.processQueueObject(context, request, item.getHandle());
            }
            this.showPage(request, response, "/tools/curate-item.jsp");
        } else if (button.startsWith("submit_main_")) {
            String handle = request.getParameter("handle");
            if (handle != null) {
                if (handle.endsWith("/0")) {
                    if (!AuthorizeManager.isAdmin((Context)context)) {
                        throw new AuthorizeException("Only system admins are allowed to perform curation tasks over the site");
                    }
                } else {
                    DSpaceObject dso = HandleManager.resolveToObject((Context)context, (String)handle);
                    if (!AuthorizeManager.isAdmin((Context)context, (DSpaceObject)dso)) {
                        throw new AuthorizeException("Only object (hdl:" + handle + ") admins are allowed to perform curation tasks");
                    }
                }
                if ("submit_main_curate".equals(button)) {
                    this.processCurateObject(context, request, handle);
                } else if ("submit_main_queue".equals(button)) {
                    this.processQueueObject(context, request, handle);
                } else if ("submit_main_cancel".equals(button)) {
                    handle = null;
                }
                request.setAttribute("handle", (Object)handle);
            }
            this.showPage(request, response, "/dspace-admin/curate-main.jsp");
        } else {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo(request)));
            JSPManager.showIntegrityError(request, response);
        }
    }

    private void showPage(HttpServletRequest request, HttpServletResponse response, String page) throws ServletException, IOException, SQLException, AuthorizeException {
        String group = request.getParameter("select_curate_group");
        String groupOptions = this.getGroupSelectOptions(group);
        String taskOptions = CurateServlet.getTaskSelectOptions(group);
        request.setAttribute("curate_group_options", (Object)groupOptions);
        request.setAttribute("curate_task_options", (Object)taskOptions);
        JSPManager.showJSP(request, response, page);
    }

    private void processCurateObject(Context context, HttpServletRequest request, String handle) {
        String task = request.getParameter("curate_task");
        Curator curator = this.getCurator(task);
        boolean success = false;
        try {
            curator.curate(context, handle);
            success = true;
        }
        catch (Exception e) {
            curator.setResult(task, e.getMessage());
        }
        request.setAttribute("task_result", (Object)this.getCurateMessage(context, curator, task, handle, success));
    }

    private void processQueueObject(Context context, HttpServletRequest request, String handle) {
        String task = request.getParameter("curate_task");
        Curator curator = this.getCurator(task);
        boolean success = false;
        try {
            curator.queue(context, handle, TASK_QUEUE_NAME);
            success = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        request.setAttribute("task_result", (Object)new CurateTaskResult("queue", this.getTaskName(task), handle, null, null, success));
    }

    private CurateTaskResult getCurateMessage(Context context, Curator curator, String task, String handle, boolean success) {
        String result;
        String status = statusMessages.get(String.valueOf(curator.getStatus(task)));
        if (status == null) {
            status = statusMessages.get("other");
        }
        if ((result = curator.getResult(task)) == null) {
            result = I18nUtil.getMessage((String)"org.dspace.app.webui.servlet.admin.CurationServlet.null-result", (Context)context);
        }
        return new CurateTaskResult("perform", this.getTaskName(task), handle, status, result, success);
    }

    private Curator getCurator(String task) {
        if (task != null && task.length() == 0) {
            task = null;
        }
        Curator curator = new Curator();
        curator.addTask(task);
        curator.setInvoked(Curator.Invoked.INTERACTIVE);
        return curator;
    }

    private static void setStatusMessages() throws UnsupportedEncodingException {
        String statusCodes = ConfigurationManager.getProperty((String)"curate", (String)"ui.statusmessages");
        for (String property : statusCodes.split(",")) {
            String[] keyValuePair = property.split("=");
            statusMessages.put(URLDecoder.decode(keyValuePair[0].trim(), "UTF-8"), URLDecoder.decode(keyValuePair[1].trim(), "UTF-8"));
        }
    }

    private static void setAllTasks() throws UnsupportedEncodingException {
        String properties = ConfigurationManager.getProperty((String)"curate", (String)"ui.tasknames");
        for (String property : properties.split(",")) {
            String[] keyValuePair = property.split("=");
            allTasks.put(URLDecoder.decode(keyValuePair[0].trim(), "UTF-8"), URLDecoder.decode(keyValuePair[1].trim(), "UTF-8"));
        }
    }

    private static void setTaskGroups() throws UnsupportedEncodingException {
        String groups = ConfigurationManager.getProperty((String)"curate", (String)"ui.taskgroups");
        if (groups != null) {
            for (String property : groups.split(",")) {
                String[] keyValuePair = property.split("=");
                taskGroups.put(URLDecoder.decode(keyValuePair[0].trim(), "UTF-8"), URLDecoder.decode(keyValuePair[1].trim(), "UTF-8"));
            }
        }
    }

    private static void setGroupedTasks() throws UnsupportedEncodingException {
        if (!taskGroups.isEmpty()) {
            for (String groupID : taskGroups.keySet()) {
                String memberList = ConfigurationManager.getProperty((String)"curate", (String)("ui.taskgroup." + groupID));
                String[] members = memberList.split(",");
                groupedTasks.put(URLDecoder.decode(groupID, "UTF-8"), members);
            }
        }
    }

    private String getGroupSelectOptions(String group) {
        StringBuilder sb = new StringBuilder();
        for (String groupID : taskGroups.keySet()) {
            sb.append("<option");
            if (groupID.equals(group)) {
                sb.append(" selected=\"selected\"");
            }
            sb.append(" value=\"").append(groupID).append("\">").append(taskGroups.get(groupID)).append("</option>\n");
        }
        return sb.toString();
    }

    private static String getTaskSelectOptions(String group) {
        StringBuilder sb;
        block5: {
            String[] members;
            block4: {
                sb = new StringBuilder();
                if (!groupedTasks.isEmpty()) break block4;
                for (String task : allTasks.keySet()) {
                    sb.append("<option value=\"").append(task).append("\">").append(allTasks.get(task)).append("</option>\n");
                }
                break block5;
            }
            if (group == null || "".equals(group)) {
                group = groupedTasks.keySet().iterator().next();
            }
            if ((members = groupedTasks.get(group)) == null || members.length <= 0) break block5;
            for (String member : members) {
                Iterator<String> innerIterator = allTasks.keySet().iterator();
                while (innerIterator.hasNext()) {
                    String taskID = innerIterator.next().trim();
                    if (!taskID.equals(member.trim())) continue;
                    sb.append("<option value=\"").append(taskID).append("\">").append(allTasks.get(taskID)).append("</option>\n");
                }
            }
        }
        return sb.toString();
    }

    private String getTaskName(String taskID) {
        return allTasks.containsKey(taskID) ? allTasks.get(taskID) : taskID;
    }

    static {
        try {
            CurateServlet.setStatusMessages();
            CurateServlet.setAllTasks();
            CurateServlet.setTaskGroups();
            CurateServlet.setGroupedTasks();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log = Logger.getLogger(CurateServlet.class);
    }
}

