/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.tagcloud;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.discovery.DiscoverUtility;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.TagCloudConfiguration;
import org.dspace.plugin.CollectionHomeProcessor;
import org.dspace.plugin.CommunityHomeProcessor;
import org.dspace.plugin.PluginException;
import org.dspace.plugin.SiteHomeProcessor;

public class TagCloudProcessor
implements CollectionHomeProcessor,
CommunityHomeProcessor,
SiteHomeProcessor {
    private static Logger log = Logger.getLogger(TagCloudProcessor.class);

    public void process(Context context, HttpServletRequest request, HttpServletResponse response) throws PluginException, AuthorizeException {
        this.process(context, request, response, (DSpaceObject)null);
    }

    public void process(Context context, HttpServletRequest request, HttpServletResponse response, Community community) throws PluginException, AuthorizeException {
        this.process(context, request, response, (DSpaceObject)community);
    }

    public void process(Context context, HttpServletRequest request, HttpServletResponse response, Collection collection) throws PluginException, AuthorizeException {
        this.process(context, request, response, (DSpaceObject)collection);
    }

    private void process(Context context, HttpServletRequest request, HttpServletResponse response, DSpaceObject scope) {
        DiscoverQuery queryArgs = DiscoverUtility.getTagCloudDiscoverQuery(context, request, scope, true);
        queryArgs.setMaxResults(0);
        try {
            DiscoverResult qResults = SearchUtils.getSearchService().search(context, scope, queryArgs);
            request.setAttribute("tagcloud.fresults", (Object)qResults.getFacetResults());
            DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)scope);
            List availableFacet = discoveryConfiguration.getTagCloudFacetConfiguration().getTagCloudFacets();
            request.setAttribute("tagCloudFacetsConfig", (Object)(availableFacet != null ? availableFacet : new ArrayList()));
            TagCloudConfiguration tagCloudConfiguration = discoveryConfiguration.getTagCloudFacetConfiguration().getTagCloudConfiguration();
            request.setAttribute("tagCloudConfig", (Object)tagCloudConfiguration);
            if (scope != null) {
                request.setAttribute("tagcloud.searchScope", (Object)("/handle/" + scope.getHandle()));
            }
        }
        catch (SearchServiceException e) {
            log.error((Object)LogManager.getHeader((Context)context, (String)"tagcloud-process", (String)("scope=" + scope)));
        }
    }
}

