/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.ResourcePolicy;

public class PoliciesListTag
extends TagSupport {
    private static Logger log = Logger.getLogger(PoliciesListTag.class);
    private transient List<ResourcePolicy> policies = null;
    private transient boolean showButton = true;

    public int doStartTag() throws JspException {
        String label_name = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.policies-list.label_name");
        String label_action = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.policies-list.label_action");
        String label_group = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.policies-list.label_group");
        String label_sdate = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.policies-list.label_sdate");
        String label_edate = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.policies-list.label_edate");
        String label_emptypolicies = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.policies-list.no_policies");
        JspWriter out = this.pageContext.getOut();
        StringBuffer sb = new StringBuffer();
        try {
            if (this.policies != null && this.policies.size() > 0) {
                sb.append("<div class=\"table-responsive\">\n");
                sb.append("<table class=\"table\">\n");
                sb.append("<tr>\n");
                sb.append("<th class=\"accessHeadOdd\">").append(label_name).append("</th>\n");
                sb.append("<th class=\"accessHeadEven\">").append(label_action).append("</th>\n");
                sb.append("<th class=\"accessHeadOdd\">").append(label_group).append("</th>\n");
                sb.append("<th class=\"accessHeadEven\">").append(label_sdate).append("</th>\n");
                sb.append("<th class=\"accessHeadOdd\">").append(label_edate).append("</th>\n");
                if (this.showButton) {
                    sb.append("<th class=\"accessButton\">&nbsp;</th>\n");
                }
                sb.append("</tr>\n");
                String column1 = "Even";
                String column2 = "Odd";
                for (ResourcePolicy policy : this.policies) {
                    column1 = column1.equals("Even") ? "Odd" : "Even";
                    column2 = column2.equals("Even") ? "Odd" : "Even";
                    String rpName = policy.getRpName() == null ? "" : policy.getRpName();
                    String startDate = policy.getStartDate() == null ? "" : DateFormatUtils.format((Date)policy.getStartDate(), (String)"yyyy-MM-dd");
                    String endDate = policy.getEndDate() == null ? "" : DateFormatUtils.format((Date)policy.getEndDate(), (String)"yyyy-MM-dd");
                    sb.append("<tr>\n");
                    sb.append("<td class=\"access").append(column1).append("\">").append(rpName).append("</td>\n");
                    sb.append("<td class=\"access").append(column2).append("\">").append(policy.getActionText()).append("</td>\n");
                    sb.append("<td class=\"access").append(column1).append("\">").append(policy.getGroup().getName()).append("</td>\n");
                    sb.append("<td class=\"access").append(column2).append("\">").append(startDate).append("</td>\n");
                    sb.append("<td class=\"access").append(column1).append("\">").append(endDate).append("</td>\n");
                    if (this.showButton) {
                        sb.append("<td class=\"accessButton\">\n");
                        sb.append("<input class=\"btn btn-default\" name=\"submit_edit_edit_policies_").append(policy.getID()).append("\" type=\"submit\" value=\"Edit\" /> <input class=\"btn btn-danger\" name=\"submit_delete_edit_policies_").append(policy.getID()).append("\" type=\"submit\" value=\"Remove\" />\n");
                        sb.append("</td>\n");
                    }
                    sb.append("</tr>\n");
                }
                sb.append("</table>\n");
                sb.append("</div>\n");
            } else {
                sb.append("<div class=\"alert alert-warning\">").append(label_emptypolicies).append("</div>").append("\n");
            }
            out.println(sb.toString());
        }
        catch (IOException ie) {
            throw new JspException((Throwable)ie);
        }
        catch (SQLException e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    public List<ResourcePolicy> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<ResourcePolicy> policies) {
        this.policies = policies;
    }

    public void release() {
        this.policies = null;
    }

    public boolean isShowButton() {
        return this.showButton;
    }

    public void setShowButton(boolean showButton) {
        this.showButton = showButton;
    }
}

