/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.components.StatisticsBean;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.handle.HandleManager;
import org.dspace.statistics.Dataset;
import org.dspace.statistics.content.DatasetDSpaceObjectGenerator;
import org.dspace.statistics.content.DatasetGenerator;
import org.dspace.statistics.content.DatasetTimeGenerator;
import org.dspace.statistics.content.DatasetTypeGenerator;
import org.dspace.statistics.content.StatisticsData;
import org.dspace.statistics.content.StatisticsDataVisits;
import org.dspace.statistics.content.StatisticsListing;
import org.dspace.statistics.content.StatisticsTable;

public class DisplayStatisticsServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(DisplayStatisticsServlet.class);

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        boolean privatereport = ConfigurationManager.getBooleanProperty((String)"usage-statistics", (String)"authorization.admin.usage");
        boolean admin = Group.isMember((Context)context, (int)1);
        if (privatereport && !admin) {
            throw new AuthorizeException();
        }
        this.displayStatistics(context, request, response);
    }

    protected void displayStatistics(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        DatasetTypeGenerator typeAxis;
        StatisticsTable statisticsTable;
        List rowLabels;
        List colLabels;
        String[][] matrix;
        Dataset dataset;
        DatasetDSpaceObjectGenerator dsoAxis;
        DSpaceObject dso = null;
        String handle = request.getParameter("handle");
        if ("".equals(handle) || handle == null) {
            handle = (String)request.getAttribute("handle");
        }
        if (handle != null) {
            dso = HandleManager.resolveToObject((Context)context, (String)handle);
        }
        if (dso == null) {
            response.setStatus(404);
            JSPManager.showJSP(request, response, "/error/404.jsp");
            return;
        }
        boolean isItem = false;
        StatisticsBean statsVisits = new StatisticsBean();
        StatisticsBean statsMonthlyVisits = new StatisticsBean();
        StatisticsBean statsFileDownloads = new StatisticsBean();
        StatisticsBean statsCountryVisits = new StatisticsBean();
        StatisticsBean statsCityVisits = new StatisticsBean();
        try {
            StatisticsListing statListing = new StatisticsListing((StatisticsData)new StatisticsDataVisits(dso));
            statListing.setTitle("Total Visits");
            statListing.setId("list1");
            dsoAxis = new DatasetDSpaceObjectGenerator();
            dsoAxis.addDsoChild(dso.getType(), 10, false, -1);
            statListing.addDatasetGenerator((DatasetGenerator)dsoAxis);
            dataset = statListing.getDataset(context);
            dataset = statListing.getDataset();
            if (dataset == null) {
                dataset = statListing.getDataset(context);
            }
            if (dataset != null) {
                matrix = dataset.getMatrix();
                colLabels = dataset.getColLabels();
                rowLabels = dataset.getRowLabels();
                statsVisits.setMatrix(matrix);
                statsVisits.setColLabels(colLabels);
                statsVisits.setRowLabels(rowLabels);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while creating statistics for dso with ID: " + dso.getID() + " and type " + dso.getType() + " and handle: " + dso.getHandle()), (Throwable)e);
        }
        try {
            statisticsTable = new StatisticsTable((StatisticsData)new StatisticsDataVisits(dso));
            statisticsTable.setTitle("Total Visits Per Month");
            statisticsTable.setId("tab1");
            DatasetTimeGenerator timeAxis = new DatasetTimeGenerator();
            timeAxis.setDateInterval("month", "-6", "+1");
            statisticsTable.addDatasetGenerator((DatasetGenerator)timeAxis);
            DatasetDSpaceObjectGenerator dsoAxis2 = new DatasetDSpaceObjectGenerator();
            dsoAxis2.addDsoChild(dso.getType(), 10, false, -1);
            statisticsTable.addDatasetGenerator((DatasetGenerator)dsoAxis2);
            Dataset dataset2 = statisticsTable.getDataset(context);
            dataset2 = statisticsTable.getDataset();
            if (dataset2 == null) {
                dataset2 = statisticsTable.getDataset(context);
            }
            if (dataset2 != null) {
                String[][] matrix2 = dataset2.getMatrix();
                List colLabels2 = dataset2.getColLabels();
                List rowLabels2 = dataset2.getRowLabels();
                statsMonthlyVisits.setMatrix(matrix2);
                statsMonthlyVisits.setColLabels(colLabels2);
                statsMonthlyVisits.setRowLabels(rowLabels2);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while creating statistics for dso with ID: " + dso.getID() + " and type " + dso.getType() + " and handle: " + dso.getHandle()), (Throwable)e);
        }
        if (dso instanceof Item) {
            isItem = true;
            try {
                statisticsTable = new StatisticsListing((StatisticsData)new StatisticsDataVisits(dso));
                statisticsTable.setTitle("File Downloads");
                statisticsTable.setId("tab1");
                dsoAxis = new DatasetDSpaceObjectGenerator();
                dsoAxis.addDsoChild(0, 10, false, -1);
                statisticsTable.addDatasetGenerator((DatasetGenerator)dsoAxis);
                dataset = statisticsTable.getDataset(context);
                dataset = statisticsTable.getDataset();
                if (dataset == null) {
                    dataset = statisticsTable.getDataset(context);
                }
                if (dataset != null) {
                    matrix = dataset.getMatrix();
                    colLabels = dataset.getColLabels();
                    rowLabels = dataset.getRowLabels();
                    statsFileDownloads.setMatrix(matrix);
                    statsFileDownloads.setColLabels(colLabels);
                    statsFileDownloads.setRowLabels(rowLabels);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error occurred while creating statistics for dso with ID: " + dso.getID() + " and type " + dso.getType() + " and handle: " + dso.getHandle()), (Throwable)e);
            }
        }
        try {
            statisticsTable = new StatisticsListing((StatisticsData)new StatisticsDataVisits(dso));
            statisticsTable.setTitle("Top country views");
            statisticsTable.setId("tab1");
            typeAxis = new DatasetTypeGenerator();
            typeAxis.setType("countryCode");
            typeAxis.setMax(10);
            statisticsTable.addDatasetGenerator((DatasetGenerator)typeAxis);
            dataset = statisticsTable.getDataset(context);
            dataset = statisticsTable.getDataset();
            if (dataset == null) {
                dataset = statisticsTable.getDataset(context);
            }
            if (dataset != null) {
                matrix = dataset.getMatrix();
                colLabels = dataset.getColLabels();
                rowLabels = dataset.getRowLabels();
                statsCountryVisits.setMatrix(matrix);
                statsCountryVisits.setColLabels(colLabels);
                statsCountryVisits.setRowLabels(rowLabels);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while creating statistics for dso with ID: " + dso.getID() + " and type " + dso.getType() + " and handle: " + dso.getHandle()), (Throwable)e);
        }
        try {
            statisticsTable = new StatisticsListing((StatisticsData)new StatisticsDataVisits(dso));
            statisticsTable.setTitle("Top city views");
            statisticsTable.setId("tab1");
            typeAxis = new DatasetTypeGenerator();
            typeAxis.setType("city");
            typeAxis.setMax(10);
            statisticsTable.addDatasetGenerator((DatasetGenerator)typeAxis);
            dataset = statisticsTable.getDataset(context);
            dataset = statisticsTable.getDataset();
            if (dataset == null) {
                dataset = statisticsTable.getDataset(context);
            }
            if (dataset != null) {
                matrix = dataset.getMatrix();
                colLabels = dataset.getColLabels();
                rowLabels = dataset.getRowLabels();
                statsCityVisits.setMatrix(matrix);
                statsCityVisits.setColLabels(colLabels);
                statsCityVisits.setRowLabels(rowLabels);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while creating statistics for dso with ID: " + dso.getID() + " and type " + dso.getType() + " and handle: " + dso.getHandle()), (Throwable)e);
        }
        request.setAttribute("statsVisits", (Object)statsVisits);
        request.setAttribute("statsMonthlyVisits", (Object)statsMonthlyVisits);
        request.setAttribute("statsFileDownloads", (Object)statsFileDownloads);
        request.setAttribute("statsCountryVisits", (Object)statsCountryVisits);
        request.setAttribute("statsCityVisits", (Object)statsCityVisits);
        request.setAttribute("isItem", (Object)isItem);
        JSPManager.showJSP(request, response, "display-statistics.jsp");
    }
}

