/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.tagcloud;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.log4j.Logger;
import org.dspace.discovery.configuration.TagCloudConfiguration;
import org.mcavallo.opencloud.Cloud;
import org.mcavallo.opencloud.Tag;

public class TagCloudTag
extends SimpleTagSupport {
    private static Logger log = Logger.getLogger(TagCloudTag.class);
    TagCloudConfiguration parameters;
    Map<String, Integer> data;
    String index;
    String scope;
    String type = "0";

    public void doTag() throws JspException {
        PageContext pageContext = (PageContext)this.getJspContext();
        JspWriter out = pageContext.getOut();
        if (this.parameters == null) {
            this.parameters = new TagCloudConfiguration();
        }
        try {
            Cloud cloud = new Cloud();
            if (this.parameters.getCloudCase().equals("Case.LOWER")) {
                cloud.setTagCase(Cloud.Case.LOWER);
            } else if (this.parameters.getCloudCase().equals("Case.UPPER")) {
                cloud.setTagCase(Cloud.Case.UPPER);
            } else if (this.parameters.getCloudCase().equals("Case.CAPITALIZATION")) {
                cloud.setTagCase(Cloud.Case.CAPITALIZATION);
            } else if (this.parameters.getCloudCase().equals("Case.PRESERVE_CASE")) {
                cloud.setTagCase(Cloud.Case.PRESERVE_CASE);
            } else if (this.parameters.getCloudCase().equals("Case.CASE_SENSITIVE")) {
                cloud.setTagCase(Cloud.Case.CASE_SENSITIVE);
            }
            cloud.setMaxWeight(Double.parseDouble(this.parameters.getFontTo()));
            cloud.setMinWeight(Double.parseDouble(this.parameters.getFontFrom()));
            if (this.parameters.getTotalTags() == -1) {
                cloud.setMaxTagsToDisplay(1000000);
            } else {
                cloud.setMaxTagsToDisplay(this.parameters.getTotalTags());
            }
            for (String subject : this.data.keySet()) {
                if (this.data.get(subject) <= Integer.parseInt(this.parameters.getCuttingLevel())) continue;
                for (int i = 0; i < this.data.get(subject); ++i) {
                    Tag tag2 = new Tag(subject, ((HttpServletRequest)pageContext.getRequest()).getContextPath() + (this.scope != null ? this.scope : "") + (this.type.equals("0") ? "/simple-search?filterquery=" + URLEncoder.encode(subject, "UTF-8") + "&filtername=" + this.index + "&filtertype=equals" : "/browse?type=" + this.index + "&value=" + subject));
                    cloud.addTag(tag2);
                }
            }
            out.println("<div class=\"tagcloud\">");
            int counter = 0;
            List tagList = cloud.tags((Comparator)new Tag.NameComparatorAsc());
            if (this.parameters.getOrdering().equals("Tag.NameComparatorAsc")) {
                tagList = cloud.tags((Comparator)new Tag.NameComparatorAsc());
            } else if (this.parameters.getOrdering().equals("Tag.NameComparatorDesc")) {
                tagList = cloud.tags((Comparator)new Tag.NameComparatorDesc());
            } else if (this.parameters.getOrdering().equals("Tag.ScoreComparatorAsc")) {
                tagList = cloud.tags((Comparator)new Tag.ScoreComparatorAsc());
            } else if (this.parameters.getOrdering().equals("Tag.ScoreComparatorDesc")) {
                tagList = cloud.tags((Comparator)new Tag.ScoreComparatorDesc());
            }
            for (Tag tag : tagList) {
                String tagClass = "";
                if (this.parameters.isRandomColors()) {
                    if (counter == 0) {
                        tagClass = "tagcloud_1";
                    } else if (counter == 1) {
                        tagClass = "tagcloud_2";
                    } else if (counter == 2) {
                        tagClass = "tagcloud_3";
                    }
                } else if (tag.getNormScore() > (double)0.3f) {
                    tagClass = "tagcloud_1";
                } else if (tag.getNormScore() > (double)0.2f) {
                    tagClass = "tagcloud_2";
                } else if (tag.getNormScore() > (double)0.1f) {
                    tagClass = "tagcloud_3";
                }
                String scoreSup = "";
                if (this.parameters.isDisplayScore()) {
                    scoreSup = "<span class=\"tag_sup\"><sup>(" + tag.getScoreInt() + ")</sup></span>";
                }
                out.println("<a class=\"" + tagClass + "\" href=\"" + tag.getLink().replace(" & ", " %26 ") + "\" style=\"font-size: " + tag.getWeight() + "em;\">" + tag.getName() + scoreSup + "</a>");
                if (++counter != 3) continue;
                counter = 0;
            }
            out.println("</div>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setParameters(TagCloudConfiguration parameters) {
        this.parameters = parameters;
    }

    public void setData(Map<String, Integer> data) {
        this.data = data;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setType(String type) {
        this.type = type;
    }
}

