/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.FileUploadListener;
import org.dspace.core.ConfigurationManager;

public class FileUploadRequest
extends HttpServletRequestWrapper {
    public static final String FILE_UPLOAD_LISTNER = "file-upload-listner";
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, FileItem> fileitems = new HashMap<String, FileItem>();
    private List<String> filenames = new ArrayList<String>();
    private String tempDir = null;
    private static Logger log = Logger.getLogger(FileUploadRequest.class);
    private HttpServletRequest original = null;

    public FileUploadRequest(HttpServletRequest req) throws IOException, FileUploadBase.FileSizeLimitExceededException {
        super(req);
        this.original = req;
        this.tempDir = ConfigurationManager.getProperty((String)"upload.temp.dir") != null ? ConfigurationManager.getProperty((String)"upload.temp.dir") : System.getProperty("java.io.tmpdir");
        long maxSize = ConfigurationManager.getLongProperty((String)"upload.max");
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setRepository(new File(this.tempDir));
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        HttpSession session = req.getSession();
        if (ConfigurationManager.getBooleanProperty((String)"webui.submit.upload.progressbar", (boolean)true)) {
            FileUploadListener listener = new FileUploadListener();
            session.setAttribute(FILE_UPLOAD_LISTNER, (Object)listener);
            upload.setProgressListener((ProgressListener)listener);
        }
        try {
            upload.setSizeMax(maxSize);
            List items = upload.parseRequest(req);
            for (FileItem item : items) {
                String filename;
                if (item.isFormField()) {
                    this.parameters.put(item.getFieldName(), item.getString("UTF-8"));
                    continue;
                }
                if (this.parameters.containsKey("resumableIdentifier")) {
                    filename = this.getFilename(this.parameters.get("resumableFilename"));
                    if (StringUtils.isEmpty((String)filename)) continue;
                    String chunkDirPath = this.tempDir + File.separator + this.parameters.get("resumableIdentifier");
                    String chunkPath = chunkDirPath + File.separator + "part" + this.parameters.get("resumableChunkNumber");
                    File fileDir = new File(chunkDirPath);
                    if (!fileDir.getCanonicalPath().startsWith(this.tempDir)) {
                        log.error((Object)("Error processing resumable upload chunk: temporary chunk file would be created outside permissible temp dir (" + this.tempDir + ") for file: " + filename));
                        throw new IOException("Error processing resumable chunk directory " + chunkDirPath + " (filename: " + filename + "). Temporary upload directory would be created outside permissible base temp dir (" + this.tempDir + ")");
                    }
                    if (!fileDir.exists()) continue;
                    item.write(new File(chunkPath));
                    continue;
                }
                this.parameters.put(item.getFieldName(), item.getName());
                this.fileitems.put(item.getFieldName(), item);
                this.filenames.add(item.getName());
                filename = this.getFilename(item.getName());
                if (filename == null || "".equals(filename)) continue;
                File fileDir = new File(this.tempDir + File.separator + filename);
                if (!fileDir.getCanonicalPath().startsWith(this.tempDir)) {
                    log.error((Object)("Error processing resumable upload chunk: temporary chunk file would be created outside permissible temp dir (" + this.tempDir + ") for file: " + filename));
                    throw new IOException("Error processing resumable chunk directory " + fileDir + " (filename: " + filename + "). Temporary upload directory would be created outside permissible base temp dir (" + this.tempDir + ")");
                }
                item.write(fileDir);
            }
        }
        catch (FileUploadBase.IOFileUploadException e) {
            if (!e.getMessage().contains("Stream ended unexpectedly")) {
                throw new IOException(e.getMessage(), e);
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("exceeds the configured maximum")) {
                int startFirstParen = e.getMessage().indexOf("(") + 1;
                int endFirstParen = e.getMessage().indexOf(")");
                String uploadedSize = e.getMessage().substring(startFirstParen, endFirstParen).trim();
                Long actualSize = Long.parseLong(uploadedSize);
                throw new FileUploadBase.FileSizeLimitExceededException(e.getMessage(), actualSize.longValue(), maxSize);
            }
            throw new IOException(e.getMessage(), e);
        }
        finally {
            if (ConfigurationManager.getBooleanProperty((String)"webui.submit.upload.progressbar", (boolean)true)) {
                session.removeAttribute(FILE_UPLOAD_LISTNER);
            }
        }
    }

    public Enumeration getParameterNames() {
        Set<String> c = this.parameters.keySet();
        return Collections.enumeration(c);
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public String[] getParameterValues(String name) {
        return this.parameters.values().toArray(new String[this.parameters.values().size()]);
    }

    public Map getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration eNum = this.getParameterNames();
        while (eNum.hasMoreElements()) {
            String name = (String)eNum.nextElement();
            map.put(name, this.getParameterValues(name));
        }
        return map;
    }

    public String getFilesystemName(String name) {
        String filename = this.getFilename(this.fileitems.get(name).getName());
        return this.tempDir + File.separator + filename;
    }

    public String getContentType(String name) {
        return this.fileitems.get(name).getContentType();
    }

    public File getFile(String name) {
        FileItem temp = this.fileitems.get(name);
        String tempName = temp.getName();
        String filename = this.getFilename(tempName);
        if ("".equals(filename.trim())) {
            return null;
        }
        return new File(this.tempDir + File.separator + filename);
    }

    public Enumeration<String> getFileParameterNames() {
        Set<String> c = this.fileitems.keySet();
        return Collections.enumeration(c);
    }

    public Enumeration<String> getFileNames() {
        return Collections.enumeration(this.filenames);
    }

    public HttpServletRequest getOriginalRequest() {
        return this.original;
    }

    private String getFilename(String filepath) {
        String filename = filepath.trim();
        int index = filepath.lastIndexOf(File.separator);
        if (index > -1) {
            filename = filepath.substring(index);
        }
        return filename;
    }
}

