/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.AbstractBrowserServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowserScope;
import org.dspace.core.Context;

public class PrivateItemsServlet
extends AbstractBrowserServlet {
    private static Logger log = Logger.getLogger(PrivateItemsServlet.class);

    @Override
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        try {
            BrowserScope scope = this.getBrowserScopeForRequest(context, request, response);
            if (scope.getBrowseIndex() == null || scope.getBrowseIndex().isItemIndex()) {
                scope.setBrowseIndex(BrowseIndex.getPrivateBrowseIndex());
            } else {
                this.showError(context, request, response);
            }
            this.processBrowse(context, scope, request, response);
        }
        catch (BrowseException be) {
            log.error((Object)"caught exception: ", (Throwable)be);
            throw new ServletException((Throwable)be);
        }
    }

    @Override
    protected void showError(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        request.setAttribute("useAdminLayout", (Object)"yes");
        JSPManager.showInternalError(request, response);
    }

    @Override
    protected void showNoResultsPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        request.setAttribute("browsePrivate", (Object)"yes");
        JSPManager.showJSP(request, response, "/browse/no-results.jsp");
    }

    @Override
    protected void showSinglePage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.showError(context, request, response);
    }

    @Override
    protected void showFullPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        request.setAttribute("browsePrivate", (Object)"yes");
        JSPManager.showJSP(request, response, "/browse/full.jsp");
    }
}

