/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.webui.submit.JSPStep;
import org.dspace.app.webui.submit.JSPStepManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.core.Context;

public class JSPInitialQuestionsStep
extends JSPStep {
    private static final String INITIAL_QUESTIONS_JSP = "/submit/initial-questions.jsp";
    private static final String VERIFY_PRUNE_JSP = "/submit/verify-prune.jsp";
    private static final String NO_THESES_JSP = "/submit/no-theses.jsp";
    private static final String REVIEW_JSP = "/submit/review-init.jsp";

    @Override
    public void doPreProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        this.showInitialQuestions(context, request, response, subInfo);
    }

    @Override
    public void doPostProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, int status) throws ServletException, IOException, SQLException, AuthorizeException {
        boolean multipleTitles = UIUtil.getBoolParameter((HttpServletRequest)request, (String)"multiple_titles");
        boolean publishedBefore = UIUtil.getBoolParameter((HttpServletRequest)request, (String)"published_before");
        boolean multipleFiles = UIUtil.getBoolParameter((HttpServletRequest)request, (String)"multiple_files");
        if (JSPStepManager.getLastJSPDisplayed(request).equals(VERIFY_PRUNE_JSP)) {
            if (status == 2) {
                this.showInitialQuestions(context, request, response, subInfo);
                return;
            }
        } else {
            if (status == 3) {
                JSPStepManager.showJSP(request, response, subInfo, NO_THESES_JSP);
                return;
            }
            if (status == 1) {
                this.showVerifyPrune(context, request, response, subInfo, multipleTitles, publishedBefore, multipleFiles);
                return;
            }
        }
    }

    private void showInitialQuestions(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws SQLException, ServletException, IOException {
        Collection c = subInfo.getSubmissionItem().getCollection();
        try {
            DCInputsReader inputsReader = new DCInputsReader();
            request.setAttribute("submission.inputs", (Object)inputsReader.getInputs(c.getHandle()));
        }
        catch (DCInputsReaderException e) {
            throw new ServletException((Throwable)e);
        }
        JSPStepManager.showJSP(request, response, subInfo, INITIAL_QUESTIONS_JSP);
    }

    private void showVerifyPrune(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, boolean multipleTitles, boolean publishedBefore, boolean multipleFiles) throws SQLException, ServletException, IOException {
        request.setAttribute("multiple.titles", (Object)multipleTitles);
        request.setAttribute("published.before", (Object)publishedBefore);
        request.setAttribute("multiple.files", (Object)multipleFiles);
        request.setAttribute("button.pressed", (Object)UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_next"));
        JSPStepManager.showJSP(request, response, subInfo, VERIFY_PRUNE_JSP);
    }

    @Override
    public String getReviewJSP(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) {
        return REVIEW_JSP;
    }
}

